// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: cmpserver/plugin/plugin.proto

package apiclient

import (
	context "context"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	_ "k8s.io/api/core/v1"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// ManifestRequest is a query for manifest generation.
type ManifestRequest struct {
	// Name of the application for which the request is triggered
	AppName              string      `protobuf:"bytes,1,opt,name=appName,proto3" json:"appName,omitempty"`
	AppPath              string      `protobuf:"bytes,2,opt,name=appPath,proto3" json:"appPath,omitempty"`
	RepoPath             string      `protobuf:"bytes,3,opt,name=repoPath,proto3" json:"repoPath,omitempty"`
	NoCache              bool        `protobuf:"varint,4,opt,name=noCache,proto3" json:"noCache,omitempty"`
	Env                  []*EnvEntry `protobuf:"bytes,5,rep,name=env,proto3" json:"env,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ManifestRequest) Reset()         { *m = ManifestRequest{} }
func (m *ManifestRequest) String() string { return proto.CompactTextString(m) }
func (*ManifestRequest) ProtoMessage()    {}
func (*ManifestRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b21875a7079a06ed, []int{0}
}
func (m *ManifestRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ManifestRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ManifestRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ManifestRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManifestRequest.Merge(m, src)
}
func (m *ManifestRequest) XXX_Size() int {
	return m.Size()
}
func (m *ManifestRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ManifestRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ManifestRequest proto.InternalMessageInfo

func (m *ManifestRequest) GetAppName() string {
	if m != nil {
		return m.AppName
	}
	return ""
}

func (m *ManifestRequest) GetAppPath() string {
	if m != nil {
		return m.AppPath
	}
	return ""
}

func (m *ManifestRequest) GetRepoPath() string {
	if m != nil {
		return m.RepoPath
	}
	return ""
}

func (m *ManifestRequest) GetNoCache() bool {
	if m != nil {
		return m.NoCache
	}
	return false
}

func (m *ManifestRequest) GetEnv() []*EnvEntry {
	if m != nil {
		return m.Env
	}
	return nil
}

// EnvEntry represents an entry in the application's environment
type EnvEntry struct {
	// Name is the name of the variable, usually expressed in uppercase
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Value is the value of the variable
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnvEntry) Reset()         { *m = EnvEntry{} }
func (m *EnvEntry) String() string { return proto.CompactTextString(m) }
func (*EnvEntry) ProtoMessage()    {}
func (*EnvEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_b21875a7079a06ed, []int{1}
}
func (m *EnvEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *EnvEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_EnvEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *EnvEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnvEntry.Merge(m, src)
}
func (m *EnvEntry) XXX_Size() int {
	return m.Size()
}
func (m *EnvEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_EnvEntry.DiscardUnknown(m)
}

var xxx_messageInfo_EnvEntry proto.InternalMessageInfo

func (m *EnvEntry) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EnvEntry) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type ManifestResponse struct {
	Manifests            []string `protobuf:"bytes,1,rep,name=manifests,proto3" json:"manifests,omitempty"`
	SourceType           string   `protobuf:"bytes,2,opt,name=sourceType,proto3" json:"sourceType,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ManifestResponse) Reset()         { *m = ManifestResponse{} }
func (m *ManifestResponse) String() string { return proto.CompactTextString(m) }
func (*ManifestResponse) ProtoMessage()    {}
func (*ManifestResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b21875a7079a06ed, []int{2}
}
func (m *ManifestResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ManifestResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ManifestResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ManifestResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManifestResponse.Merge(m, src)
}
func (m *ManifestResponse) XXX_Size() int {
	return m.Size()
}
func (m *ManifestResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ManifestResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ManifestResponse proto.InternalMessageInfo

func (m *ManifestResponse) GetManifests() []string {
	if m != nil {
		return m.Manifests
	}
	return nil
}

func (m *ManifestResponse) GetSourceType() string {
	if m != nil {
		return m.SourceType
	}
	return ""
}

type RepositoryRequest struct {
	Path                 string      `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Env                  []*EnvEntry `protobuf:"bytes,2,rep,name=env,proto3" json:"env,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *RepositoryRequest) Reset()         { *m = RepositoryRequest{} }
func (m *RepositoryRequest) String() string { return proto.CompactTextString(m) }
func (*RepositoryRequest) ProtoMessage()    {}
func (*RepositoryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b21875a7079a06ed, []int{3}
}
func (m *RepositoryRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RepositoryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RepositoryRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RepositoryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RepositoryRequest.Merge(m, src)
}
func (m *RepositoryRequest) XXX_Size() int {
	return m.Size()
}
func (m *RepositoryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RepositoryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RepositoryRequest proto.InternalMessageInfo

func (m *RepositoryRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *RepositoryRequest) GetEnv() []*EnvEntry {
	if m != nil {
		return m.Env
	}
	return nil
}

type RepositoryResponse struct {
	IsSupported          bool     `protobuf:"varint,1,opt,name=isSupported,proto3" json:"isSupported,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RepositoryResponse) Reset()         { *m = RepositoryResponse{} }
func (m *RepositoryResponse) String() string { return proto.CompactTextString(m) }
func (*RepositoryResponse) ProtoMessage()    {}
func (*RepositoryResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b21875a7079a06ed, []int{4}
}
func (m *RepositoryResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RepositoryResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RepositoryResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RepositoryResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RepositoryResponse.Merge(m, src)
}
func (m *RepositoryResponse) XXX_Size() int {
	return m.Size()
}
func (m *RepositoryResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RepositoryResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RepositoryResponse proto.InternalMessageInfo

func (m *RepositoryResponse) GetIsSupported() bool {
	if m != nil {
		return m.IsSupported
	}
	return false
}

type ConfigRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfigRequest) Reset()         { *m = ConfigRequest{} }
func (m *ConfigRequest) String() string { return proto.CompactTextString(m) }
func (*ConfigRequest) ProtoMessage()    {}
func (*ConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_b21875a7079a06ed, []int{5}
}
func (m *ConfigRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigRequest.Merge(m, src)
}
func (m *ConfigRequest) XXX_Size() int {
	return m.Size()
}
func (m *ConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigRequest proto.InternalMessageInfo

type ConfigResponse struct {
	AllowConcurrency     bool     `protobuf:"varint,1,opt,name=allowConcurrency,proto3" json:"allowConcurrency,omitempty"`
	LockRepo             bool     `protobuf:"varint,2,opt,name=lockRepo,proto3" json:"lockRepo,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ConfigResponse) Reset()         { *m = ConfigResponse{} }
func (m *ConfigResponse) String() string { return proto.CompactTextString(m) }
func (*ConfigResponse) ProtoMessage()    {}
func (*ConfigResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_b21875a7079a06ed, []int{6}
}
func (m *ConfigResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ConfigResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ConfigResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ConfigResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ConfigResponse.Merge(m, src)
}
func (m *ConfigResponse) XXX_Size() int {
	return m.Size()
}
func (m *ConfigResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ConfigResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ConfigResponse proto.InternalMessageInfo

func (m *ConfigResponse) GetAllowConcurrency() bool {
	if m != nil {
		return m.AllowConcurrency
	}
	return false
}

func (m *ConfigResponse) GetLockRepo() bool {
	if m != nil {
		return m.LockRepo
	}
	return false
}

func init() {
	proto.RegisterType((*ManifestRequest)(nil), "plugin.ManifestRequest")
	proto.RegisterType((*EnvEntry)(nil), "plugin.EnvEntry")
	proto.RegisterType((*ManifestResponse)(nil), "plugin.ManifestResponse")
	proto.RegisterType((*RepositoryRequest)(nil), "plugin.RepositoryRequest")
	proto.RegisterType((*RepositoryResponse)(nil), "plugin.RepositoryResponse")
	proto.RegisterType((*ConfigRequest)(nil), "plugin.ConfigRequest")
	proto.RegisterType((*ConfigResponse)(nil), "plugin.ConfigResponse")
}

func init() { proto.RegisterFile("cmpserver/plugin/plugin.proto", fileDescriptor_b21875a7079a06ed) }

var fileDescriptor_b21875a7079a06ed = []byte{
	// 501 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x7c, 0x53, 0xdd, 0x6e, 0xd3, 0x30,
	0x18, 0x25, 0x6b, 0x37, 0xda, 0x6f, 0x82, 0x16, 0x8b, 0x9f, 0x10, 0xb1, 0xaa, 0xca, 0x55, 0x85,
	0x44, 0x23, 0x0a, 0x42, 0x5c, 0xa2, 0x55, 0x53, 0x25, 0xd0, 0x50, 0x95, 0x71, 0x81, 0xb8, 0xf3,
	0xdc, 0x6f, 0xa9, 0x59, 0x6a, 0x1b, 0xc7, 0x09, 0xea, 0xd3, 0xf0, 0x3a, 0x5c, 0xf2, 0x08, 0xa8,
	0x4f, 0xc1, 0x25, 0x4a, 0x62, 0x37, 0x65, 0x45, 0xbb, 0x8a, 0xcf, 0x39, 0xf6, 0xd1, 0x39, 0x5f,
	0x6c, 0x38, 0x61, 0x2b, 0x95, 0xa1, 0x2e, 0x50, 0x47, 0x2a, 0xcd, 0x13, 0x2e, 0xec, 0x67, 0xac,
	0xb4, 0x34, 0x92, 0x1c, 0xd5, 0x28, 0x08, 0xaf, 0xdf, 0x66, 0x63, 0x2e, 0x23, 0xaa, 0x78, 0xc4,
	0xa4, 0xc6, 0xa8, 0x78, 0x19, 0x25, 0x28, 0x50, 0x53, 0x83, 0x8b, 0x7a, 0x6f, 0xf8, 0xc3, 0x83,
	0xde, 0x39, 0x15, 0xfc, 0x0a, 0x33, 0x13, 0xe3, 0xb7, 0x1c, 0x33, 0x43, 0x7c, 0xb8, 0x4b, 0x95,
	0xfa, 0x48, 0x57, 0xe8, 0x7b, 0x43, 0x6f, 0xd4, 0x8d, 0x1d, 0xb4, 0xca, 0x9c, 0x9a, 0xa5, 0x7f,
	0xb0, 0x55, 0x4a, 0x48, 0x02, 0xe8, 0x68, 0x54, 0xb2, 0x92, 0x5a, 0x95, 0xb4, 0xc5, 0xe5, 0x29,
	0x21, 0xa7, 0x94, 0x2d, 0xd1, 0x6f, 0x0f, 0xbd, 0x51, 0x27, 0x76, 0x90, 0x84, 0xd0, 0x42, 0x51,
	0xf8, 0x87, 0xc3, 0xd6, 0xe8, 0x78, 0xd2, 0x1f, 0xdb, 0x16, 0x67, 0xa2, 0x38, 0x13, 0x46, 0xaf,
	0xe3, 0x52, 0x0c, 0x5f, 0x43, 0xc7, 0x11, 0x84, 0x40, 0x5b, 0x34, 0xb1, 0xaa, 0x35, 0x79, 0x08,
	0x87, 0x05, 0x4d, 0x73, 0xb4, 0x89, 0x6a, 0x10, 0xce, 0xa1, 0xdf, 0xd4, 0xca, 0x94, 0x14, 0x19,
	0x92, 0x67, 0xd0, 0x5d, 0x59, 0x2e, 0xf3, 0xbd, 0x61, 0x6b, 0xd4, 0x8d, 0x1b, 0x82, 0x0c, 0x00,
	0x32, 0x99, 0x6b, 0x86, 0x9f, 0xd6, 0xca, 0x99, 0xed, 0x30, 0xe1, 0x07, 0x78, 0x10, 0xa3, 0x92,
	0x19, 0x37, 0x52, 0xaf, 0xdd, 0xa8, 0x08, 0xb4, 0x55, 0x59, 0xd9, 0x06, 0x2a, 0xd7, 0xae, 0xd4,
	0xc1, 0x6d, 0xa5, 0xde, 0x00, 0xd9, 0x35, 0xb3, 0x01, 0x87, 0x70, 0xcc, 0xb3, 0x8b, 0x5c, 0x29,
	0xa9, 0x0d, 0x2e, 0x2a, 0xd3, 0x4e, 0xbc, 0x4b, 0x85, 0x3d, 0xb8, 0x37, 0x95, 0xe2, 0x8a, 0x27,
	0x36, 0x40, 0xf8, 0x19, 0xee, 0x3b, 0xc2, 0x9a, 0x3c, 0x87, 0x3e, 0x4d, 0x53, 0xf9, 0x7d, 0x2a,
	0x05, 0xcb, 0xb5, 0x46, 0xc1, 0xd6, 0xd6, 0x69, 0x8f, 0x2f, 0xff, 0x5a, 0x2a, 0xd9, 0x75, 0x19,
	0xa5, 0x6a, 0xdc, 0x89, 0xb7, 0x78, 0xf2, 0xc7, 0x83, 0x93, 0xda, 0xfa, 0x9c, 0x0a, 0x9a, 0xe0,
	0x0a, 0x85, 0x99, 0x57, 0x5d, 0x2e, 0x50, 0x17, 0x9c, 0x21, 0x99, 0x41, 0x7f, 0x66, 0xaf, 0x93,
	0x9b, 0x35, 0x79, 0xe2, 0xfa, 0xde, 0xb8, 0x54, 0x81, 0xbf, 0x2f, 0xd4, 0x81, 0xc3, 0x3b, 0xe4,
	0x7d, 0x79, 0x07, 0x0d, 0x5b, 0x36, 0x23, 0x21, 0x4f, 0xdd, 0xf6, 0xbd, 0x99, 0x07, 0xc1, 0xff,
	0xa4, 0xad, 0xd7, 0x29, 0xf4, 0x66, 0x68, 0x83, 0xd6, 0xf1, 0xc9, 0x23, 0x77, 0xe0, 0x9f, 0xd1,
	0x05, 0x8f, 0x6f, 0xd2, 0xce, 0xe3, 0xf4, 0xdd, 0xcf, 0xcd, 0xc0, 0xfb, 0xb5, 0x19, 0x78, 0xbf,
	0x37, 0x03, 0xef, 0xcb, 0x24, 0xe1, 0x66, 0x99, 0x5f, 0x8e, 0x99, 0x5c, 0x45, 0x54, 0x27, 0x52,
	0x69, 0xf9, 0xb5, 0x5a, 0xbc, 0x60, 0x8b, 0xa8, 0x98, 0x44, 0xcd, 0x63, 0xa4, 0x8a, 0xb3, 0x94,
	0xa3, 0x30, 0x97, 0x47, 0xd5, 0xeb, 0x7a, 0xf5, 0x37, 0x00, 0x00, 0xff, 0xff, 0x6e, 0xfe, 0x31,
	0x8a, 0xaa, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ConfigManagementPluginServiceClient is the client API for ConfigManagementPluginService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConfigManagementPluginServiceClient interface {
	// GenerateManifest generates manifest for application in specified repo name and revision
	GenerateManifest(ctx context.Context, in *ManifestRequest, opts ...grpc.CallOption) (*ManifestResponse, error)
	// MatchRepository returns whether or not the given path is supported by the plugin
	MatchRepository(ctx context.Context, in *RepositoryRequest, opts ...grpc.CallOption) (*RepositoryResponse, error)
	// Get configuration of the plugin
	GetPluginConfig(ctx context.Context, in *ConfigRequest, opts ...grpc.CallOption) (*ConfigResponse, error)
}

type configManagementPluginServiceClient struct {
	cc *grpc.ClientConn
}

func NewConfigManagementPluginServiceClient(cc *grpc.ClientConn) ConfigManagementPluginServiceClient {
	return &configManagementPluginServiceClient{cc}
}

func (c *configManagementPluginServiceClient) GenerateManifest(ctx context.Context, in *ManifestRequest, opts ...grpc.CallOption) (*ManifestResponse, error) {
	out := new(ManifestResponse)
	err := c.cc.Invoke(ctx, "/plugin.ConfigManagementPluginService/GenerateManifest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configManagementPluginServiceClient) MatchRepository(ctx context.Context, in *RepositoryRequest, opts ...grpc.CallOption) (*RepositoryResponse, error) {
	out := new(RepositoryResponse)
	err := c.cc.Invoke(ctx, "/plugin.ConfigManagementPluginService/MatchRepository", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configManagementPluginServiceClient) GetPluginConfig(ctx context.Context, in *ConfigRequest, opts ...grpc.CallOption) (*ConfigResponse, error) {
	out := new(ConfigResponse)
	err := c.cc.Invoke(ctx, "/plugin.ConfigManagementPluginService/GetPluginConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConfigManagementPluginServiceServer is the server API for ConfigManagementPluginService service.
type ConfigManagementPluginServiceServer interface {
	// GenerateManifest generates manifest for application in specified repo name and revision
	GenerateManifest(context.Context, *ManifestRequest) (*ManifestResponse, error)
	// MatchRepository returns whether or not the given path is supported by the plugin
	MatchRepository(context.Context, *RepositoryRequest) (*RepositoryResponse, error)
	// Get configuration of the plugin
	GetPluginConfig(context.Context, *ConfigRequest) (*ConfigResponse, error)
}

// UnimplementedConfigManagementPluginServiceServer can be embedded to have forward compatible implementations.
type UnimplementedConfigManagementPluginServiceServer struct {
}

func (*UnimplementedConfigManagementPluginServiceServer) GenerateManifest(ctx context.Context, req *ManifestRequest) (*ManifestResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateManifest not implemented")
}
func (*UnimplementedConfigManagementPluginServiceServer) MatchRepository(ctx context.Context, req *RepositoryRequest) (*RepositoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MatchRepository not implemented")
}
func (*UnimplementedConfigManagementPluginServiceServer) GetPluginConfig(ctx context.Context, req *ConfigRequest) (*ConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPluginConfig not implemented")
}

func RegisterConfigManagementPluginServiceServer(s *grpc.Server, srv ConfigManagementPluginServiceServer) {
	s.RegisterService(&_ConfigManagementPluginService_serviceDesc, srv)
}

func _ConfigManagementPluginService_GenerateManifest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ManifestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigManagementPluginServiceServer).GenerateManifest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/plugin.ConfigManagementPluginService/GenerateManifest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigManagementPluginServiceServer).GenerateManifest(ctx, req.(*ManifestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigManagementPluginService_MatchRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigManagementPluginServiceServer).MatchRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/plugin.ConfigManagementPluginService/MatchRepository",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigManagementPluginServiceServer).MatchRepository(ctx, req.(*RepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConfigManagementPluginService_GetPluginConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigManagementPluginServiceServer).GetPluginConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/plugin.ConfigManagementPluginService/GetPluginConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigManagementPluginServiceServer).GetPluginConfig(ctx, req.(*ConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ConfigManagementPluginService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "plugin.ConfigManagementPluginService",
	HandlerType: (*ConfigManagementPluginServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GenerateManifest",
			Handler:    _ConfigManagementPluginService_GenerateManifest_Handler,
		},
		{
			MethodName: "MatchRepository",
			Handler:    _ConfigManagementPluginService_MatchRepository_Handler,
		},
		{
			MethodName: "GetPluginConfig",
			Handler:    _ConfigManagementPluginService_GetPluginConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "cmpserver/plugin/plugin.proto",
}

func (m *ManifestRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ManifestRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ManifestRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Env) > 0 {
		for iNdEx := len(m.Env) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Env[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlugin(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.NoCache {
		i--
		if m.NoCache {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.RepoPath) > 0 {
		i -= len(m.RepoPath)
		copy(dAtA[i:], m.RepoPath)
		i = encodeVarintPlugin(dAtA, i, uint64(len(m.RepoPath)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.AppPath) > 0 {
		i -= len(m.AppPath)
		copy(dAtA[i:], m.AppPath)
		i = encodeVarintPlugin(dAtA, i, uint64(len(m.AppPath)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.AppName) > 0 {
		i -= len(m.AppName)
		copy(dAtA[i:], m.AppName)
		i = encodeVarintPlugin(dAtA, i, uint64(len(m.AppName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *EnvEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EnvEntry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *EnvEntry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintPlugin(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintPlugin(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ManifestResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ManifestResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ManifestResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SourceType) > 0 {
		i -= len(m.SourceType)
		copy(dAtA[i:], m.SourceType)
		i = encodeVarintPlugin(dAtA, i, uint64(len(m.SourceType)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Manifests) > 0 {
		for iNdEx := len(m.Manifests) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Manifests[iNdEx])
			copy(dAtA[i:], m.Manifests[iNdEx])
			i = encodeVarintPlugin(dAtA, i, uint64(len(m.Manifests[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *RepositoryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RepositoryRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RepositoryRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Env) > 0 {
		for iNdEx := len(m.Env) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Env[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlugin(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintPlugin(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RepositoryResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RepositoryResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RepositoryResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsSupported {
		i--
		if m.IsSupported {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ConfigRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	return len(dAtA) - i, nil
}

func (m *ConfigResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ConfigResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LockRepo {
		i--
		if m.LockRepo {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.AllowConcurrency {
		i--
		if m.AllowConcurrency {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintPlugin(dAtA []byte, offset int, v uint64) int {
	offset -= sovPlugin(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ManifestRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AppName)
	if l > 0 {
		n += 1 + l + sovPlugin(uint64(l))
	}
	l = len(m.AppPath)
	if l > 0 {
		n += 1 + l + sovPlugin(uint64(l))
	}
	l = len(m.RepoPath)
	if l > 0 {
		n += 1 + l + sovPlugin(uint64(l))
	}
	if m.NoCache {
		n += 2
	}
	if len(m.Env) > 0 {
		for _, e := range m.Env {
			l = e.Size()
			n += 1 + l + sovPlugin(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *EnvEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovPlugin(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovPlugin(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ManifestResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Manifests) > 0 {
		for _, s := range m.Manifests {
			l = len(s)
			n += 1 + l + sovPlugin(uint64(l))
		}
	}
	l = len(m.SourceType)
	if l > 0 {
		n += 1 + l + sovPlugin(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RepositoryRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovPlugin(uint64(l))
	}
	if len(m.Env) > 0 {
		for _, e := range m.Env {
			l = e.Size()
			n += 1 + l + sovPlugin(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RepositoryResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IsSupported {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ConfigResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AllowConcurrency {
		n += 2
	}
	if m.LockRepo {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovPlugin(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPlugin(x uint64) (n int) {
	return sovPlugin(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ManifestRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlugin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManifestRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManifestRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlugin
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlugin
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AppName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AppPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlugin
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlugin
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AppPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RepoPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlugin
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlugin
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RepoPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NoCache", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NoCache = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Env", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlugin
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlugin
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Env = append(m.Env, &EnvEntry{})
			if err := m.Env[len(m.Env)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlugin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlugin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EnvEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlugin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlugin
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlugin
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlugin
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlugin
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlugin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlugin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ManifestResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlugin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ManifestResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ManifestResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Manifests", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlugin
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlugin
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Manifests = append(m.Manifests, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlugin
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlugin
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlugin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlugin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RepositoryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlugin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RepositoryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RepositoryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlugin
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlugin
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Env", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlugin
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlugin
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Env = append(m.Env, &EnvEntry{})
			if err := m.Env[len(m.Env)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlugin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlugin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RepositoryResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlugin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RepositoryResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RepositoryResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsSupported", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsSupported = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipPlugin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlugin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlugin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipPlugin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlugin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlugin
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowConcurrency", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowConcurrency = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LockRepo", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LockRepo = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipPlugin(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthPlugin
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPlugin(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPlugin
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPlugin
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPlugin
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupPlugin
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthPlugin
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthPlugin        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPlugin          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupPlugin = fmt.Errorf("proto: unexpected end of group")
)
