// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package amplifybackendiface provides an interface to enable mocking the AmplifyBackend service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package amplifybackendiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/amplifybackend"
)

// AmplifyBackendAPI provides an interface to enable mocking the
// amplifybackend.AmplifyBackend service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AmplifyBackend.
//    func myFunc(svc amplifybackendiface.AmplifyBackendAPI) bool {
//        // Make svc.CloneBackend request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := amplifybackend.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockAmplifyBackendClient struct {
//        amplifybackendiface.AmplifyBackendAPI
//    }
//    func (m *mockAmplifyBackendClient) CloneBackend(input *amplifybackend.CloneBackendInput) (*amplifybackend.CloneBackendOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockAmplifyBackendClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type AmplifyBackendAPI interface {
	CloneBackend(*amplifybackend.CloneBackendInput) (*amplifybackend.CloneBackendOutput, error)
	CloneBackendWithContext(aws.Context, *amplifybackend.CloneBackendInput, ...request.Option) (*amplifybackend.CloneBackendOutput, error)
	CloneBackendRequest(*amplifybackend.CloneBackendInput) (*request.Request, *amplifybackend.CloneBackendOutput)

	CreateBackend(*amplifybackend.CreateBackendInput) (*amplifybackend.CreateBackendOutput, error)
	CreateBackendWithContext(aws.Context, *amplifybackend.CreateBackendInput, ...request.Option) (*amplifybackend.CreateBackendOutput, error)
	CreateBackendRequest(*amplifybackend.CreateBackendInput) (*request.Request, *amplifybackend.CreateBackendOutput)

	CreateBackendAPI(*amplifybackend.CreateBackendAPIInput) (*amplifybackend.CreateBackendAPIOutput, error)
	CreateBackendAPIWithContext(aws.Context, *amplifybackend.CreateBackendAPIInput, ...request.Option) (*amplifybackend.CreateBackendAPIOutput, error)
	CreateBackendAPIRequest(*amplifybackend.CreateBackendAPIInput) (*request.Request, *amplifybackend.CreateBackendAPIOutput)

	CreateBackendAuth(*amplifybackend.CreateBackendAuthInput) (*amplifybackend.CreateBackendAuthOutput, error)
	CreateBackendAuthWithContext(aws.Context, *amplifybackend.CreateBackendAuthInput, ...request.Option) (*amplifybackend.CreateBackendAuthOutput, error)
	CreateBackendAuthRequest(*amplifybackend.CreateBackendAuthInput) (*request.Request, *amplifybackend.CreateBackendAuthOutput)

	CreateBackendConfig(*amplifybackend.CreateBackendConfigInput) (*amplifybackend.CreateBackendConfigOutput, error)
	CreateBackendConfigWithContext(aws.Context, *amplifybackend.CreateBackendConfigInput, ...request.Option) (*amplifybackend.CreateBackendConfigOutput, error)
	CreateBackendConfigRequest(*amplifybackend.CreateBackendConfigInput) (*request.Request, *amplifybackend.CreateBackendConfigOutput)

	CreateToken(*amplifybackend.CreateTokenInput) (*amplifybackend.CreateTokenOutput, error)
	CreateTokenWithContext(aws.Context, *amplifybackend.CreateTokenInput, ...request.Option) (*amplifybackend.CreateTokenOutput, error)
	CreateTokenRequest(*amplifybackend.CreateTokenInput) (*request.Request, *amplifybackend.CreateTokenOutput)

	DeleteBackend(*amplifybackend.DeleteBackendInput) (*amplifybackend.DeleteBackendOutput, error)
	DeleteBackendWithContext(aws.Context, *amplifybackend.DeleteBackendInput, ...request.Option) (*amplifybackend.DeleteBackendOutput, error)
	DeleteBackendRequest(*amplifybackend.DeleteBackendInput) (*request.Request, *amplifybackend.DeleteBackendOutput)

	DeleteBackendAPI(*amplifybackend.DeleteBackendAPIInput) (*amplifybackend.DeleteBackendAPIOutput, error)
	DeleteBackendAPIWithContext(aws.Context, *amplifybackend.DeleteBackendAPIInput, ...request.Option) (*amplifybackend.DeleteBackendAPIOutput, error)
	DeleteBackendAPIRequest(*amplifybackend.DeleteBackendAPIInput) (*request.Request, *amplifybackend.DeleteBackendAPIOutput)

	DeleteBackendAuth(*amplifybackend.DeleteBackendAuthInput) (*amplifybackend.DeleteBackendAuthOutput, error)
	DeleteBackendAuthWithContext(aws.Context, *amplifybackend.DeleteBackendAuthInput, ...request.Option) (*amplifybackend.DeleteBackendAuthOutput, error)
	DeleteBackendAuthRequest(*amplifybackend.DeleteBackendAuthInput) (*request.Request, *amplifybackend.DeleteBackendAuthOutput)

	DeleteToken(*amplifybackend.DeleteTokenInput) (*amplifybackend.DeleteTokenOutput, error)
	DeleteTokenWithContext(aws.Context, *amplifybackend.DeleteTokenInput, ...request.Option) (*amplifybackend.DeleteTokenOutput, error)
	DeleteTokenRequest(*amplifybackend.DeleteTokenInput) (*request.Request, *amplifybackend.DeleteTokenOutput)

	GenerateBackendAPIModels(*amplifybackend.GenerateBackendAPIModelsInput) (*amplifybackend.GenerateBackendAPIModelsOutput, error)
	GenerateBackendAPIModelsWithContext(aws.Context, *amplifybackend.GenerateBackendAPIModelsInput, ...request.Option) (*amplifybackend.GenerateBackendAPIModelsOutput, error)
	GenerateBackendAPIModelsRequest(*amplifybackend.GenerateBackendAPIModelsInput) (*request.Request, *amplifybackend.GenerateBackendAPIModelsOutput)

	GetBackend(*amplifybackend.GetBackendInput) (*amplifybackend.GetBackendOutput, error)
	GetBackendWithContext(aws.Context, *amplifybackend.GetBackendInput, ...request.Option) (*amplifybackend.GetBackendOutput, error)
	GetBackendRequest(*amplifybackend.GetBackendInput) (*request.Request, *amplifybackend.GetBackendOutput)

	GetBackendAPI(*amplifybackend.GetBackendAPIInput) (*amplifybackend.GetBackendAPIOutput, error)
	GetBackendAPIWithContext(aws.Context, *amplifybackend.GetBackendAPIInput, ...request.Option) (*amplifybackend.GetBackendAPIOutput, error)
	GetBackendAPIRequest(*amplifybackend.GetBackendAPIInput) (*request.Request, *amplifybackend.GetBackendAPIOutput)

	GetBackendAPIModels(*amplifybackend.GetBackendAPIModelsInput) (*amplifybackend.GetBackendAPIModelsOutput, error)
	GetBackendAPIModelsWithContext(aws.Context, *amplifybackend.GetBackendAPIModelsInput, ...request.Option) (*amplifybackend.GetBackendAPIModelsOutput, error)
	GetBackendAPIModelsRequest(*amplifybackend.GetBackendAPIModelsInput) (*request.Request, *amplifybackend.GetBackendAPIModelsOutput)

	GetBackendAuth(*amplifybackend.GetBackendAuthInput) (*amplifybackend.GetBackendAuthOutput, error)
	GetBackendAuthWithContext(aws.Context, *amplifybackend.GetBackendAuthInput, ...request.Option) (*amplifybackend.GetBackendAuthOutput, error)
	GetBackendAuthRequest(*amplifybackend.GetBackendAuthInput) (*request.Request, *amplifybackend.GetBackendAuthOutput)

	GetBackendJob(*amplifybackend.GetBackendJobInput) (*amplifybackend.GetBackendJobOutput, error)
	GetBackendJobWithContext(aws.Context, *amplifybackend.GetBackendJobInput, ...request.Option) (*amplifybackend.GetBackendJobOutput, error)
	GetBackendJobRequest(*amplifybackend.GetBackendJobInput) (*request.Request, *amplifybackend.GetBackendJobOutput)

	GetToken(*amplifybackend.GetTokenInput) (*amplifybackend.GetTokenOutput, error)
	GetTokenWithContext(aws.Context, *amplifybackend.GetTokenInput, ...request.Option) (*amplifybackend.GetTokenOutput, error)
	GetTokenRequest(*amplifybackend.GetTokenInput) (*request.Request, *amplifybackend.GetTokenOutput)

	ListBackendJobs(*amplifybackend.ListBackendJobsInput) (*amplifybackend.ListBackendJobsOutput, error)
	ListBackendJobsWithContext(aws.Context, *amplifybackend.ListBackendJobsInput, ...request.Option) (*amplifybackend.ListBackendJobsOutput, error)
	ListBackendJobsRequest(*amplifybackend.ListBackendJobsInput) (*request.Request, *amplifybackend.ListBackendJobsOutput)

	ListBackendJobsPages(*amplifybackend.ListBackendJobsInput, func(*amplifybackend.ListBackendJobsOutput, bool) bool) error
	ListBackendJobsPagesWithContext(aws.Context, *amplifybackend.ListBackendJobsInput, func(*amplifybackend.ListBackendJobsOutput, bool) bool, ...request.Option) error

	RemoveAllBackends(*amplifybackend.RemoveAllBackendsInput) (*amplifybackend.RemoveAllBackendsOutput, error)
	RemoveAllBackendsWithContext(aws.Context, *amplifybackend.RemoveAllBackendsInput, ...request.Option) (*amplifybackend.RemoveAllBackendsOutput, error)
	RemoveAllBackendsRequest(*amplifybackend.RemoveAllBackendsInput) (*request.Request, *amplifybackend.RemoveAllBackendsOutput)

	RemoveBackendConfig(*amplifybackend.RemoveBackendConfigInput) (*amplifybackend.RemoveBackendConfigOutput, error)
	RemoveBackendConfigWithContext(aws.Context, *amplifybackend.RemoveBackendConfigInput, ...request.Option) (*amplifybackend.RemoveBackendConfigOutput, error)
	RemoveBackendConfigRequest(*amplifybackend.RemoveBackendConfigInput) (*request.Request, *amplifybackend.RemoveBackendConfigOutput)

	UpdateBackendAPI(*amplifybackend.UpdateBackendAPIInput) (*amplifybackend.UpdateBackendAPIOutput, error)
	UpdateBackendAPIWithContext(aws.Context, *amplifybackend.UpdateBackendAPIInput, ...request.Option) (*amplifybackend.UpdateBackendAPIOutput, error)
	UpdateBackendAPIRequest(*amplifybackend.UpdateBackendAPIInput) (*request.Request, *amplifybackend.UpdateBackendAPIOutput)

	UpdateBackendAuth(*amplifybackend.UpdateBackendAuthInput) (*amplifybackend.UpdateBackendAuthOutput, error)
	UpdateBackendAuthWithContext(aws.Context, *amplifybackend.UpdateBackendAuthInput, ...request.Option) (*amplifybackend.UpdateBackendAuthOutput, error)
	UpdateBackendAuthRequest(*amplifybackend.UpdateBackendAuthInput) (*request.Request, *amplifybackend.UpdateBackendAuthOutput)

	UpdateBackendConfig(*amplifybackend.UpdateBackendConfigInput) (*amplifybackend.UpdateBackendConfigOutput, error)
	UpdateBackendConfigWithContext(aws.Context, *amplifybackend.UpdateBackendConfigInput, ...request.Option) (*amplifybackend.UpdateBackendConfigOutput, error)
	UpdateBackendConfigRequest(*amplifybackend.UpdateBackendConfigInput) (*request.Request, *amplifybackend.UpdateBackendConfigOutput)

	UpdateBackendJob(*amplifybackend.UpdateBackendJobInput) (*amplifybackend.UpdateBackendJobOutput, error)
	UpdateBackendJobWithContext(aws.Context, *amplifybackend.UpdateBackendJobInput, ...request.Option) (*amplifybackend.UpdateBackendJobOutput, error)
	UpdateBackendJobRequest(*amplifybackend.UpdateBackendJobInput) (*request.Request, *amplifybackend.UpdateBackendJobOutput)
}

var _ AmplifyBackendAPI = (*amplifybackend.AmplifyBackend)(nil)
