// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package schemas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateDiscovererInput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	// SourceArn is a required field
	SourceArn *string `min:"20" type:"string" required:"true"`

	// Key-value pairs associated with a resource.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateDiscovererInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDiscovererInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDiscovererInput"}

	if s.SourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceArn"))
	}
	if s.SourceArn != nil && len(*s.SourceArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDiscovererInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceArn != nil {
		v := *s.SourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

type CreateDiscovererOutput struct {
	_ struct{} `type:"structure"`

	Description *string `type:"string"`

	DiscovererArn *string `type:"string"`

	DiscovererId *string `type:"string"`

	SourceArn *string `type:"string"`

	State DiscovererState `type:"string" enum:"true"`

	// Key-value pairs associated with a resource.
	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateDiscovererOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateDiscovererOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DiscovererArn != nil {
		v := *s.DiscovererArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DiscovererArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DiscovererId != nil {
		v := *s.DiscovererId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DiscovererId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceArn != nil {
		v := *s.SourceArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Tags != nil {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

const opCreateDiscoverer = "CreateDiscoverer"

// CreateDiscovererRequest returns a request value for making API operation for
// Schemas.
//
// Creates a discoverer.
//
//    // Example sending a request using CreateDiscovererRequest.
//    req := client.CreateDiscovererRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/CreateDiscoverer
func (c *Client) CreateDiscovererRequest(input *CreateDiscovererInput) CreateDiscovererRequest {
	op := &aws.Operation{
		Name:       opCreateDiscoverer,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/discoverers",
	}

	if input == nil {
		input = &CreateDiscovererInput{}
	}

	req := c.newRequest(op, input, &CreateDiscovererOutput{})
	return CreateDiscovererRequest{Request: req, Input: input, Copy: c.CreateDiscovererRequest}
}

// CreateDiscovererRequest is the request type for the
// CreateDiscoverer API operation.
type CreateDiscovererRequest struct {
	*aws.Request
	Input *CreateDiscovererInput
	Copy  func(*CreateDiscovererInput) CreateDiscovererRequest
}

// Send marshals and sends the CreateDiscoverer API request.
func (r CreateDiscovererRequest) Send(ctx context.Context) (*CreateDiscovererResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDiscovererResponse{
		CreateDiscovererOutput: r.Request.Data.(*CreateDiscovererOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDiscovererResponse is the response type for the
// CreateDiscoverer API operation.
type CreateDiscovererResponse struct {
	*CreateDiscovererOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDiscoverer request.
func (r *CreateDiscovererResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
