// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package elastictranscoderiface provides an interface to enable mocking the Amazon Elastic Transcoder service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package elastictranscoderiface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/elastictranscoder"
)

// ClientAPI provides an interface to enable mocking the
// elastictranscoder.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Elastic Transcoder.
//    func myFunc(svc elastictranscoderiface.ClientAPI) bool {
//        // Make svc.CancelJob request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := elastictranscoder.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        elastictranscoderiface.ClientPI
//    }
//    func (m *mockClientClient) CancelJob(input *elastictranscoder.CancelJobInput) (*elastictranscoder.CancelJobOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CancelJobRequest(*elastictranscoder.CancelJobInput) elastictranscoder.CancelJobRequest

	CreateJobRequest(*elastictranscoder.CreateJobInput) elastictranscoder.CreateJobRequest

	CreatePipelineRequest(*elastictranscoder.CreatePipelineInput) elastictranscoder.CreatePipelineRequest

	CreatePresetRequest(*elastictranscoder.CreatePresetInput) elastictranscoder.CreatePresetRequest

	DeletePipelineRequest(*elastictranscoder.DeletePipelineInput) elastictranscoder.DeletePipelineRequest

	DeletePresetRequest(*elastictranscoder.DeletePresetInput) elastictranscoder.DeletePresetRequest

	ListJobsByPipelineRequest(*elastictranscoder.ListJobsByPipelineInput) elastictranscoder.ListJobsByPipelineRequest

	ListJobsByStatusRequest(*elastictranscoder.ListJobsByStatusInput) elastictranscoder.ListJobsByStatusRequest

	ListPipelinesRequest(*elastictranscoder.ListPipelinesInput) elastictranscoder.ListPipelinesRequest

	ListPresetsRequest(*elastictranscoder.ListPresetsInput) elastictranscoder.ListPresetsRequest

	ReadJobRequest(*elastictranscoder.ReadJobInput) elastictranscoder.ReadJobRequest

	ReadPipelineRequest(*elastictranscoder.ReadPipelineInput) elastictranscoder.ReadPipelineRequest

	ReadPresetRequest(*elastictranscoder.ReadPresetInput) elastictranscoder.ReadPresetRequest

	TestRoleRequest(*elastictranscoder.TestRoleInput) elastictranscoder.TestRoleRequest

	UpdatePipelineRequest(*elastictranscoder.UpdatePipelineInput) elastictranscoder.UpdatePipelineRequest

	UpdatePipelineNotificationsRequest(*elastictranscoder.UpdatePipelineNotificationsInput) elastictranscoder.UpdatePipelineNotificationsRequest

	UpdatePipelineStatusRequest(*elastictranscoder.UpdatePipelineStatusInput) elastictranscoder.UpdatePipelineStatusRequest

	WaitUntilJobComplete(context.Context, *elastictranscoder.ReadJobInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*elastictranscoder.Client)(nil)
