// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elastictranscoder

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The DeletePresetRequest structure.
type DeletePresetInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the preset for which you want to get detailed information.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePresetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePresetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePresetInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePresetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The DeletePresetResponse structure.
type DeletePresetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePresetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeletePresetOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeletePreset = "DeletePreset"

// DeletePresetRequest returns a request value for making API operation for
// Amazon Elastic Transcoder.
//
// The DeletePreset operation removes a preset that you've added in an AWS region.
//
// You can't delete the default presets that are included with Elastic Transcoder.
//
//    // Example sending a request using DeletePresetRequest.
//    req := client.DeletePresetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeletePresetRequest(input *DeletePresetInput) DeletePresetRequest {
	op := &aws.Operation{
		Name:       opDeletePreset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2012-09-25/presets/{Id}",
	}

	if input == nil {
		input = &DeletePresetInput{}
	}

	req := c.newRequest(op, input, &DeletePresetOutput{})
	return DeletePresetRequest{Request: req, Input: input, Copy: c.DeletePresetRequest}
}

// DeletePresetRequest is the request type for the
// DeletePreset API operation.
type DeletePresetRequest struct {
	*aws.Request
	Input *DeletePresetInput
	Copy  func(*DeletePresetInput) DeletePresetRequest
}

// Send marshals and sends the DeletePreset API request.
func (r DeletePresetRequest) Send(ctx context.Context) (*DeletePresetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePresetResponse{
		DeletePresetOutput: r.Request.Data.(*DeletePresetOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePresetResponse is the response type for the
// DeletePreset API operation.
type DeletePresetResponse struct {
	*DeletePresetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePreset request.
func (r *DeletePresetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
