// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type DeleteNodegroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster that is associated with your node group.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the node group to delete.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNodegroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNodegroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteNodegroupInput"}

	if s.ClusterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterName"))
	}

	if s.NodegroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NodegroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteNodegroupInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ClusterName != nil {
		v := *s.ClusterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NodegroupName != nil {
		v := *s.NodegroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "nodegroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type DeleteNodegroupOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your deleted node group.
	Nodegroup *Nodegroup `locationName:"nodegroup" type:"structure"`
}

// String returns the string representation
func (s DeleteNodegroupOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteNodegroupOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Nodegroup != nil {
		v := s.Nodegroup

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "nodegroup", v, metadata)
	}
	return nil
}

const opDeleteNodegroup = "DeleteNodegroup"

// DeleteNodegroupRequest returns a request value for making API operation for
// Amazon Elastic Kubernetes Service.
//
// Deletes an Amazon EKS node group for a cluster.
//
//    // Example sending a request using DeleteNodegroupRequest.
//    req := client.DeleteNodegroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteNodegroup
func (c *Client) DeleteNodegroupRequest(input *DeleteNodegroupInput) DeleteNodegroupRequest {
	op := &aws.Operation{
		Name:       opDeleteNodegroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}",
	}

	if input == nil {
		input = &DeleteNodegroupInput{}
	}

	req := c.newRequest(op, input, &DeleteNodegroupOutput{})
	return DeleteNodegroupRequest{Request: req, Input: input, Copy: c.DeleteNodegroupRequest}
}

// DeleteNodegroupRequest is the request type for the
// DeleteNodegroup API operation.
type DeleteNodegroupRequest struct {
	*aws.Request
	Input *DeleteNodegroupInput
	Copy  func(*DeleteNodegroupInput) DeleteNodegroupRequest
}

// Send marshals and sends the DeleteNodegroup API request.
func (r DeleteNodegroupRequest) Send(ctx context.Context) (*DeleteNodegroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteNodegroupResponse{
		DeleteNodegroupOutput: r.Request.Data.(*DeleteNodegroupOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteNodegroupResponse is the response type for the
// DeleteNodegroup API operation.
type DeleteNodegroupResponse struct {
	*DeleteNodegroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteNodegroup request.
func (r *DeleteNodegroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
