// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package devicefarmiface provides an interface to enable mocking the AWS Device Farm service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package devicefarmiface

import (
	"github.com/aws/aws-sdk-go-v2/service/devicefarm"
)

// ClientAPI provides an interface to enable mocking the
// devicefarm.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Device Farm.
//    func myFunc(svc devicefarmiface.ClientAPI) bool {
//        // Make svc.CreateDevicePool request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := devicefarm.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        devicefarmiface.ClientPI
//    }
//    func (m *mockClientClient) CreateDevicePool(input *devicefarm.CreateDevicePoolInput) (*devicefarm.CreateDevicePoolOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateDevicePoolRequest(*devicefarm.CreateDevicePoolInput) devicefarm.CreateDevicePoolRequest

	CreateInstanceProfileRequest(*devicefarm.CreateInstanceProfileInput) devicefarm.CreateInstanceProfileRequest

	CreateNetworkProfileRequest(*devicefarm.CreateNetworkProfileInput) devicefarm.CreateNetworkProfileRequest

	CreateProjectRequest(*devicefarm.CreateProjectInput) devicefarm.CreateProjectRequest

	CreateRemoteAccessSessionRequest(*devicefarm.CreateRemoteAccessSessionInput) devicefarm.CreateRemoteAccessSessionRequest

	CreateUploadRequest(*devicefarm.CreateUploadInput) devicefarm.CreateUploadRequest

	CreateVPCEConfigurationRequest(*devicefarm.CreateVPCEConfigurationInput) devicefarm.CreateVPCEConfigurationRequest

	DeleteDevicePoolRequest(*devicefarm.DeleteDevicePoolInput) devicefarm.DeleteDevicePoolRequest

	DeleteInstanceProfileRequest(*devicefarm.DeleteInstanceProfileInput) devicefarm.DeleteInstanceProfileRequest

	DeleteNetworkProfileRequest(*devicefarm.DeleteNetworkProfileInput) devicefarm.DeleteNetworkProfileRequest

	DeleteProjectRequest(*devicefarm.DeleteProjectInput) devicefarm.DeleteProjectRequest

	DeleteRemoteAccessSessionRequest(*devicefarm.DeleteRemoteAccessSessionInput) devicefarm.DeleteRemoteAccessSessionRequest

	DeleteRunRequest(*devicefarm.DeleteRunInput) devicefarm.DeleteRunRequest

	DeleteUploadRequest(*devicefarm.DeleteUploadInput) devicefarm.DeleteUploadRequest

	DeleteVPCEConfigurationRequest(*devicefarm.DeleteVPCEConfigurationInput) devicefarm.DeleteVPCEConfigurationRequest

	GetAccountSettingsRequest(*devicefarm.GetAccountSettingsInput) devicefarm.GetAccountSettingsRequest

	GetDeviceRequest(*devicefarm.GetDeviceInput) devicefarm.GetDeviceRequest

	GetDeviceInstanceRequest(*devicefarm.GetDeviceInstanceInput) devicefarm.GetDeviceInstanceRequest

	GetDevicePoolRequest(*devicefarm.GetDevicePoolInput) devicefarm.GetDevicePoolRequest

	GetDevicePoolCompatibilityRequest(*devicefarm.GetDevicePoolCompatibilityInput) devicefarm.GetDevicePoolCompatibilityRequest

	GetInstanceProfileRequest(*devicefarm.GetInstanceProfileInput) devicefarm.GetInstanceProfileRequest

	GetJobRequest(*devicefarm.GetJobInput) devicefarm.GetJobRequest

	GetNetworkProfileRequest(*devicefarm.GetNetworkProfileInput) devicefarm.GetNetworkProfileRequest

	GetOfferingStatusRequest(*devicefarm.GetOfferingStatusInput) devicefarm.GetOfferingStatusRequest

	GetProjectRequest(*devicefarm.GetProjectInput) devicefarm.GetProjectRequest

	GetRemoteAccessSessionRequest(*devicefarm.GetRemoteAccessSessionInput) devicefarm.GetRemoteAccessSessionRequest

	GetRunRequest(*devicefarm.GetRunInput) devicefarm.GetRunRequest

	GetSuiteRequest(*devicefarm.GetSuiteInput) devicefarm.GetSuiteRequest

	GetTestRequest(*devicefarm.GetTestInput) devicefarm.GetTestRequest

	GetUploadRequest(*devicefarm.GetUploadInput) devicefarm.GetUploadRequest

	GetVPCEConfigurationRequest(*devicefarm.GetVPCEConfigurationInput) devicefarm.GetVPCEConfigurationRequest

	InstallToRemoteAccessSessionRequest(*devicefarm.InstallToRemoteAccessSessionInput) devicefarm.InstallToRemoteAccessSessionRequest

	ListArtifactsRequest(*devicefarm.ListArtifactsInput) devicefarm.ListArtifactsRequest

	ListDeviceInstancesRequest(*devicefarm.ListDeviceInstancesInput) devicefarm.ListDeviceInstancesRequest

	ListDevicePoolsRequest(*devicefarm.ListDevicePoolsInput) devicefarm.ListDevicePoolsRequest

	ListDevicesRequest(*devicefarm.ListDevicesInput) devicefarm.ListDevicesRequest

	ListInstanceProfilesRequest(*devicefarm.ListInstanceProfilesInput) devicefarm.ListInstanceProfilesRequest

	ListJobsRequest(*devicefarm.ListJobsInput) devicefarm.ListJobsRequest

	ListNetworkProfilesRequest(*devicefarm.ListNetworkProfilesInput) devicefarm.ListNetworkProfilesRequest

	ListOfferingPromotionsRequest(*devicefarm.ListOfferingPromotionsInput) devicefarm.ListOfferingPromotionsRequest

	ListOfferingTransactionsRequest(*devicefarm.ListOfferingTransactionsInput) devicefarm.ListOfferingTransactionsRequest

	ListOfferingsRequest(*devicefarm.ListOfferingsInput) devicefarm.ListOfferingsRequest

	ListProjectsRequest(*devicefarm.ListProjectsInput) devicefarm.ListProjectsRequest

	ListRemoteAccessSessionsRequest(*devicefarm.ListRemoteAccessSessionsInput) devicefarm.ListRemoteAccessSessionsRequest

	ListRunsRequest(*devicefarm.ListRunsInput) devicefarm.ListRunsRequest

	ListSamplesRequest(*devicefarm.ListSamplesInput) devicefarm.ListSamplesRequest

	ListSuitesRequest(*devicefarm.ListSuitesInput) devicefarm.ListSuitesRequest

	ListTagsForResourceRequest(*devicefarm.ListTagsForResourceInput) devicefarm.ListTagsForResourceRequest

	ListTestsRequest(*devicefarm.ListTestsInput) devicefarm.ListTestsRequest

	ListUniqueProblemsRequest(*devicefarm.ListUniqueProblemsInput) devicefarm.ListUniqueProblemsRequest

	ListUploadsRequest(*devicefarm.ListUploadsInput) devicefarm.ListUploadsRequest

	ListVPCEConfigurationsRequest(*devicefarm.ListVPCEConfigurationsInput) devicefarm.ListVPCEConfigurationsRequest

	PurchaseOfferingRequest(*devicefarm.PurchaseOfferingInput) devicefarm.PurchaseOfferingRequest

	RenewOfferingRequest(*devicefarm.RenewOfferingInput) devicefarm.RenewOfferingRequest

	ScheduleRunRequest(*devicefarm.ScheduleRunInput) devicefarm.ScheduleRunRequest

	StopJobRequest(*devicefarm.StopJobInput) devicefarm.StopJobRequest

	StopRemoteAccessSessionRequest(*devicefarm.StopRemoteAccessSessionInput) devicefarm.StopRemoteAccessSessionRequest

	StopRunRequest(*devicefarm.StopRunInput) devicefarm.StopRunRequest

	TagResourceRequest(*devicefarm.TagResourceInput) devicefarm.TagResourceRequest

	UntagResourceRequest(*devicefarm.UntagResourceInput) devicefarm.UntagResourceRequest

	UpdateDeviceInstanceRequest(*devicefarm.UpdateDeviceInstanceInput) devicefarm.UpdateDeviceInstanceRequest

	UpdateDevicePoolRequest(*devicefarm.UpdateDevicePoolInput) devicefarm.UpdateDevicePoolRequest

	UpdateInstanceProfileRequest(*devicefarm.UpdateInstanceProfileInput) devicefarm.UpdateInstanceProfileRequest

	UpdateNetworkProfileRequest(*devicefarm.UpdateNetworkProfileInput) devicefarm.UpdateNetworkProfileRequest

	UpdateProjectRequest(*devicefarm.UpdateProjectInput) devicefarm.UpdateProjectRequest

	UpdateUploadRequest(*devicefarm.UpdateUploadInput) devicefarm.UpdateUploadRequest

	UpdateVPCEConfigurationRequest(*devicefarm.UpdateVPCEConfigurationInput) devicefarm.UpdateVPCEConfigurationRequest
}

var _ ClientAPI = (*devicefarm.Client)(nil)
