// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package computeoptimizer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAutoScalingGroupRecommendationsInput struct {
	_ struct{} `type:"structure"`

	// The AWS account IDs for which to return Auto Scaling group recommendations.
	//
	// Only one account ID can be specified per request.
	AccountIds []string `locationName:"accountIds" type:"list"`

	// The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return
	// recommendations.
	AutoScalingGroupArns []string `locationName:"autoScalingGroupArns" type:"list"`

	// An array of objects that describe a filter that returns a more specific list
	// of Auto Scaling group recommendations.
	Filters []Filter `locationName:"filters" type:"list"`

	// The maximum number of Auto Scaling group recommendations to return with a
	// single call.
	//
	// To retrieve the remaining results, make another call with the returned NextToken
	// value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token to advance to the next page of Auto Scaling group recommendations.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetAutoScalingGroupRecommendationsInput) String() string {
	return awsutil.Prettify(s)
}

type GetAutoScalingGroupRecommendationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe Auto Scaling group recommendations.
	AutoScalingGroupRecommendations []AutoScalingGroupRecommendation `locationName:"autoScalingGroupRecommendations" type:"list"`

	// An array of objects that describe errors of the request.
	//
	// For example, an error is returned if you request recommendations for an unsupported
	// Auto Scaling group.
	Errors []GetRecommendationError `locationName:"errors" type:"list"`

	// The token to use to advance to the next page of Auto Scaling group recommendations.
	//
	// This value is null when there are no more pages of Auto Scaling group recommendations
	// to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetAutoScalingGroupRecommendationsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAutoScalingGroupRecommendations = "GetAutoScalingGroupRecommendations"

// GetAutoScalingGroupRecommendationsRequest returns a request value for making API operation for
// AWS Compute Optimizer.
//
// Returns Auto Scaling group recommendations.
//
// AWS Compute Optimizer currently generates recommendations for Auto Scaling
// groups that are configured to run instances of the M, C, R, T, and X instance
// families. The service does not generate recommendations for Auto Scaling
// groups that have a scaling policy attached to them, or that do not have the
// same values for desired, minimum, and maximum capacity. In order for Compute
// Optimizer to analyze your Auto Scaling groups, they must be of a fixed size.
// For more information, see the AWS Compute Optimizer User Guide (https://docs.aws.amazon.com/compute-optimizer/latest/ug/what-is.html).
//
//    // Example sending a request using GetAutoScalingGroupRecommendationsRequest.
//    req := client.GetAutoScalingGroupRecommendationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetAutoScalingGroupRecommendations
func (c *Client) GetAutoScalingGroupRecommendationsRequest(input *GetAutoScalingGroupRecommendationsInput) GetAutoScalingGroupRecommendationsRequest {
	op := &aws.Operation{
		Name:       opGetAutoScalingGroupRecommendations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAutoScalingGroupRecommendationsInput{}
	}

	req := c.newRequest(op, input, &GetAutoScalingGroupRecommendationsOutput{})
	return GetAutoScalingGroupRecommendationsRequest{Request: req, Input: input, Copy: c.GetAutoScalingGroupRecommendationsRequest}
}

// GetAutoScalingGroupRecommendationsRequest is the request type for the
// GetAutoScalingGroupRecommendations API operation.
type GetAutoScalingGroupRecommendationsRequest struct {
	*aws.Request
	Input *GetAutoScalingGroupRecommendationsInput
	Copy  func(*GetAutoScalingGroupRecommendationsInput) GetAutoScalingGroupRecommendationsRequest
}

// Send marshals and sends the GetAutoScalingGroupRecommendations API request.
func (r GetAutoScalingGroupRecommendationsRequest) Send(ctx context.Context) (*GetAutoScalingGroupRecommendationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAutoScalingGroupRecommendationsResponse{
		GetAutoScalingGroupRecommendationsOutput: r.Request.Data.(*GetAutoScalingGroupRecommendationsOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAutoScalingGroupRecommendationsResponse is the response type for the
// GetAutoScalingGroupRecommendations API operation.
type GetAutoScalingGroupRecommendationsResponse struct {
	*GetAutoScalingGroupRecommendationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAutoScalingGroupRecommendations request.
func (r *GetAutoScalingGroupRecommendationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
