// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The request to respond to an authentication challenge.
type RespondToAuthChallengeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Pinpoint analytics metadata for collecting metrics for RespondToAuthChallenge
	// calls.
	AnalyticsMetadata *AnalyticsMetadataType `type:"structure"`

	// The challenge name. For more information, see .
	//
	// ADMIN_NO_SRP_AUTH is not a valid value.
	//
	// ChallengeName is a required field
	ChallengeName ChallengeNameType `type:"string" required:"true" enum:"true"`

	// The challenge responses. These are inputs corresponding to the value of ChallengeName,
	// for example:
	//
	// SECRET_HASH (if app client is configured with client secret) applies to all
	// inputs below (including SOFTWARE_TOKEN_MFA).
	//
	//    * SMS_MFA: SMS_MFA_CODE, USERNAME.
	//
	//    * PASSWORD_VERIFIER: PASSWORD_CLAIM_SIGNATURE, PASSWORD_CLAIM_SECRET_BLOCK,
	//    TIMESTAMP, USERNAME.
	//
	//    * NEW_PASSWORD_REQUIRED: NEW_PASSWORD, any other required attributes,
	//    USERNAME.
	//
	//    * SOFTWARE_TOKEN_MFA: USERNAME and SOFTWARE_TOKEN_MFA_CODE are required
	//    attributes.
	//
	//    * DEVICE_SRP_AUTH requires USERNAME, DEVICE_KEY, SRP_A (and SECRET_HASH).
	//
	//    * DEVICE_PASSWORD_VERIFIER requires everything that PASSWORD_VERIFIER
	//    requires plus DEVICE_KEY.
	ChallengeResponses map[string]string `type:"map"`

	// The app client ID.
	//
	// ClientId is a required field
	ClientId *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// A map of custom key-value pairs that you can provide as input for any custom
	// workflows that this action triggers.
	//
	// You create custom workflows by assigning AWS Lambda functions to user pool
	// triggers. When you use the RespondToAuthChallenge API action, Amazon Cognito
	// invokes any functions that are assigned to the following triggers: post authentication,
	// pre token generation, define auth challenge, create auth challenge, and verify
	// auth challenge. When Amazon Cognito invokes any of these functions, it passes
	// a JSON payload, which the function receives as input. This payload contains
	// a clientMetadata attribute, which provides the data that you assigned to
	// the ClientMetadata parameter in your RespondToAuthChallenge request. In your
	// function code in AWS Lambda, you can process the clientMetadata value to
	// enhance your workflow for your specific needs.
	//
	// For more information, see Customizing User Pool Workflows with Lambda Triggers
	// (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
	// in the Amazon Cognito Developer Guide.
	//
	// Take the following limitations into consideration when you use the ClientMetadata
	// parameter:
	//
	//    * Amazon Cognito does not store the ClientMetadata value. This data is
	//    available only to AWS Lambda triggers that are assigned to a user pool
	//    to support custom workflows. If your user pool configuration does not
	//    include triggers, the ClientMetadata parameter serves no purpose.
	//
	//    * Amazon Cognito does not validate the ClientMetadata value.
	//
	//    * Amazon Cognito does not encrypt the the ClientMetadata value, so don't
	//    use it to provide sensitive information.
	ClientMetadata map[string]string `type:"map"`

	// The session which should be passed both ways in challenge-response calls
	// to the service. If InitiateAuth or RespondToAuthChallenge API call determines
	// that the caller needs to go through another challenge, they return a session
	// with other challenge parameters. This session should be passed as it is to
	// the next RespondToAuthChallenge API call.
	Session *string `min:"20" type:"string"`

	// Contextual data such as the user's device fingerprint, IP address, or location
	// used for evaluating the risk of an unexpected event by Amazon Cognito advanced
	// security.
	UserContextData *UserContextDataType `type:"structure"`
}

// String returns the string representation
func (s RespondToAuthChallengeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RespondToAuthChallengeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RespondToAuthChallengeInput"}
	if len(s.ChallengeName) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ChallengeName"))
	}

	if s.ClientId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientId"))
	}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientId", 1))
	}
	if s.Session != nil && len(*s.Session) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("Session", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response to respond to the authentication challenge.
type RespondToAuthChallengeOutput struct {
	_ struct{} `type:"structure"`

	// The result returned by the server in response to the request to respond to
	// the authentication challenge.
	AuthenticationResult *AuthenticationResultType `type:"structure"`

	// The challenge name. For more information, see .
	ChallengeName ChallengeNameType `type:"string" enum:"true"`

	// The challenge parameters. For more information, see .
	ChallengeParameters map[string]string `type:"map"`

	// The session which should be passed both ways in challenge-response calls
	// to the service. If the or API call determines that the caller needs to go
	// through another challenge, they return a session with other challenge parameters.
	// This session should be passed as it is to the next RespondToAuthChallenge
	// API call.
	Session *string `min:"20" type:"string"`
}

// String returns the string representation
func (s RespondToAuthChallengeOutput) String() string {
	return awsutil.Prettify(s)
}

const opRespondToAuthChallenge = "RespondToAuthChallenge"

// RespondToAuthChallengeRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Responds to the authentication challenge.
//
//    // Example sending a request using RespondToAuthChallengeRequest.
//    req := client.RespondToAuthChallengeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/RespondToAuthChallenge
func (c *Client) RespondToAuthChallengeRequest(input *RespondToAuthChallengeInput) RespondToAuthChallengeRequest {
	op := &aws.Operation{
		Name:       opRespondToAuthChallenge,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RespondToAuthChallengeInput{}
	}

	req := c.newRequest(op, input, &RespondToAuthChallengeOutput{})
	return RespondToAuthChallengeRequest{Request: req, Input: input, Copy: c.RespondToAuthChallengeRequest}
}

// RespondToAuthChallengeRequest is the request type for the
// RespondToAuthChallenge API operation.
type RespondToAuthChallengeRequest struct {
	*aws.Request
	Input *RespondToAuthChallengeInput
	Copy  func(*RespondToAuthChallengeInput) RespondToAuthChallengeRequest
}

// Send marshals and sends the RespondToAuthChallenge API request.
func (r RespondToAuthChallengeRequest) Send(ctx context.Context) (*RespondToAuthChallengeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RespondToAuthChallengeResponse{
		RespondToAuthChallengeOutput: r.Request.Data.(*RespondToAuthChallengeOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RespondToAuthChallengeResponse is the response type for the
// RespondToAuthChallenge API operation.
type RespondToAuthChallengeResponse struct {
	*RespondToAuthChallengeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RespondToAuthChallenge request.
func (r *RespondToAuthChallengeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
