// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentity

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// A provider representing an Amazon Cognito user pool and its client ID.
type CognitoIdentityProvider struct {
	_ struct{} `type:"structure"`

	// The client ID for the Amazon Cognito user pool.
	ClientId *string `min:"1" type:"string"`

	// The provider name for an Amazon Cognito user pool. For example, cognito-idp.us-east-1.amazonaws.com/us-east-1_123456789.
	ProviderName *string `min:"1" type:"string"`

	// TRUE if server-side token validation is enabled for the identity provider’s
	// token.
	//
	// Once you set ServerSideTokenCheck to TRUE for an identity pool, that identity
	// pool will check with the integrated user pools to make sure that the user
	// has not been globally signed out or deleted before the identity pool provides
	// an OIDC token or AWS credentials for the user.
	//
	// If the user is signed out or deleted, the identity pool will return a 400
	// Not Authorized error.
	ServerSideTokenCheck *bool `type:"boolean"`
}

// String returns the string representation
func (s CognitoIdentityProvider) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CognitoIdentityProvider) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CognitoIdentityProvider"}
	if s.ClientId != nil && len(*s.ClientId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientId", 1))
	}
	if s.ProviderName != nil && len(*s.ProviderName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProviderName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Credentials for the provided identity ID.
type Credentials struct {
	_ struct{} `type:"structure"`

	// The Access Key portion of the credentials.
	AccessKeyId *string `type:"string"`

	// The date at which these credentials will expire.
	Expiration *time.Time `type:"timestamp"`

	// The Secret Access Key portion of the credentials
	SecretKey *string `type:"string"`

	// The Session Token portion of the credentials
	SessionToken *string `type:"string"`
}

// String returns the string representation
func (s Credentials) String() string {
	return awsutil.Prettify(s)
}

// A description of the identity.
type IdentityDescription struct {
	_ struct{} `type:"structure"`

	// Date on which the identity was created.
	CreationDate *time.Time `type:"timestamp"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`

	// Date on which the identity was last modified.
	LastModifiedDate *time.Time `type:"timestamp"`

	// The provider names.
	Logins []string `type:"list"`
}

// String returns the string representation
func (s IdentityDescription) String() string {
	return awsutil.Prettify(s)
}

// A description of the identity pool.
type IdentityPoolShortDescription struct {
	_ struct{} `type:"structure"`

	// An identity pool ID in the format REGION:GUID.
	IdentityPoolId *string `min:"1" type:"string"`

	// A string that you provide.
	IdentityPoolName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IdentityPoolShortDescription) String() string {
	return awsutil.Prettify(s)
}

// A rule that maps a claim name, a claim value, and a match type to a role
// ARN.
type MappingRule struct {
	_ struct{} `type:"structure"`

	// The claim name that must be present in the token, for example, "isAdmin"
	// or "paid".
	//
	// Claim is a required field
	Claim *string `min:"1" type:"string" required:"true"`

	// The match condition that specifies how closely the claim value in the IdP
	// token must match Value.
	//
	// MatchType is a required field
	MatchType MappingRuleMatchType `type:"string" required:"true" enum:"true"`

	// The role ARN.
	//
	// RoleARN is a required field
	RoleARN *string `min:"20" type:"string" required:"true"`

	// A brief string that the claim must match, for example, "paid" or "yes".
	//
	// Value is a required field
	Value *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s MappingRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MappingRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MappingRule"}

	if s.Claim == nil {
		invalidParams.Add(aws.NewErrParamRequired("Claim"))
	}
	if s.Claim != nil && len(*s.Claim) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Claim", 1))
	}
	if len(s.MatchType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("MatchType"))
	}

	if s.RoleARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleARN", 20))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A role mapping.
type RoleMapping struct {
	_ struct{} `type:"structure"`

	// If you specify Token or Rules as the Type, AmbiguousRoleResolution is required.
	//
	// Specifies the action to be taken if either no rules match the claim value
	// for the Rules type, or there is no cognito:preferred_role claim and there
	// are multiple cognito:roles matches for the Token type.
	AmbiguousRoleResolution AmbiguousRoleResolutionType `type:"string" enum:"true"`

	// The rules to be used for mapping users to roles.
	//
	// If you specify Rules as the role mapping type, RulesConfiguration is required.
	RulesConfiguration *RulesConfigurationType `type:"structure"`

	// The role mapping type. Token will use cognito:roles and cognito:preferred_role
	// claims from the Cognito identity provider token to map groups to roles. Rules
	// will attempt to match claims from the token to map to a role.
	//
	// Type is a required field
	Type RoleMappingType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RoleMapping) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RoleMapping) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RoleMapping"}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}
	if s.RulesConfiguration != nil {
		if err := s.RulesConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RulesConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A container for rules.
type RulesConfigurationType struct {
	_ struct{} `type:"structure"`

	// An array of rules. You can specify up to 25 rules per identity provider.
	//
	// Rules are evaluated in order. The first one to match specifies the role.
	//
	// Rules is a required field
	Rules []MappingRule `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s RulesConfigurationType) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RulesConfigurationType) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RulesConfigurationType"}

	if s.Rules == nil {
		invalidParams.Add(aws.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Rules", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An array of UnprocessedIdentityId objects, each of which contains an ErrorCode
// and IdentityId.
type UnprocessedIdentityId struct {
	_ struct{} `type:"structure"`

	// The error code indicating the type of error that occurred.
	ErrorCode ErrorCode `type:"string" enum:"true"`

	// A unique identifier in the format REGION:GUID.
	IdentityId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UnprocessedIdentityId) String() string {
	return awsutil.Prettify(s)
}
