// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateTrustInput struct {
	_ struct{} `type:"structure"`

	// Updates selective authentication for the trust.
	SelectiveAuth SelectiveAuth `type:"string" enum:"true"`

	// Identifier of the trust relationship.
	//
	// TrustId is a required field
	TrustId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateTrustInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrustInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateTrustInput"}

	if s.TrustId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TrustId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateTrustOutput struct {
	_ struct{} `type:"structure"`

	// The AWS request identifier.
	RequestId *string `type:"string"`

	// Identifier of the trust relationship.
	TrustId *string `type:"string"`
}

// String returns the string representation
func (s UpdateTrustOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateTrust = "UpdateTrust"

// UpdateTrustRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Updates the trust that has been set up between your AWS Managed Microsoft
// AD directory and an on-premises Active Directory.
//
//    // Example sending a request using UpdateTrustRequest.
//    req := client.UpdateTrustRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/UpdateTrust
func (c *Client) UpdateTrustRequest(input *UpdateTrustInput) UpdateTrustRequest {
	op := &aws.Operation{
		Name:       opUpdateTrust,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTrustInput{}
	}

	req := c.newRequest(op, input, &UpdateTrustOutput{})
	return UpdateTrustRequest{Request: req, Input: input, Copy: c.UpdateTrustRequest}
}

// UpdateTrustRequest is the request type for the
// UpdateTrust API operation.
type UpdateTrustRequest struct {
	*aws.Request
	Input *UpdateTrustInput
	Copy  func(*UpdateTrustInput) UpdateTrustRequest
}

// Send marshals and sends the UpdateTrust API request.
func (r UpdateTrustRequest) Send(ctx context.Context) (*UpdateTrustResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateTrustResponse{
		UpdateTrustOutput: r.Request.Data.(*UpdateTrustOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateTrustResponse is the response type for the
// UpdateTrust API operation.
type UpdateTrustResponse struct {
	*UpdateTrustOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateTrust request.
func (r *UpdateTrustResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
