// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// An object representing the inputs for the RestoreFromSnapshot operation.
type RestoreFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the snapshot to restore from.
	//
	// SnapshotId is a required field
	SnapshotId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreFromSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreFromSnapshotInput"}

	if s.SnapshotId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the results of the RestoreFromSnapshot operation.
type RestoreFromSnapshotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RestoreFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opRestoreFromSnapshot = "RestoreFromSnapshot"

// RestoreFromSnapshotRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Restores a directory using an existing directory snapshot.
//
// When you restore a directory from a snapshot, any changes made to the directory
// after the snapshot date are overwritten.
//
// This action returns as soon as the restore operation is initiated. You can
// monitor the progress of the restore operation by calling the DescribeDirectories
// operation with the directory identifier. When the DirectoryDescription.Stage
// value changes to Active, the restore operation is complete.
//
//    // Example sending a request using RestoreFromSnapshotRequest.
//    req := client.RestoreFromSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RestoreFromSnapshot
func (c *Client) RestoreFromSnapshotRequest(input *RestoreFromSnapshotInput) RestoreFromSnapshotRequest {
	op := &aws.Operation{
		Name:       opRestoreFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreFromSnapshotInput{}
	}

	req := c.newRequest(op, input, &RestoreFromSnapshotOutput{})
	return RestoreFromSnapshotRequest{Request: req, Input: input, Copy: c.RestoreFromSnapshotRequest}
}

// RestoreFromSnapshotRequest is the request type for the
// RestoreFromSnapshot API operation.
type RestoreFromSnapshotRequest struct {
	*aws.Request
	Input *RestoreFromSnapshotInput
	Copy  func(*RestoreFromSnapshotInput) RestoreFromSnapshotRequest
}

// Send marshals and sends the RestoreFromSnapshot API request.
func (r RestoreFromSnapshotRequest) Send(ctx context.Context) (*RestoreFromSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RestoreFromSnapshotResponse{
		RestoreFromSnapshotOutput: r.Request.Data.(*RestoreFromSnapshotOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RestoreFromSnapshotResponse is the response type for the
// RestoreFromSnapshot API operation.
type RestoreFromSnapshotResponse struct {
	*RestoreFromSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RestoreFromSnapshot request.
func (r *RestoreFromSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
