// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetMetricDataInput struct {
	_ struct{} `type:"structure"`

	// The timestamp, in UNIX Epoch time format, at which to end the reporting interval
	// for the retrieval of historical metrics data. The time must be specified
	// using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be
	// later than the start time timestamp.
	//
	// The time range between the start and end time must be less than 24 hours.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The queues, up to 100, or channels, to use to filter the metrics returned.
	// Metric data is retrieved only for the resources associated with the queues
	// or channels included in the filter. You can include both queue IDs and queue
	// ARNs in the same request. The only supported channel is VOICE.
	//
	// Filters is a required field
	Filters *Filters `type:"structure" required:"true"`

	// The grouping applied to the metrics returned. For example, when results are
	// grouped by queue, the metrics returned are grouped by queue. The values returned
	// apply to the metrics for each queue rather than aggregated for all queues.
	//
	// The only supported grouping is QUEUE.
	//
	// If no grouping is specified, a summary of metrics for all queues is returned.
	Groupings []Grouping `type:"list"`

	// The metrics to retrieve. Specify the name, unit, and statistic for each metric.
	// The following historical metrics are available:
	//
	// ABANDON_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// AFTER_CONTACT_WORK_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// API_CONTACTS_HANDLED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CALLBACK_CONTACTS_HANDLED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_ABANDONED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_AGENT_HUNG_UP_FIRST
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_CONSULTED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_HANDLED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_HANDLED_INCOMING
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_HANDLED_OUTBOUND
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_HOLD_ABANDONS
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_MISSED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_QUEUED
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_TRANSFERRED_IN
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_TRANSFERRED_IN_FROM_QUEUE
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_TRANSFERRED_OUT
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// CONTACTS_TRANSFERRED_OUT_FROM_QUEUE
	//
	// Unit: COUNT
	//
	// Statistic: SUM
	//
	// HANDLE_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// HOLD_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// INTERACTION_AND_HOLD_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// INTERACTION_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// OCCUPANCY
	//
	// Unit: PERCENT
	//
	// Statistic: AVG
	//
	// QUEUE_ANSWER_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: AVG
	//
	// QUEUED_TIME
	//
	// Unit: SECONDS
	//
	// Statistic: MAX
	//
	// SERVICE_LEVEL
	//
	// Unit: PERCENT
	//
	// Statistic: AVG
	//
	// Threshold: Only "Less than" comparisons are supported, with the following
	// service level thresholds: 15, 20, 25, 30, 45, 60, 90, 120, 180, 240, 300,
	// 600
	//
	// HistoricalMetrics is a required field
	HistoricalMetrics []HistoricalMetric `type:"list" required:"true"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximimum number of results to return per page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `type:"string"`

	// The timestamp, in UNIX Epoch time format, at which to start the reporting
	// interval for the retrieval of historical metrics data. The time must be specified
	// using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.
	//
	// The start time cannot be earlier than 24 hours before the time of the request.
	// Historical metrics are available only for 24 hours.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s GetMetricDataInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMetricDataInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMetricDataInput"}

	if s.EndTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndTime"))
	}

	if s.Filters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filters"))
	}

	if s.HistoricalMetrics == nil {
		invalidParams.Add(aws.NewErrParamRequired("HistoricalMetrics"))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.StartTime == nil {
		invalidParams.Add(aws.NewErrParamRequired("StartTime"))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetMetricDataInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.EndTime != nil {
		v := *s.EndTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EndTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filters", v, metadata)
	}
	if s.Groupings != nil {
		v := s.Groupings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Groupings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.HistoricalMetrics != nil {
		v := s.HistoricalMetrics

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "HistoricalMetrics", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StartTime != nil {
		v := *s.StartTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StartTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "InstanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetMetricDataOutput struct {
	_ struct{} `type:"structure"`

	// Information about the historical metrics.
	//
	// If no grouping is specified, a summary of metric data is returned.
	MetricResults []HistoricalMetricResult `type:"list"`

	// If there are additional results, this is the token for the next set of results.
	//
	// The token expires after 5 minutes from the time it is created. Subsequent
	// requests that use the token must use the same request parameters as the request
	// that generated the token.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetMetricDataOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetMetricDataOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MetricResults != nil {
		v := s.MetricResults

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MetricResults", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetMetricData = "GetMetricData"

// GetMetricDataRequest returns a request value for making API operation for
// Amazon Connect Service.
//
// Gets historical metric data from the specified Amazon Connect instance.
//
// For more information, see Historical Metrics Reports (https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics.html)
// in the Amazon Connect Administrator Guide.
//
//    // Example sending a request using GetMetricDataRequest.
//    req := client.GetMetricDataRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData
func (c *Client) GetMetricDataRequest(input *GetMetricDataInput) GetMetricDataRequest {
	op := &aws.Operation{
		Name:       opGetMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/metrics/historical/{InstanceId}",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetMetricDataInput{}
	}

	req := c.newRequest(op, input, &GetMetricDataOutput{})
	return GetMetricDataRequest{Request: req, Input: input, Copy: c.GetMetricDataRequest}
}

// GetMetricDataRequest is the request type for the
// GetMetricData API operation.
type GetMetricDataRequest struct {
	*aws.Request
	Input *GetMetricDataInput
	Copy  func(*GetMetricDataInput) GetMetricDataRequest
}

// Send marshals and sends the GetMetricData API request.
func (r GetMetricDataRequest) Send(ctx context.Context) (*GetMetricDataResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMetricDataResponse{
		GetMetricDataOutput: r.Request.Data.(*GetMetricDataOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetMetricDataRequestPaginator returns a paginator for GetMetricData.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetMetricDataRequest(input)
//   p := connect.NewGetMetricDataRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetMetricDataPaginator(req GetMetricDataRequest) GetMetricDataPaginator {
	return GetMetricDataPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetMetricDataInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetMetricDataPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetMetricDataPaginator struct {
	aws.Pager
}

func (p *GetMetricDataPaginator) CurrentPage() *GetMetricDataOutput {
	return p.Pager.CurrentPage().(*GetMetricDataOutput)
}

// GetMetricDataResponse is the response type for the
// GetMetricData API operation.
type GetMetricDataResponse struct {
	*GetMetricDataOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMetricData request.
func (r *GetMetricDataResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
