// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codecommit

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type AssociateApprovalRuleTemplateWithRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The name for the approval rule template.
	//
	// ApprovalRuleTemplateName is a required field
	ApprovalRuleTemplateName *string `locationName:"approvalRuleTemplateName" min:"1" type:"string" required:"true"`

	// The name of the repository that you want to associate with the template.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateApprovalRuleTemplateWithRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateApprovalRuleTemplateWithRepositoryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateApprovalRuleTemplateWithRepositoryInput"}

	if s.ApprovalRuleTemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApprovalRuleTemplateName"))
	}
	if s.ApprovalRuleTemplateName != nil && len(*s.ApprovalRuleTemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApprovalRuleTemplateName", 1))
	}

	if s.RepositoryName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RepositoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AssociateApprovalRuleTemplateWithRepositoryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateApprovalRuleTemplateWithRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateApprovalRuleTemplateWithRepository = "AssociateApprovalRuleTemplateWithRepository"

// AssociateApprovalRuleTemplateWithRepositoryRequest returns a request value for making API operation for
// AWS CodeCommit.
//
// Creates an association between an approval rule template and a specified
// repository. Then, the next time a pull request is created in the repository
// where the destination reference (if specified) matches the destination reference
// (branch) for the pull request, an approval rule that matches the template
// conditions is automatically created for that pull request. If no destination
// references are specified in the template, an approval rule that matches the
// template contents is created for all pull requests in that repository.
//
//    // Example sending a request using AssociateApprovalRuleTemplateWithRepositoryRequest.
//    req := client.AssociateApprovalRuleTemplateWithRepositoryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/AssociateApprovalRuleTemplateWithRepository
func (c *Client) AssociateApprovalRuleTemplateWithRepositoryRequest(input *AssociateApprovalRuleTemplateWithRepositoryInput) AssociateApprovalRuleTemplateWithRepositoryRequest {
	op := &aws.Operation{
		Name:       opAssociateApprovalRuleTemplateWithRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateApprovalRuleTemplateWithRepositoryInput{}
	}

	req := c.newRequest(op, input, &AssociateApprovalRuleTemplateWithRepositoryOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return AssociateApprovalRuleTemplateWithRepositoryRequest{Request: req, Input: input, Copy: c.AssociateApprovalRuleTemplateWithRepositoryRequest}
}

// AssociateApprovalRuleTemplateWithRepositoryRequest is the request type for the
// AssociateApprovalRuleTemplateWithRepository API operation.
type AssociateApprovalRuleTemplateWithRepositoryRequest struct {
	*aws.Request
	Input *AssociateApprovalRuleTemplateWithRepositoryInput
	Copy  func(*AssociateApprovalRuleTemplateWithRepositoryInput) AssociateApprovalRuleTemplateWithRepositoryRequest
}

// Send marshals and sends the AssociateApprovalRuleTemplateWithRepository API request.
func (r AssociateApprovalRuleTemplateWithRepositoryRequest) Send(ctx context.Context) (*AssociateApprovalRuleTemplateWithRepositoryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateApprovalRuleTemplateWithRepositoryResponse{
		AssociateApprovalRuleTemplateWithRepositoryOutput: r.Request.Data.(*AssociateApprovalRuleTemplateWithRepositoryOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateApprovalRuleTemplateWithRepositoryResponse is the response type for the
// AssociateApprovalRuleTemplateWithRepository API operation.
type AssociateApprovalRuleTemplateWithRepositoryResponse struct {
	*AssociateApprovalRuleTemplateWithRepositoryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateApprovalRuleTemplateWithRepository request.
func (r *AssociateApprovalRuleTemplateWithRepositoryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
