// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudhsm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ModifyLunaClientInput struct {
	_ struct{} `type:"structure"`

	// The new certificate for the client.
	//
	// Certificate is a required field
	Certificate *string `min:"600" type:"string" required:"true"`

	// The ARN of the client.
	//
	// ClientArn is a required field
	ClientArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyLunaClientInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyLunaClientInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyLunaClientInput"}

	if s.Certificate == nil {
		invalidParams.Add(aws.NewErrParamRequired("Certificate"))
	}
	if s.Certificate != nil && len(*s.Certificate) < 600 {
		invalidParams.Add(aws.NewErrParamMinLen("Certificate", 600))
	}

	if s.ClientArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyLunaClientOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the client.
	ClientArn *string `type:"string"`
}

// String returns the string representation
func (s ModifyLunaClientOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyLunaClient = "ModifyLunaClient"

// ModifyLunaClientRequest returns a request value for making API operation for
// Amazon CloudHSM.
//
// This is documentation for AWS CloudHSM Classic. For more information, see
// AWS CloudHSM Classic FAQs (http://aws.amazon.com/cloudhsm/faqs-classic/),
// the AWS CloudHSM Classic User Guide (http://docs.aws.amazon.com/cloudhsm/classic/userguide/),
// and the AWS CloudHSM Classic API Reference (http://docs.aws.amazon.com/cloudhsm/classic/APIReference/).
//
// For information about the current version of AWS CloudHSM, see AWS CloudHSM
// (http://aws.amazon.com/cloudhsm/), the AWS CloudHSM User Guide (http://docs.aws.amazon.com/cloudhsm/latest/userguide/),
// and the AWS CloudHSM API Reference (http://docs.aws.amazon.com/cloudhsm/latest/APIReference/).
//
// Modifies the certificate used by the client.
//
// This action can potentially start a workflow to install the new certificate
// on the client's HSMs.
//
//    // Example sending a request using ModifyLunaClientRequest.
//    req := client.ModifyLunaClientRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudhsm-2014-05-30/ModifyLunaClient
func (c *Client) ModifyLunaClientRequest(input *ModifyLunaClientInput) ModifyLunaClientRequest {
	op := &aws.Operation{
		Name:       opModifyLunaClient,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyLunaClientInput{}
	}

	req := c.newRequest(op, input, &ModifyLunaClientOutput{})
	return ModifyLunaClientRequest{Request: req, Input: input, Copy: c.ModifyLunaClientRequest}
}

// ModifyLunaClientRequest is the request type for the
// ModifyLunaClient API operation.
type ModifyLunaClientRequest struct {
	*aws.Request
	Input *ModifyLunaClientInput
	Copy  func(*ModifyLunaClientInput) ModifyLunaClientRequest
}

// Send marshals and sends the ModifyLunaClient API request.
func (r ModifyLunaClientRequest) Send(ctx context.Context) (*ModifyLunaClientResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyLunaClientResponse{
		ModifyLunaClientOutput: r.Request.Data.(*ModifyLunaClientOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyLunaClientResponse is the response type for the
// ModifyLunaClient API operation.
type ModifyLunaClientResponse struct {
	*ModifyLunaClientOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyLunaClient request.
func (r *ModifyLunaClientResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
