package monitor_test

import "influxdata/influxdb/monitor"
import "influxdata/influxdb/v1"
import "testing"
import "experimental"

option now = () => 2018-05-22T19:54:40Z

option monitor.log = (tables=<-) => tables |> drop(columns:["_start", "_stop"])

// Note this input data is identical to the output data of the check test case, post pivot.
inData = "
#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true
#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string
#default,got,,,,,,,,,,,,,,
,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host
,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,23.371648565879127,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost
,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,29.007636780636247,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost
,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,28.93580898231049,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost
,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,28.28329800786939,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost
,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,28.338670930910908,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost
,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,29.551382817337316,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost
,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,20.229131737702303,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost
,,0,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,20.57913145323683,057220dae1443000,cpu,usage_user,info,statuses,cpu,threshold,cpu-total,localhost

#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true
#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,double,string,string,string,string,string,string,string,string,string
#default,got,,,,,,,,,,,,,,
,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,11.086267669062991,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,18.937973208474638,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,11.550031971876997,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,8.495652148919287,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,4.358951746379062,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,7.129171924508139,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,4.5748599925408975,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,3.783743323598954,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,4.658109550294696,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,4.095150808198634,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,4.5538963928240594,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,4.428299890926006,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,2.758789040791375,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,3.399426580028879,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,4.620667027747688,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,4.363250147141176,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,6.281032939118847,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,4.972490830276759,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,5.167139505939133,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,4.824212762412529,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,4.887482325607516,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,5.345633364673913,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,4.47091485247676,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,4.408333333333333,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,2.608699518197021,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,4.99208267355613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,3.99008051788834,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,2.5659924848811504,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,4.5284466750289285,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,4.458348327059871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,4.571801254475424,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,3.8832004314667143,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,5.437130027220748,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,4.341341174188152,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1.4127195176169836,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1.358283009169833,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,2.874912507291059,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,2.4329003255950736,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1.3917298857089464,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,2.72916496860213,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,4.816784104464039,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,4.250548794042459,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,3.1213270718908044,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,2.8914444814753097,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,3.4166314635394666,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,4.424631876750123,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,3.5002719462770777,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,4.74975747963091,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,3.788131355225871,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,3.5418847710036783,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,2.3748418711184613,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,3.079545054484013,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,3.5373648023865356,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,4.229490309983358,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,7.848611329073602,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,2.9503906816927747,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,4.912786550445684,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost
,,1,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,5.762651667220752,057220dae1443000,cpu,usage_user,ok,statuses,cpu,threshold,cpu-total,localhost

#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true
#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string
#default,got,,,,,,,,,,,,,,
,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,1585254415407797827,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,1585254750000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,1585254780000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,1585254810000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,1585254840000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,1585254870000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,1585254900000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,1585254930000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,1585254960000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,1585254990000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,1585255020000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,1585255050000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,1585255080000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,1585255110000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,1585255140000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,1585255170000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,1585255200000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,1585255230000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,1585255260000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,1585255290000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,1585255320000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,1585255350000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,1585255380000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,1585255410000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,1585255440000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,1585255470000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,1585255500000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,1585255530000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,1585255560000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,1585255590000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,1585255620000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,1585255650000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,1585255680000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,1585255710000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,1585255740000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,1585255770000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,1585255800000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,1585255830000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,1585255860000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,1585255890000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,1585255920000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,1585255950000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,1585255980000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,1585256010000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,1585256040000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,1585256070000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,1585256100000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,1585256130000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,1585256160000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,1585256190000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,1585256220000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,1585256250000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,1585256280000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,1585256310000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,1585256340000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,1585256370000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,1585256400000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost
,,2,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,1585256430000000000,057220dae1443000,cpu,_source_timestamp,ok,statuses,cpu,threshold,cpu-total,localhost

#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true
#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string
#default,got,,,,,,,,,,,,,,
,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:26:55.569263562Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:04.805402131Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:33:31.548725134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:04.688898357Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:34:31.627798274Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:06.028334572Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:35:31.887412857Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:05.02933451Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:36:31.729957292Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:05.117833549Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:37:31.951393134Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:04.778056331Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:38:31.704503971Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:05.3491966Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:39:31.683358557Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:06.673196605Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:40:32.025836046Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:04.60909815Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:41:31.463047886Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:05.640482636Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:42:31.509308681Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:04.861844416Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:43:31.663809809Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:04.761999221Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:44:31.444359596Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:06.674292797Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:45:31.349830308Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:04.645782765Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:46:31.44042222Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:04.93331776Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:47:31.266766316Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:05.192557606Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:48:31.267979487Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:05.214485267Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:49:31.285683984Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:06.607726958Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:50:31.143841364Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:04.667647794Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:51:31.272251104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:04.855227871Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:52:31.201849914Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:04.56194885Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:53:31.203358634Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:04.590040077Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:54:31.516000884Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:05.791493388Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:55:31.09797193Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:05.000719889Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:56:31.167853945Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:04.551687359Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:57:30.9901659Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:05.461039406Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:58:30.835346999Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:04.713288759Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:59:31.086374842Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:08.182275847Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost
,,3,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T21:00:30.954297104Z,Check: cpu is: ok,057220dae1443000,cpu,_message,ok,statuses,cpu,threshold,cpu-total,localhost

#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true
#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,string,string,string,string,string,string,string
#default,got,,,,,,,,,,,,,,
,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host
,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost
,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost
,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost
,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost
,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost
,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost
,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost
,,4,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,Check: cpu is: info,057220dae1443000,cpu,_message,info,statuses,cpu,threshold,cpu-total,localhost

#group,false,false,true,true,false,false,true,true,true,true,true,true,true,true,true
#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,long,string,string,string,string,string,string,string,string,string
#default,got,,,,,,,,,,,,,,
,result,table,_start,_stop,_time,_value,_check_id,_check_name,_field,_level,_measurement,_source_measurement,_type,cpu,host
,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:04.467243917Z,1585254420000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost
,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:27:31.884510446Z,1585254450000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost
,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:05.043453781Z,1585254480000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost
,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:28:32.219280733Z,1585254510000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost
,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:04.541599828Z,1585254540000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost
,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:29:31.590878487Z,1585254570000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost
,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:31:31.465992796Z,1585254690000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost
,,5,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:04.903745932Z,1585254720000000000,057220dae1443000,cpu,_source_timestamp,info,statuses,cpu,threshold,cpu-total,localhost


"


outData = "
#group,false,false,true,true,true,false,true,false,true,true,false,true,true,true,false,true
#datatype,string,long,string,string,string,string,string,long,dateTime:RFC3339,dateTime:RFC3339,dateTime:RFC3339,string,string,string,double,string
#default,_result,,,,,,,,,,,,,,,
,result,table,_check_id,_check_name,_measurement,_message,_source_measurement,_source_timestamp,_start,_stop,_time,_type,cpu,host,usage_user,_level
,,0,057220dae1443000,cpu,statuses,Check: cpu is: ok,cpu,1585254750000000000,2020-03-25T21:25:05.876383836Z,2020-03-26T21:25:05.876383836Z,2020-03-26T20:32:31.587813488Z,threshold,cpu-total,localhost,18.937973208474638,ok


"

t_state_changes_big_info_to_ok = (table=<-) => table
    |> v1.fieldsAsCols()
    |> monitor.stateChanges(
        fromLevel: "info",
        toLevel: "ok",
    )

test monitor_state_changes_big_info_to_ok = () =>
    ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_state_changes_big_info_to_ok})
