// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to delete one of your Amazon SES identities (an email
// address or domain).
type DeleteIdentityInput struct {
	_ struct{} `type:"structure"`

	// The identity to be removed from the list of identities for the AWS Account.
	//
	// Identity is a required field
	Identity *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIdentityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteIdentityInput"}

	if s.Identity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Identity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An empty element returned on a successful request.
type DeleteIdentityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteIdentity = "DeleteIdentity"

// DeleteIdentityRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Deletes the specified identity (an email address or a domain) from the list
// of verified identities.
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using DeleteIdentityRequest.
//    req := client.DeleteIdentityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DeleteIdentity
func (c *Client) DeleteIdentityRequest(input *DeleteIdentityInput) DeleteIdentityRequest {
	op := &aws.Operation{
		Name:       opDeleteIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIdentityInput{}
	}

	req := c.newRequest(op, input, &DeleteIdentityOutput{})
	return DeleteIdentityRequest{Request: req, Input: input, Copy: c.DeleteIdentityRequest}
}

// DeleteIdentityRequest is the request type for the
// DeleteIdentity API operation.
type DeleteIdentityRequest struct {
	*aws.Request
	Input *DeleteIdentityInput
	Copy  func(*DeleteIdentityInput) DeleteIdentityRequest
}

// Send marshals and sends the DeleteIdentity API request.
func (r DeleteIdentityRequest) Send(ctx context.Context) (*DeleteIdentityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteIdentityResponse{
		DeleteIdentityOutput: r.Request.Data.(*DeleteIdentityOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteIdentityResponse is the response type for the
// DeleteIdentity API operation.
type DeleteIdentityResponse struct {
	*DeleteIdentityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteIdentity request.
func (r *DeleteIdentityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
