// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package networkmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type AssociateLinkInput struct {
	_ struct{} `type:"structure"`

	// The ID of the device.
	//
	// DeviceId is a required field
	DeviceId *string `type:"string" required:"true"`

	// The ID of the global network.
	//
	// GlobalNetworkId is a required field
	GlobalNetworkId *string `location:"uri" locationName:"globalNetworkId" type:"string" required:"true"`

	// The ID of the link.
	//
	// LinkId is a required field
	LinkId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateLinkInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateLinkInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateLinkInput"}

	if s.DeviceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceId"))
	}

	if s.GlobalNetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GlobalNetworkId"))
	}

	if s.LinkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("LinkId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociateLinkInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LinkId != nil {
		v := *s.LinkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LinkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GlobalNetworkId != nil {
		v := *s.GlobalNetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "globalNetworkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type AssociateLinkOutput struct {
	_ struct{} `type:"structure"`

	// The link association.
	LinkAssociation *LinkAssociation `type:"structure"`
}

// String returns the string representation
func (s AssociateLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociateLinkOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.LinkAssociation != nil {
		v := s.LinkAssociation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LinkAssociation", v, metadata)
	}
	return nil
}

const opAssociateLink = "AssociateLink"

// AssociateLinkRequest returns a request value for making API operation for
// AWS Network Manager.
//
// Associates a link to a device. A device can be associated to multiple links
// and a link can be associated to multiple devices. The device and link must
// be in the same global network and the same site.
//
//    // Example sending a request using AssociateLinkRequest.
//    req := client.AssociateLinkRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/networkmanager-2019-07-05/AssociateLink
func (c *Client) AssociateLinkRequest(input *AssociateLinkInput) AssociateLinkRequest {
	op := &aws.Operation{
		Name:       opAssociateLink,
		HTTPMethod: "POST",
		HTTPPath:   "/global-networks/{globalNetworkId}/link-associations",
	}

	if input == nil {
		input = &AssociateLinkInput{}
	}

	req := c.newRequest(op, input, &AssociateLinkOutput{})
	return AssociateLinkRequest{Request: req, Input: input, Copy: c.AssociateLinkRequest}
}

// AssociateLinkRequest is the request type for the
// AssociateLink API operation.
type AssociateLinkRequest struct {
	*aws.Request
	Input *AssociateLinkInput
	Copy  func(*AssociateLinkInput) AssociateLinkRequest
}

// Send marshals and sends the AssociateLink API request.
func (r AssociateLinkRequest) Send(ctx context.Context) (*AssociateLinkResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateLinkResponse{
		AssociateLinkOutput: r.Request.Data.(*AssociateLinkOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateLinkResponse is the response type for the
// AssociateLink API operation.
type AssociateLinkResponse struct {
	*AssociateLinkOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateLink request.
func (r *AssociateLinkResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
