// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/keycloak/keycloak-operator/pkg/apis/keycloak/v1alpha1"
	scheme "github.com/keycloak/keycloak-operator/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// KeycloakBackupsGetter has a method to return a KeycloakBackupInterface.
// A group's client should implement this interface.
type KeycloakBackupsGetter interface {
	KeycloakBackups(namespace string) KeycloakBackupInterface
}

// KeycloakBackupInterface has methods to work with KeycloakBackup resources.
type KeycloakBackupInterface interface {
	Create(ctx context.Context, keycloakBackup *v1alpha1.KeycloakBackup, opts v1.CreateOptions) (*v1alpha1.KeycloakBackup, error)
	Update(ctx context.Context, keycloakBackup *v1alpha1.KeycloakBackup, opts v1.UpdateOptions) (*v1alpha1.KeycloakBackup, error)
	UpdateStatus(ctx context.Context, keycloakBackup *v1alpha1.KeycloakBackup, opts v1.UpdateOptions) (*v1alpha1.KeycloakBackup, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.KeycloakBackup, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.KeycloakBackupList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.KeycloakBackup, err error)
	KeycloakBackupExpansion
}

// keycloakBackups implements KeycloakBackupInterface
type keycloakBackups struct {
	client rest.Interface
	ns     string
}

// newKeycloakBackups returns a KeycloakBackups
func newKeycloakBackups(c *KeycloakV1alpha1Client, namespace string) *keycloakBackups {
	return &keycloakBackups{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the keycloakBackup, and returns the corresponding keycloakBackup object, and an error if there is any.
func (c *keycloakBackups) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.KeycloakBackup, err error) {
	result = &v1alpha1.KeycloakBackup{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("keycloakbackups").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of KeycloakBackups that match those selectors.
func (c *keycloakBackups) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.KeycloakBackupList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.KeycloakBackupList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("keycloakbackups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested keycloakBackups.
func (c *keycloakBackups) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("keycloakbackups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a keycloakBackup and creates it.  Returns the server's representation of the keycloakBackup, and an error, if there is any.
func (c *keycloakBackups) Create(ctx context.Context, keycloakBackup *v1alpha1.KeycloakBackup, opts v1.CreateOptions) (result *v1alpha1.KeycloakBackup, err error) {
	result = &v1alpha1.KeycloakBackup{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("keycloakbackups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(keycloakBackup).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a keycloakBackup and updates it. Returns the server's representation of the keycloakBackup, and an error, if there is any.
func (c *keycloakBackups) Update(ctx context.Context, keycloakBackup *v1alpha1.KeycloakBackup, opts v1.UpdateOptions) (result *v1alpha1.KeycloakBackup, err error) {
	result = &v1alpha1.KeycloakBackup{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("keycloakbackups").
		Name(keycloakBackup.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(keycloakBackup).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *keycloakBackups) UpdateStatus(ctx context.Context, keycloakBackup *v1alpha1.KeycloakBackup, opts v1.UpdateOptions) (result *v1alpha1.KeycloakBackup, err error) {
	result = &v1alpha1.KeycloakBackup{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("keycloakbackups").
		Name(keycloakBackup.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(keycloakBackup).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the keycloakBackup and deletes it. Returns an error if one occurs.
func (c *keycloakBackups) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("keycloakbackups").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *keycloakBackups) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("keycloakbackups").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched keycloakBackup.
func (c *keycloakBackups) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.KeycloakBackup, err error) {
	result = &v1alpha1.KeycloakBackup{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("keycloakbackups").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
