/*
Copyright 2021.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package common

const (
	// ArgoCDInstanceName is the default Argo CD instance name
	ArgoCDInstanceName = "openshift-gitops"
	// DisableDefaultInstallEnvVar is an env variable to disable the default instance
	DisableDefaultInstallEnvVar = "DISABLE_DEFAULT_ARGOCD_INSTANCE"
)

// InfraNodeSelector returns openshift label for infrastructure nodes
func InfraNodeSelector() map[string]string {
	return map[string]string{
		"node-role.kubernetes.io/infra": "",
	}
}
