#!/bin/bash

# Copyright 2020 Google LLC.
# Use of this source code is governed by a BSD-style
# license that can be found in the LICENSE file.

set -e -x

WORKING_BRANCH=synth-update

cd $(dirname $0)/../../..

should_create_pr=1
git checkout -b $WORKING_BRANCH || {
    # The branch already exists - assume there's an existing PR.
    unset should_create_pr;

    # Reset back to master
    git checkout $WORKING_BRANCH;
    git reset --hard origin/master;
}

pushd google-api-go-generator
make all
popd

if [[ -z "$(git status --porcelain)" ]]; then
    echo "No changes today; exiting."
    exit 0;
fi

echo "Pushing changes"

commit_message="all: autogenerated update ($(date '+%Y-%m-%d'))"
git commit --all -m "$commit_message"

git push origin $WORKING_BRANCH:$WORKING_BRANCH -f

if [ "$should_create_pr" ]; then
    echo "Creating PR."
    go run ./sendpr -title "$commit_message"
fi
