// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package quicksight

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateIAMPolicyAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the assignment. This name must be unique within an AWS account.
	//
	// AssignmentName is a required field
	AssignmentName *string `location:"uri" locationName:"AssignmentName" min:"1" type:"string" required:"true"`

	// The status of the assignment. Possible values are as follows:
	//
	//    * ENABLED - Anything specified in this assignment is used when creating
	//    the data source.
	//
	//    * DISABLED - This assignment isn't used when creating the data source.
	//
	//    * DRAFT - This assignment is an unfinished draft and isn't used when creating
	//    the data source.
	AssignmentStatus AssignmentStatus `type:"string" enum:"true"`

	// The ID of the AWS account that contains the IAM policy assignment.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `location:"uri" locationName:"AwsAccountId" min:"12" type:"string" required:"true"`

	// The QuickSight users, groups, or both that you want to assign the policy
	// to.
	Identities map[string][]string `type:"map"`

	// The namespace of the assignment.
	//
	// Namespace is a required field
	Namespace *string `location:"uri" locationName:"Namespace" type:"string" required:"true"`

	// The ARN for the IAM policy to apply to the QuickSight users and groups specified
	// in this assignment.
	PolicyArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateIAMPolicyAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIAMPolicyAssignmentInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateIAMPolicyAssignmentInput"}

	if s.AssignmentName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssignmentName"))
	}
	if s.AssignmentName != nil && len(*s.AssignmentName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssignmentName", 1))
	}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}
	if s.AwsAccountId != nil && len(*s.AwsAccountId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsAccountId", 12))
	}

	if s.Namespace == nil {
		invalidParams.Add(aws.NewErrParamRequired("Namespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateIAMPolicyAssignmentInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if len(s.AssignmentStatus) > 0 {
		v := s.AssignmentStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssignmentStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Identities != nil {
		v := s.Identities

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Identities", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.PolicyArn != nil {
		v := *s.PolicyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PolicyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssignmentName != nil {
		v := *s.AssignmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AssignmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Namespace != nil {
		v := *s.Namespace

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Namespace", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateIAMPolicyAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the assignment.
	AssignmentId *string `type:"string"`

	// The name of the assignment.
	AssignmentName *string `min:"1" type:"string"`

	// The status of the assignment. Possible values are as follows:
	//
	//    * ENABLED - Anything specified in this assignment is used when creating
	//    the data source.
	//
	//    * DISABLED - This assignment isn't used when creating the data source.
	//
	//    * DRAFT - This assignment is an unfinished draft and isn't used when creating
	//    the data source.
	AssignmentStatus AssignmentStatus `type:"string" enum:"true"`

	// The QuickSight users, groups, or both that the IAM policy is assigned to.
	Identities map[string][]string `type:"map"`

	// The ARN for the IAM policy applied to the QuickSight users and groups specified
	// in this assignment.
	PolicyArn *string `type:"string"`

	// The AWS request ID for this operation.
	RequestId *string `type:"string"`

	// The HTTP status of the request.
	Status *int64 `location:"statusCode" type:"integer"`
}

// String returns the string representation
func (s UpdateIAMPolicyAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateIAMPolicyAssignmentOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.AssignmentId != nil {
		v := *s.AssignmentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssignmentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AssignmentName != nil {
		v := *s.AssignmentName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssignmentName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AssignmentStatus) > 0 {
		v := s.AssignmentStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AssignmentStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Identities != nil {
		v := s.Identities

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Identities", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ls1 := ms0.List(k1)
			ls1.Start()
			for _, v2 := range v1 {
				ls1.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v2)})
			}
			ls1.End()
		}
		ms0.End()

	}
	if s.PolicyArn != nil {
		v := *s.PolicyArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PolicyArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RequestId != nil {
		v := *s.RequestId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RequestId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	// ignoring invalid encode state, StatusCode. Status
	return nil
}

const opUpdateIAMPolicyAssignment = "UpdateIAMPolicyAssignment"

// UpdateIAMPolicyAssignmentRequest returns a request value for making API operation for
// Amazon QuickSight.
//
// Updates an existing IAM policy assignment. This operation updates only the
// optional parameter or parameters that are specified in the request.
//
//    // Example sending a request using UpdateIAMPolicyAssignmentRequest.
//    req := client.UpdateIAMPolicyAssignmentRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment
func (c *Client) UpdateIAMPolicyAssignmentRequest(input *UpdateIAMPolicyAssignmentInput) UpdateIAMPolicyAssignmentRequest {
	op := &aws.Operation{
		Name:       opUpdateIAMPolicyAssignment,
		HTTPMethod: "PUT",
		HTTPPath:   "/accounts/{AwsAccountId}/namespaces/{Namespace}/iam-policy-assignments/{AssignmentName}",
	}

	if input == nil {
		input = &UpdateIAMPolicyAssignmentInput{}
	}

	req := c.newRequest(op, input, &UpdateIAMPolicyAssignmentOutput{})
	return UpdateIAMPolicyAssignmentRequest{Request: req, Input: input, Copy: c.UpdateIAMPolicyAssignmentRequest}
}

// UpdateIAMPolicyAssignmentRequest is the request type for the
// UpdateIAMPolicyAssignment API operation.
type UpdateIAMPolicyAssignmentRequest struct {
	*aws.Request
	Input *UpdateIAMPolicyAssignmentInput
	Copy  func(*UpdateIAMPolicyAssignmentInput) UpdateIAMPolicyAssignmentRequest
}

// Send marshals and sends the UpdateIAMPolicyAssignment API request.
func (r UpdateIAMPolicyAssignmentRequest) Send(ctx context.Context) (*UpdateIAMPolicyAssignmentResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateIAMPolicyAssignmentResponse{
		UpdateIAMPolicyAssignmentOutput: r.Request.Data.(*UpdateIAMPolicyAssignmentOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateIAMPolicyAssignmentResponse is the response type for the
// UpdateIAMPolicyAssignment API operation.
type UpdateIAMPolicyAssignmentResponse struct {
	*UpdateIAMPolicyAssignmentOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateIAMPolicyAssignment request.
func (r *UpdateIAMPolicyAssignmentResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
