// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type UpdateServerCertificateInput struct {
	_ struct{} `type:"structure"`

	// The new path for the server certificate. Include this only if you are updating
	// the server certificate's path.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of either a forward slash (/) by itself
	// or a string that must begin and end with forward slashes. In addition, it
	// can contain any ASCII character from the ! (\u0021) through the DEL character
	// (\u007F), including most punctuation characters, digits, and upper and lowercased
	// letters.
	NewPath *string `min:"1" type:"string"`

	// The new name for the server certificate. Include this only if you are updating
	// the server certificate's name. The name of the certificate cannot contain
	// any spaces.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	NewServerCertificateName *string `min:"1" type:"string"`

	// The name of the server certificate that you want to update.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// ServerCertificateName is a required field
	ServerCertificateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServerCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateServerCertificateInput"}
	if s.NewPath != nil && len(*s.NewPath) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NewPath", 1))
	}
	if s.NewServerCertificateName != nil && len(*s.NewServerCertificateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NewServerCertificateName", 1))
	}

	if s.ServerCertificateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerCertificateName"))
	}
	if s.ServerCertificateName != nil && len(*s.ServerCertificateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerCertificateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateServerCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateServerCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateServerCertificate = "UpdateServerCertificate"

// UpdateServerCertificateRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Updates the name and/or the path of the specified server certificate stored
// in IAM.
//
// For more information about working with server certificates, see Working
// with Server Certificates (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html)
// in the IAM User Guide. This topic also includes a list of AWS services that
// can use the server certificates that you manage with IAM.
//
// You should understand the implications of changing a server certificate's
// path or name. For more information, see Renaming a Server Certificate (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs_manage.html#RenamingServerCerts)
// in the IAM User Guide.
//
// The person making the request (the principal), must have permission to change
// the server certificate with the old name and the new name. For example, to
// change the certificate named ProductionCert to ProdCert, the principal must
// have a policy that allows them to update both certificates. If the principal
// has permission to update the ProductionCert group, but not the ProdCert certificate,
// then the update fails. For more information about permissions, see Access
// Management (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html)
// in the IAM User Guide.
//
//    // Example sending a request using UpdateServerCertificateRequest.
//    req := client.UpdateServerCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServerCertificate
func (c *Client) UpdateServerCertificateRequest(input *UpdateServerCertificateInput) UpdateServerCertificateRequest {
	op := &aws.Operation{
		Name:       opUpdateServerCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServerCertificateInput{}
	}

	req := c.newRequest(op, input, &UpdateServerCertificateOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateServerCertificateRequest{Request: req, Input: input, Copy: c.UpdateServerCertificateRequest}
}

// UpdateServerCertificateRequest is the request type for the
// UpdateServerCertificate API operation.
type UpdateServerCertificateRequest struct {
	*aws.Request
	Input *UpdateServerCertificateInput
	Copy  func(*UpdateServerCertificateInput) UpdateServerCertificateRequest
}

// Send marshals and sends the UpdateServerCertificate API request.
func (r UpdateServerCertificateRequest) Send(ctx context.Context) (*UpdateServerCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateServerCertificateResponse{
		UpdateServerCertificateOutput: r.Request.Data.(*UpdateServerCertificateOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateServerCertificateResponse is the response type for the
// UpdateServerCertificate API operation.
type UpdateServerCertificateResponse struct {
	*UpdateServerCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateServerCertificate request.
func (r *UpdateServerCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
