// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package forecastiface provides an interface to enable mocking the Amazon Forecast Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package forecastiface

import (
	"github.com/aws/aws-sdk-go-v2/service/forecast"
)

// ClientAPI provides an interface to enable mocking the
// forecast.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Forecast Service.
//    func myFunc(svc forecastiface.ClientAPI) bool {
//        // Make svc.CreateDataset request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := forecast.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        forecastiface.ClientPI
//    }
//    func (m *mockClientClient) CreateDataset(input *forecast.CreateDatasetInput) (*forecast.CreateDatasetOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateDatasetRequest(*forecast.CreateDatasetInput) forecast.CreateDatasetRequest

	CreateDatasetGroupRequest(*forecast.CreateDatasetGroupInput) forecast.CreateDatasetGroupRequest

	CreateDatasetImportJobRequest(*forecast.CreateDatasetImportJobInput) forecast.CreateDatasetImportJobRequest

	CreateForecastRequest(*forecast.CreateForecastInput) forecast.CreateForecastRequest

	CreateForecastExportJobRequest(*forecast.CreateForecastExportJobInput) forecast.CreateForecastExportJobRequest

	CreatePredictorRequest(*forecast.CreatePredictorInput) forecast.CreatePredictorRequest

	DeleteDatasetRequest(*forecast.DeleteDatasetInput) forecast.DeleteDatasetRequest

	DeleteDatasetGroupRequest(*forecast.DeleteDatasetGroupInput) forecast.DeleteDatasetGroupRequest

	DeleteDatasetImportJobRequest(*forecast.DeleteDatasetImportJobInput) forecast.DeleteDatasetImportJobRequest

	DeleteForecastRequest(*forecast.DeleteForecastInput) forecast.DeleteForecastRequest

	DeleteForecastExportJobRequest(*forecast.DeleteForecastExportJobInput) forecast.DeleteForecastExportJobRequest

	DeletePredictorRequest(*forecast.DeletePredictorInput) forecast.DeletePredictorRequest

	DescribeDatasetRequest(*forecast.DescribeDatasetInput) forecast.DescribeDatasetRequest

	DescribeDatasetGroupRequest(*forecast.DescribeDatasetGroupInput) forecast.DescribeDatasetGroupRequest

	DescribeDatasetImportJobRequest(*forecast.DescribeDatasetImportJobInput) forecast.DescribeDatasetImportJobRequest

	DescribeForecastRequest(*forecast.DescribeForecastInput) forecast.DescribeForecastRequest

	DescribeForecastExportJobRequest(*forecast.DescribeForecastExportJobInput) forecast.DescribeForecastExportJobRequest

	DescribePredictorRequest(*forecast.DescribePredictorInput) forecast.DescribePredictorRequest

	GetAccuracyMetricsRequest(*forecast.GetAccuracyMetricsInput) forecast.GetAccuracyMetricsRequest

	ListDatasetGroupsRequest(*forecast.ListDatasetGroupsInput) forecast.ListDatasetGroupsRequest

	ListDatasetImportJobsRequest(*forecast.ListDatasetImportJobsInput) forecast.ListDatasetImportJobsRequest

	ListDatasetsRequest(*forecast.ListDatasetsInput) forecast.ListDatasetsRequest

	ListForecastExportJobsRequest(*forecast.ListForecastExportJobsInput) forecast.ListForecastExportJobsRequest

	ListForecastsRequest(*forecast.ListForecastsInput) forecast.ListForecastsRequest

	ListPredictorsRequest(*forecast.ListPredictorsInput) forecast.ListPredictorsRequest

	UpdateDatasetGroupRequest(*forecast.UpdateDatasetGroupInput) forecast.UpdateDatasetGroupRequest
}

var _ ClientAPI = (*forecast.Client)(nil)
