// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateRouteInput struct {
	_ struct{} `type:"structure"`

	// The IPv4 CIDR address block used for the destination match. Routing decisions
	// are based on the most specific match.
	DestinationCidrBlock *string `locationName:"destinationCidrBlock" type:"string"`

	// The IPv6 CIDR block used for the destination match. Routing decisions are
	// based on the most specific match.
	DestinationIpv6CidrBlock *string `locationName:"destinationIpv6CidrBlock" type:"string"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// [IPv6 traffic only] The ID of an egress-only internet gateway.
	EgressOnlyInternetGatewayId *string `locationName:"egressOnlyInternetGatewayId" type:"string"`

	// The ID of an internet gateway or virtual private gateway attached to your
	// VPC.
	GatewayId *string `locationName:"gatewayId" type:"string"`

	// The ID of a NAT instance in your VPC. The operation fails if you specify
	// an instance ID unless exactly one network interface is attached.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The ID of the local gateway.
	LocalGatewayId *string `type:"string"`

	// [IPv4 traffic only] The ID of a NAT gateway.
	NatGatewayId *string `locationName:"natGatewayId" type:"string"`

	// The ID of a network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The ID of the route table for the route.
	//
	// RouteTableId is a required field
	RouteTableId *string `locationName:"routeTableId" type:"string" required:"true"`

	// The ID of a transit gateway.
	TransitGatewayId *string `type:"string"`

	// The ID of a VPC peering connection.
	VpcPeeringConnectionId *string `locationName:"vpcPeeringConnectionId" type:"string"`
}

// String returns the string representation
func (s CreateRouteInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRouteInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateRouteInput"}

	if s.RouteTableId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RouteTableId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateRouteOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s CreateRouteOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateRoute = "CreateRoute"

// CreateRouteRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Creates a route in a route table within a VPC.
//
// You must specify one of the following targets: internet gateway or virtual
// private gateway, NAT instance, NAT gateway, VPC peering connection, network
// interface, egress-only internet gateway, or transit gateway.
//
// When determining how to route traffic, we use the route with the most specific
// match. For example, traffic is destined for the IPv4 address 192.0.2.3, and
// the route table includes the following two IPv4 routes:
//
//    * 192.0.2.0/24 (goes to some target A)
//
//    * 192.0.2.0/28 (goes to some target B)
//
// Both routes apply to the traffic destined for 192.0.2.3. However, the second
// route in the list covers a smaller number of IP addresses and is therefore
// more specific, so we use that route to determine where to target the traffic.
//
// For more information about route tables, see Route Tables (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
// in the Amazon Virtual Private Cloud User Guide.
//
//    // Example sending a request using CreateRouteRequest.
//    req := client.CreateRouteRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/CreateRoute
func (c *Client) CreateRouteRequest(input *CreateRouteInput) CreateRouteRequest {
	op := &aws.Operation{
		Name:       opCreateRoute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRouteInput{}
	}

	req := c.newRequest(op, input, &CreateRouteOutput{})
	return CreateRouteRequest{Request: req, Input: input, Copy: c.CreateRouteRequest}
}

// CreateRouteRequest is the request type for the
// CreateRoute API operation.
type CreateRouteRequest struct {
	*aws.Request
	Input *CreateRouteInput
	Copy  func(*CreateRouteInput) CreateRouteRequest
}

// Send marshals and sends the CreateRoute API request.
func (r CreateRouteRequest) Send(ctx context.Context) (*CreateRouteResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateRouteResponse{
		CreateRouteOutput: r.Request.Data.(*CreateRouteOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateRouteResponse is the response type for the
// CreateRoute API operation.
type CreateRouteResponse struct {
	*CreateRouteOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateRoute request.
func (r *CreateRouteResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
