// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acmpca

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetCertificateAuthorityCertificateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of your private CA. This is of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012 .
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCertificateAuthorityCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCertificateAuthorityCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCertificateAuthorityCertificateInput"}

	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetCertificateAuthorityCertificateOutput struct {
	_ struct{} `type:"structure"`

	// Base64-encoded certificate authority (CA) certificate.
	Certificate *string `type:"string"`

	// Base64-encoded certificate chain that includes any intermediate certificates
	// and chains up to root on-premises certificate that you used to sign your
	// private CA certificate. The chain does not include your private CA certificate.
	// If this is a root CA, the value will be null.
	CertificateChain *string `type:"string"`
}

// String returns the string representation
func (s GetCertificateAuthorityCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetCertificateAuthorityCertificate = "GetCertificateAuthorityCertificate"

// GetCertificateAuthorityCertificateRequest returns a request value for making API operation for
// AWS Certificate Manager Private Certificate Authority.
//
// Retrieves the certificate and certificate chain for your private certificate
// authority (CA). Both the certificate and the chain are base64 PEM-encoded.
// The chain does not include the CA certificate. Each certificate in the chain
// signs the one before it.
//
//    // Example sending a request using GetCertificateAuthorityCertificateRequest.
//    req := client.GetCertificateAuthorityCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/GetCertificateAuthorityCertificate
func (c *Client) GetCertificateAuthorityCertificateRequest(input *GetCertificateAuthorityCertificateInput) GetCertificateAuthorityCertificateRequest {
	op := &aws.Operation{
		Name:       opGetCertificateAuthorityCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCertificateAuthorityCertificateInput{}
	}

	req := c.newRequest(op, input, &GetCertificateAuthorityCertificateOutput{})
	return GetCertificateAuthorityCertificateRequest{Request: req, Input: input, Copy: c.GetCertificateAuthorityCertificateRequest}
}

// GetCertificateAuthorityCertificateRequest is the request type for the
// GetCertificateAuthorityCertificate API operation.
type GetCertificateAuthorityCertificateRequest struct {
	*aws.Request
	Input *GetCertificateAuthorityCertificateInput
	Copy  func(*GetCertificateAuthorityCertificateInput) GetCertificateAuthorityCertificateRequest
}

// Send marshals and sends the GetCertificateAuthorityCertificate API request.
func (r GetCertificateAuthorityCertificateRequest) Send(ctx context.Context) (*GetCertificateAuthorityCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCertificateAuthorityCertificateResponse{
		GetCertificateAuthorityCertificateOutput: r.Request.Data.(*GetCertificateAuthorityCertificateOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCertificateAuthorityCertificateResponse is the response type for the
// GetCertificateAuthorityCertificate API operation.
type GetCertificateAuthorityCertificateResponse struct {
	*GetCertificateAuthorityCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCertificateAuthorityCertificate request.
func (r *GetCertificateAuthorityCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
