// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemakera2iruntime

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains information about why a human loop was triggered. If at least one
// activation reason is evaluated to be true, the human loop is activated.
type HumanLoopActivationReason struct {
	_ struct{} `type:"structure"`

	// True if the specified conditions were matched to trigger the human loop.
	ConditionsMatched *bool `type:"boolean"`
}

// String returns the string representation
func (s HumanLoopActivationReason) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HumanLoopActivationReason) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConditionsMatched != nil {
		v := *s.ConditionsMatched

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConditionsMatched", protocol.BoolValue(v), metadata)
	}
	return nil
}

// Information about the corresponding flow definition's human loop activation
// condition evaluation. Null if StartHumanLoop was invoked directly.
type HumanLoopActivationResults struct {
	_ struct{} `type:"structure"`

	// A copy of the human loop activation conditions of the flow definition, augmented
	// with the results of evaluating those conditions on the input provided to
	// the StartHumanLoop operation.
	HumanLoopActivationConditionsEvaluationResults *string `type:"string"`

	// An object containing information about why a human loop was triggered.
	HumanLoopActivationReason *HumanLoopActivationReason `type:"structure"`
}

// String returns the string representation
func (s HumanLoopActivationResults) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HumanLoopActivationResults) MarshalFields(e protocol.FieldEncoder) error {
	if s.HumanLoopActivationConditionsEvaluationResults != nil {
		v := *s.HumanLoopActivationConditionsEvaluationResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HumanLoopActivationConditionsEvaluationResults", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HumanLoopActivationReason != nil {
		v := s.HumanLoopActivationReason

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "HumanLoopActivationReason", v, metadata)
	}
	return nil
}

// An object containing the input.
type HumanLoopInputContent struct {
	_ struct{} `type:"structure"`

	// Serialized input from the human loop.
	//
	// InputContent is a required field
	InputContent *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HumanLoopInputContent) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanLoopInputContent) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HumanLoopInputContent"}

	if s.InputContent == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputContent"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HumanLoopInputContent) MarshalFields(e protocol.FieldEncoder) error {
	if s.InputContent != nil {
		v := *s.InputContent

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InputContent", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about where the human output will be stored.
type HumanLoopOutputContent struct {
	_ struct{} `type:"structure"`

	// The location of the Amazon S3 object where Amazon Augmented AI stores your
	// human loop output. The output is stored at the following location: s3://S3OutputPath/HumanLoopName/CreationTime/output.json.
	//
	// OutputS3Uri is a required field
	OutputS3Uri *string `type:"string" required:"true"`
}

// String returns the string representation
func (s HumanLoopOutputContent) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HumanLoopOutputContent) MarshalFields(e protocol.FieldEncoder) error {
	if s.OutputS3Uri != nil {
		v := *s.OutputS3Uri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OutputS3Uri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Summary information about the human loop.
type HumanLoopSummary struct {
	_ struct{} `type:"structure"`

	// When Amazon Augmented AI created the human loop.
	CreationTime *time.Time `type:"timestamp"`

	// The reason why the human loop failed. A failure reason is returned only when
	// the status of the human loop is Failed.
	FailureReason *string `type:"string"`

	// The Amazon Resource Name (ARN) of the flow definition.
	FlowDefinitionArn *string `type:"string"`

	// The name of the human loop.
	HumanLoopName *string `min:"1" type:"string"`

	// The status of the human loop. Valid values:
	HumanLoopStatus HumanLoopStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s HumanLoopSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HumanLoopSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.FailureReason != nil {
		v := *s.FailureReason

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FailureReason", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FlowDefinitionArn != nil {
		v := *s.FlowDefinitionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FlowDefinitionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HumanLoopName != nil {
		v := *s.HumanLoopName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HumanLoopName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.HumanLoopStatus) > 0 {
		v := s.HumanLoopStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HumanLoopStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Attributes of the data specified by the customer. Use these to describe the
// data to be labeled.
type HumanReviewDataAttributes struct {
	_ struct{} `type:"structure"`

	// Declares that your content is free of personally identifiable information
	// or adult content. Amazon SageMaker may restrict the Amazon Mechanical Turk
	// workers that can view your task based on this information.
	//
	// ContentClassifiers is a required field
	ContentClassifiers []ContentClassifier `type:"list" required:"true"`
}

// String returns the string representation
func (s HumanReviewDataAttributes) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanReviewDataAttributes) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "HumanReviewDataAttributes"}

	if s.ContentClassifiers == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContentClassifiers"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s HumanReviewDataAttributes) MarshalFields(e protocol.FieldEncoder) error {
	if s.ContentClassifiers != nil {
		v := s.ContentClassifiers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ContentClassifiers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}
