// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request for the traffic policy instances that you created in a specified
// hosted zone.
type ListTrafficPolicyInstancesByHostedZoneInput struct {
	_ struct{} `type:"structure"`

	// The ID of the hosted zone that you want to list traffic policy instances
	// for.
	//
	// HostedZoneId is a required field
	HostedZoneId *string `location:"querystring" locationName:"id" type:"string" required:"true"`

	// The maximum number of traffic policy instances to be included in the response
	// body for this request. If you have more than MaxItems traffic policy instances,
	// the value of the IsTruncated element in the response is true, and the values
	// of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker, and TrafficPolicyInstanceTypeMarker
	// represent the first traffic policy instance that Amazon Route 53 will return
	// if you submit another request.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// If the value of IsTruncated in the previous response is true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstances request. For the value of trafficpolicyinstancename,
	// specify the value of TrafficPolicyInstanceNameMarker from the previous response,
	// which is the name of the first traffic policy instance in the next group
	// of traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceNameMarker *string `location:"querystring" locationName:"trafficpolicyinstancename" type:"string"`

	// If the value of IsTruncated in the previous response is true, you have more
	// traffic policy instances. To get more traffic policy instances, submit another
	// ListTrafficPolicyInstances request. For the value of trafficpolicyinstancetype,
	// specify the value of TrafficPolicyInstanceTypeMarker from the previous response,
	// which is the type of the first traffic policy instance in the next group
	// of traffic policy instances.
	//
	// If the value of IsTruncated in the previous response was false, there are
	// no more traffic policy instances to get.
	TrafficPolicyInstanceTypeMarker RRType `location:"querystring" locationName:"trafficpolicyinstancetype" type:"string" enum:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrafficPolicyInstancesByHostedZoneInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTrafficPolicyInstancesByHostedZoneInput"}

	if s.HostedZoneId == nil {
		invalidParams.Add(aws.NewErrParamRequired("HostedZoneId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTrafficPolicyInstancesByHostedZoneInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.HostedZoneId != nil {
		v := *s.HostedZoneId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "id", protocol.StringValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxitems", protocol.StringValue(v), metadata)
	}
	if s.TrafficPolicyInstanceNameMarker != nil {
		v := *s.TrafficPolicyInstanceNameMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "trafficpolicyinstancename", protocol.StringValue(v), metadata)
	}
	if len(s.TrafficPolicyInstanceTypeMarker) > 0 {
		v := s.TrafficPolicyInstanceTypeMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "trafficpolicyinstancetype", v, metadata)
	}
	return nil
}

// A complex type that contains the response information for the request.
type ListTrafficPolicyInstancesByHostedZoneOutput struct {
	_ struct{} `type:"structure"`

	// A flag that indicates whether there are more traffic policy instances to
	// be listed. If the response was truncated, you can get the next group of traffic
	// policy instances by submitting another ListTrafficPolicyInstancesByHostedZone
	// request and specifying the values of HostedZoneIdMarker, TrafficPolicyInstanceNameMarker,
	// and TrafficPolicyInstanceTypeMarker in the corresponding request parameters.
	//
	// IsTruncated is a required field
	IsTruncated *bool `type:"boolean" required:"true"`

	// The value that you specified for the MaxItems parameter in the ListTrafficPolicyInstancesByHostedZone
	// request that produced the current response.
	//
	// MaxItems is a required field
	MaxItems *string `type:"string" required:"true"`

	// If IsTruncated is true, TrafficPolicyInstanceNameMarker is the name of the
	// first traffic policy instance in the next group of traffic policy instances.
	TrafficPolicyInstanceNameMarker *string `type:"string"`

	// If IsTruncated is true, TrafficPolicyInstanceTypeMarker is the DNS type of
	// the resource record sets that are associated with the first traffic policy
	// instance in the next group of traffic policy instances.
	TrafficPolicyInstanceTypeMarker RRType `type:"string" enum:"true"`

	// A list that contains one TrafficPolicyInstance element for each traffic policy
	// instance that matches the elements in the request.
	//
	// TrafficPolicyInstances is a required field
	TrafficPolicyInstances []TrafficPolicyInstance `locationNameList:"TrafficPolicyInstance" type:"list" required:"true"`
}

// String returns the string representation
func (s ListTrafficPolicyInstancesByHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListTrafficPolicyInstancesByHostedZoneOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.IsTruncated != nil {
		v := *s.IsTruncated

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsTruncated", protocol.BoolValue(v), metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxItems", protocol.StringValue(v), metadata)
	}
	if s.TrafficPolicyInstanceNameMarker != nil {
		v := *s.TrafficPolicyInstanceNameMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TrafficPolicyInstanceNameMarker", protocol.StringValue(v), metadata)
	}
	if len(s.TrafficPolicyInstanceTypeMarker) > 0 {
		v := s.TrafficPolicyInstanceTypeMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TrafficPolicyInstanceTypeMarker", v, metadata)
	}
	if s.TrafficPolicyInstances != nil {
		v := s.TrafficPolicyInstances

		metadata := protocol.Metadata{ListLocationName: "TrafficPolicyInstance"}
		ls0 := e.List(protocol.BodyTarget, "TrafficPolicyInstances", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListTrafficPolicyInstancesByHostedZone = "ListTrafficPolicyInstancesByHostedZone"

// ListTrafficPolicyInstancesByHostedZoneRequest returns a request value for making API operation for
// Amazon Route 53.
//
// Gets information about the traffic policy instances that you created in a
// specified hosted zone.
//
// After you submit a CreateTrafficPolicyInstance or an UpdateTrafficPolicyInstance
// request, there's a brief delay while Amazon Route 53 creates the resource
// record sets that are specified in the traffic policy definition. For more
// information, see the State response element.
//
// Route 53 returns a maximum of 100 items in each response. If you have a lot
// of traffic policy instances, you can use the MaxItems parameter to list them
// in groups of up to 100.
//
//    // Example sending a request using ListTrafficPolicyInstancesByHostedZoneRequest.
//    req := client.ListTrafficPolicyInstancesByHostedZoneRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53-2013-04-01/ListTrafficPolicyInstancesByHostedZone
func (c *Client) ListTrafficPolicyInstancesByHostedZoneRequest(input *ListTrafficPolicyInstancesByHostedZoneInput) ListTrafficPolicyInstancesByHostedZoneRequest {
	op := &aws.Operation{
		Name:       opListTrafficPolicyInstancesByHostedZone,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/trafficpolicyinstances/hostedzone",
	}

	if input == nil {
		input = &ListTrafficPolicyInstancesByHostedZoneInput{}
	}

	req := c.newRequest(op, input, &ListTrafficPolicyInstancesByHostedZoneOutput{})
	return ListTrafficPolicyInstancesByHostedZoneRequest{Request: req, Input: input, Copy: c.ListTrafficPolicyInstancesByHostedZoneRequest}
}

// ListTrafficPolicyInstancesByHostedZoneRequest is the request type for the
// ListTrafficPolicyInstancesByHostedZone API operation.
type ListTrafficPolicyInstancesByHostedZoneRequest struct {
	*aws.Request
	Input *ListTrafficPolicyInstancesByHostedZoneInput
	Copy  func(*ListTrafficPolicyInstancesByHostedZoneInput) ListTrafficPolicyInstancesByHostedZoneRequest
}

// Send marshals and sends the ListTrafficPolicyInstancesByHostedZone API request.
func (r ListTrafficPolicyInstancesByHostedZoneRequest) Send(ctx context.Context) (*ListTrafficPolicyInstancesByHostedZoneResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTrafficPolicyInstancesByHostedZoneResponse{
		ListTrafficPolicyInstancesByHostedZoneOutput: r.Request.Data.(*ListTrafficPolicyInstancesByHostedZoneOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListTrafficPolicyInstancesByHostedZoneResponse is the response type for the
// ListTrafficPolicyInstancesByHostedZone API operation.
type ListTrafficPolicyInstancesByHostedZoneResponse struct {
	*ListTrafficPolicyInstancesByHostedZoneOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTrafficPolicyInstancesByHostedZone request.
func (r *ListTrafficPolicyInstancesByHostedZoneResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
