// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type CreateSmsTemplateInput struct {
	_ struct{} `type:"structure" payload:"SMSTemplateRequest"`

	// Specifies the content and settings for a message template that can be used
	// in text messages that are sent through the SMS channel.
	//
	// SMSTemplateRequest is a required field
	SMSTemplateRequest *SMSTemplateRequest `type:"structure" required:"true"`

	// TemplateName is a required field
	TemplateName *string `location:"uri" locationName:"template-name" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSmsTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSmsTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSmsTemplateInput"}

	if s.SMSTemplateRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("SMSTemplateRequest"))
	}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateSmsTemplateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.TemplateName != nil {
		v := *s.TemplateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "template-name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SMSTemplateRequest != nil {
		v := s.SMSTemplateRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "SMSTemplateRequest", v, metadata)
	}
	return nil
}

type CreateSmsTemplateOutput struct {
	_ struct{} `type:"structure" payload:"CreateTemplateMessageBody"`

	// Provides information about a request to create a message template.
	//
	// CreateTemplateMessageBody is a required field
	CreateTemplateMessageBody *CreateTemplateMessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateSmsTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateSmsTemplateOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreateTemplateMessageBody != nil {
		v := s.CreateTemplateMessageBody

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "CreateTemplateMessageBody", v, metadata)
	}
	return nil
}

const opCreateSmsTemplate = "CreateSmsTemplate"

// CreateSmsTemplateRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Creates a message template that you can use in messages that are sent through
// the SMS channel.
//
//    // Example sending a request using CreateSmsTemplateRequest.
//    req := client.CreateSmsTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateSmsTemplate
func (c *Client) CreateSmsTemplateRequest(input *CreateSmsTemplateInput) CreateSmsTemplateRequest {
	op := &aws.Operation{
		Name:       opCreateSmsTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/templates/{template-name}/sms",
	}

	if input == nil {
		input = &CreateSmsTemplateInput{}
	}

	req := c.newRequest(op, input, &CreateSmsTemplateOutput{})
	return CreateSmsTemplateRequest{Request: req, Input: input, Copy: c.CreateSmsTemplateRequest}
}

// CreateSmsTemplateRequest is the request type for the
// CreateSmsTemplate API operation.
type CreateSmsTemplateRequest struct {
	*aws.Request
	Input *CreateSmsTemplateInput
	Copy  func(*CreateSmsTemplateInput) CreateSmsTemplateRequest
}

// Send marshals and sends the CreateSmsTemplate API request.
func (r CreateSmsTemplateRequest) Send(ctx context.Context) (*CreateSmsTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSmsTemplateResponse{
		CreateSmsTemplateOutput: r.Request.Data.(*CreateSmsTemplateOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSmsTemplateResponse is the response type for the
// CreateSmsTemplate API operation.
type CreateSmsTemplateResponse struct {
	*CreateSmsTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSmsTemplate request.
func (r *CreateSmsTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
