// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

type ModifyIdentityIdFormatInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the principal, which can be an IAM user, IAM role, or the root
	// user. Specify all to modify the ID format for all IAM users, IAM roles, and
	// the root user of the account.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `locationName:"principalArn" type:"string" required:"true"`

	// The type of resource: bundle | conversion-task | customer-gateway | dhcp-options
	// | elastic-ip-allocation | elastic-ip-association | export-task | flow-log
	// | image | import-task | internet-gateway | network-acl | network-acl-association
	// | network-interface | network-interface-attachment | prefix-list | route-table
	// | route-table-association | security-group | subnet | subnet-cidr-block-association
	// | vpc | vpc-cidr-block-association | vpc-endpoint | vpc-peering-connection
	// | vpn-connection | vpn-gateway.
	//
	// Alternatively, use the all-current option to include all resource types that
	// are currently within their opt-in period for longer IDs.
	//
	// Resource is a required field
	Resource *string `locationName:"resource" type:"string" required:"true"`

	// Indicates whether the resource should use longer IDs (17-character IDs)
	//
	// UseLongIds is a required field
	UseLongIds *bool `locationName:"useLongIds" type:"boolean" required:"true"`
}

// String returns the string representation
func (s ModifyIdentityIdFormatInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyIdentityIdFormatInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyIdentityIdFormatInput"}

	if s.PrincipalArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PrincipalArn"))
	}

	if s.Resource == nil {
		invalidParams.Add(aws.NewErrParamRequired("Resource"))
	}

	if s.UseLongIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("UseLongIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyIdentityIdFormatOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyIdentityIdFormatOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyIdentityIdFormat = "ModifyIdentityIdFormat"

// ModifyIdentityIdFormatRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Modifies the ID format of a resource for a specified IAM user, IAM role,
// or the root user for an account; or all IAM users, IAM roles, and the root
// user for an account. You can specify that resources should receive longer
// IDs (17-character IDs) when they are created.
//
// This request can only be used to modify longer ID settings for resource types
// that are within the opt-in period. Resources currently in their opt-in period
// include: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation
// | elastic-ip-association | export-task | flow-log | image | import-task |
// internet-gateway | network-acl | network-acl-association | network-interface
// | network-interface-attachment | prefix-list | route-table | route-table-association
// | security-group | subnet | subnet-cidr-block-association | vpc | vpc-cidr-block-association
// | vpc-endpoint | vpc-peering-connection | vpn-connection | vpn-gateway.
//
// For more information, see Resource IDs (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
// This setting applies to the principal specified in the request; it does not
// apply to the principal that makes the request.
//
// Resources created with longer IDs are visible to all IAM roles and users,
// regardless of these settings and provided that they have permission to use
// the relevant Describe command for the resource type.
//
//    // Example sending a request using ModifyIdentityIdFormatRequest.
//    req := client.ModifyIdentityIdFormatRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyIdentityIdFormat
func (c *Client) ModifyIdentityIdFormatRequest(input *ModifyIdentityIdFormatInput) ModifyIdentityIdFormatRequest {
	op := &aws.Operation{
		Name:       opModifyIdentityIdFormat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyIdentityIdFormatInput{}
	}

	req := c.newRequest(op, input, &ModifyIdentityIdFormatOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return ModifyIdentityIdFormatRequest{Request: req, Input: input, Copy: c.ModifyIdentityIdFormatRequest}
}

// ModifyIdentityIdFormatRequest is the request type for the
// ModifyIdentityIdFormat API operation.
type ModifyIdentityIdFormatRequest struct {
	*aws.Request
	Input *ModifyIdentityIdFormatInput
	Copy  func(*ModifyIdentityIdFormatInput) ModifyIdentityIdFormatRequest
}

// Send marshals and sends the ModifyIdentityIdFormat API request.
func (r ModifyIdentityIdFormatRequest) Send(ctx context.Context) (*ModifyIdentityIdFormatResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyIdentityIdFormatResponse{
		ModifyIdentityIdFormatOutput: r.Request.Data.(*ModifyIdentityIdFormatOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyIdentityIdFormatResponse is the response type for the
// ModifyIdentityIdFormat API operation.
type ModifyIdentityIdFormatResponse struct {
	*ModifyIdentityIdFormatOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyIdentityIdFormat request.
func (r *ModifyIdentityIdFormatResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
