// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetConformancePackComplianceDetailsInput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// A ConformancePackEvaluationFilters object.
	Filters *ConformancePackEvaluationFilters `type:"structure"`

	// The maximum number of evaluation results returned on each page. If you do
	// no specify a number, AWS Config uses the default. The default is 100.
	Limit *int64 `type:"integer"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetConformancePackComplianceDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConformancePackComplianceDetailsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetConformancePackComplianceDetailsInput"}

	if s.ConformancePackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConformancePackName"))
	}
	if s.ConformancePackName != nil && len(*s.ConformancePackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConformancePackName", 1))
	}
	if s.Filters != nil {
		if err := s.Filters.Validate(); err != nil {
			invalidParams.AddNested("Filters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetConformancePackComplianceDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Name of the conformance pack.
	//
	// ConformancePackName is a required field
	ConformancePackName *string `min:"1" type:"string" required:"true"`

	// Returns a list of ConformancePackEvaluationResult objects.
	ConformancePackRuleEvaluationResults []ConformancePackEvaluationResult `type:"list"`

	// The nextToken string returned in a previous request that you use to request
	// the next page of results in a paginated response.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetConformancePackComplianceDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetConformancePackComplianceDetails = "GetConformancePackComplianceDetails"

// GetConformancePackComplianceDetailsRequest returns a request value for making API operation for
// AWS Config.
//
// Returns compliance details of a conformance pack for all AWS resources that
// are monitered by conformance pack.
//
//    // Example sending a request using GetConformancePackComplianceDetailsRequest.
//    req := client.GetConformancePackComplianceDetailsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GetConformancePackComplianceDetails
func (c *Client) GetConformancePackComplianceDetailsRequest(input *GetConformancePackComplianceDetailsInput) GetConformancePackComplianceDetailsRequest {
	op := &aws.Operation{
		Name:       opGetConformancePackComplianceDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetConformancePackComplianceDetailsInput{}
	}

	req := c.newRequest(op, input, &GetConformancePackComplianceDetailsOutput{})
	return GetConformancePackComplianceDetailsRequest{Request: req, Input: input, Copy: c.GetConformancePackComplianceDetailsRequest}
}

// GetConformancePackComplianceDetailsRequest is the request type for the
// GetConformancePackComplianceDetails API operation.
type GetConformancePackComplianceDetailsRequest struct {
	*aws.Request
	Input *GetConformancePackComplianceDetailsInput
	Copy  func(*GetConformancePackComplianceDetailsInput) GetConformancePackComplianceDetailsRequest
}

// Send marshals and sends the GetConformancePackComplianceDetails API request.
func (r GetConformancePackComplianceDetailsRequest) Send(ctx context.Context) (*GetConformancePackComplianceDetailsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetConformancePackComplianceDetailsResponse{
		GetConformancePackComplianceDetailsOutput: r.Request.Data.(*GetConformancePackComplianceDetailsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetConformancePackComplianceDetailsResponse is the response type for the
// GetConformancePackComplianceDetails API operation.
type GetConformancePackComplianceDetailsResponse struct {
	*GetConformancePackComplianceDetailsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetConformancePackComplianceDetails request.
func (r *GetConformancePackComplianceDetailsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
