// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.2
// source: google/devtools/clouddebugger/v2/debugger.proto

package clouddebugger

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request to set a breakpoint
type SetBreakpointRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the debuggee where the breakpoint is to be set.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId,proto3" json:"debuggee_id,omitempty"`
	// Required. Breakpoint specification to set.
	// The field `location` of the breakpoint must be set.
	Breakpoint *Breakpoint `protobuf:"bytes,2,opt,name=breakpoint,proto3" json:"breakpoint,omitempty"`
	// Required. The client version making the call.
	// Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,4,opt,name=client_version,json=clientVersion,proto3" json:"client_version,omitempty"`
}

func (x *SetBreakpointRequest) Reset() {
	*x = SetBreakpointRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetBreakpointRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetBreakpointRequest) ProtoMessage() {}

func (x *SetBreakpointRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetBreakpointRequest.ProtoReflect.Descriptor instead.
func (*SetBreakpointRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_debugger_proto_rawDescGZIP(), []int{0}
}

func (x *SetBreakpointRequest) GetDebuggeeId() string {
	if x != nil {
		return x.DebuggeeId
	}
	return ""
}

func (x *SetBreakpointRequest) GetBreakpoint() *Breakpoint {
	if x != nil {
		return x.Breakpoint
	}
	return nil
}

func (x *SetBreakpointRequest) GetClientVersion() string {
	if x != nil {
		return x.ClientVersion
	}
	return ""
}

// Response for setting a breakpoint.
type SetBreakpointResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Breakpoint resource.
	// The field `id` is guaranteed to be set (in addition to the echoed fileds).
	Breakpoint *Breakpoint `protobuf:"bytes,1,opt,name=breakpoint,proto3" json:"breakpoint,omitempty"`
}

func (x *SetBreakpointResponse) Reset() {
	*x = SetBreakpointResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SetBreakpointResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SetBreakpointResponse) ProtoMessage() {}

func (x *SetBreakpointResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SetBreakpointResponse.ProtoReflect.Descriptor instead.
func (*SetBreakpointResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_debugger_proto_rawDescGZIP(), []int{1}
}

func (x *SetBreakpointResponse) GetBreakpoint() *Breakpoint {
	if x != nil {
		return x.Breakpoint
	}
	return nil
}

// Request to get breakpoint information.
type GetBreakpointRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the debuggee whose breakpoint to get.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId,proto3" json:"debuggee_id,omitempty"`
	// Required. ID of the breakpoint to get.
	BreakpointId string `protobuf:"bytes,2,opt,name=breakpoint_id,json=breakpointId,proto3" json:"breakpoint_id,omitempty"`
	// Required. The client version making the call.
	// Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,4,opt,name=client_version,json=clientVersion,proto3" json:"client_version,omitempty"`
}

func (x *GetBreakpointRequest) Reset() {
	*x = GetBreakpointRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBreakpointRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBreakpointRequest) ProtoMessage() {}

func (x *GetBreakpointRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBreakpointRequest.ProtoReflect.Descriptor instead.
func (*GetBreakpointRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_debugger_proto_rawDescGZIP(), []int{2}
}

func (x *GetBreakpointRequest) GetDebuggeeId() string {
	if x != nil {
		return x.DebuggeeId
	}
	return ""
}

func (x *GetBreakpointRequest) GetBreakpointId() string {
	if x != nil {
		return x.BreakpointId
	}
	return ""
}

func (x *GetBreakpointRequest) GetClientVersion() string {
	if x != nil {
		return x.ClientVersion
	}
	return ""
}

// Response for getting breakpoint information.
type GetBreakpointResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Complete breakpoint state.
	// The fields `id` and `location` are guaranteed to be set.
	Breakpoint *Breakpoint `protobuf:"bytes,1,opt,name=breakpoint,proto3" json:"breakpoint,omitempty"`
}

func (x *GetBreakpointResponse) Reset() {
	*x = GetBreakpointResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBreakpointResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBreakpointResponse) ProtoMessage() {}

func (x *GetBreakpointResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBreakpointResponse.ProtoReflect.Descriptor instead.
func (*GetBreakpointResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_debugger_proto_rawDescGZIP(), []int{3}
}

func (x *GetBreakpointResponse) GetBreakpoint() *Breakpoint {
	if x != nil {
		return x.Breakpoint
	}
	return nil
}

// Request to delete a breakpoint.
type DeleteBreakpointRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the debuggee whose breakpoint to delete.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId,proto3" json:"debuggee_id,omitempty"`
	// Required. ID of the breakpoint to delete.
	BreakpointId string `protobuf:"bytes,2,opt,name=breakpoint_id,json=breakpointId,proto3" json:"breakpoint_id,omitempty"`
	// Required. The client version making the call.
	// Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,3,opt,name=client_version,json=clientVersion,proto3" json:"client_version,omitempty"`
}

func (x *DeleteBreakpointRequest) Reset() {
	*x = DeleteBreakpointRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBreakpointRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBreakpointRequest) ProtoMessage() {}

func (x *DeleteBreakpointRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBreakpointRequest.ProtoReflect.Descriptor instead.
func (*DeleteBreakpointRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_debugger_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteBreakpointRequest) GetDebuggeeId() string {
	if x != nil {
		return x.DebuggeeId
	}
	return ""
}

func (x *DeleteBreakpointRequest) GetBreakpointId() string {
	if x != nil {
		return x.BreakpointId
	}
	return ""
}

func (x *DeleteBreakpointRequest) GetClientVersion() string {
	if x != nil {
		return x.ClientVersion
	}
	return ""
}

// Request to list breakpoints.
type ListBreakpointsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the debuggee whose breakpoints to list.
	DebuggeeId string `protobuf:"bytes,1,opt,name=debuggee_id,json=debuggeeId,proto3" json:"debuggee_id,omitempty"`
	// When set to `true`, the response includes the list of breakpoints set by
	// any user. Otherwise, it includes only breakpoints set by the caller.
	IncludeAllUsers bool `protobuf:"varint,2,opt,name=include_all_users,json=includeAllUsers,proto3" json:"include_all_users,omitempty"`
	// When set to `true`, the response includes active and inactive
	// breakpoints. Otherwise, it includes only active breakpoints.
	IncludeInactive bool `protobuf:"varint,3,opt,name=include_inactive,json=includeInactive,proto3" json:"include_inactive,omitempty"`
	// When set, the response includes only breakpoints with the specified action.
	Action *ListBreakpointsRequest_BreakpointActionValue `protobuf:"bytes,4,opt,name=action,proto3" json:"action,omitempty"`
	// This field is deprecated. The following fields are always stripped out of
	// the result: `stack_frames`, `evaluated_expressions` and `variable_table`.
	//
	// Deprecated: Do not use.
	StripResults bool `protobuf:"varint,5,opt,name=strip_results,json=stripResults,proto3" json:"strip_results,omitempty"`
	// A wait token that, if specified, blocks the call until the breakpoints
	// list has changed, or a server selected timeout has expired.  The value
	// should be set from the last response. The error code
	// `google.rpc.Code.ABORTED` (RPC) is returned on wait timeout, which
	// should be called again with the same `wait_token`.
	WaitToken string `protobuf:"bytes,6,opt,name=wait_token,json=waitToken,proto3" json:"wait_token,omitempty"`
	// Required. The client version making the call.
	// Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,8,opt,name=client_version,json=clientVersion,proto3" json:"client_version,omitempty"`
}

func (x *ListBreakpointsRequest) Reset() {
	*x = ListBreakpointsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBreakpointsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBreakpointsRequest) ProtoMessage() {}

func (x *ListBreakpointsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBreakpointsRequest.ProtoReflect.Descriptor instead.
func (*ListBreakpointsRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_debugger_proto_rawDescGZIP(), []int{5}
}

func (x *ListBreakpointsRequest) GetDebuggeeId() string {
	if x != nil {
		return x.DebuggeeId
	}
	return ""
}

func (x *ListBreakpointsRequest) GetIncludeAllUsers() bool {
	if x != nil {
		return x.IncludeAllUsers
	}
	return false
}

func (x *ListBreakpointsRequest) GetIncludeInactive() bool {
	if x != nil {
		return x.IncludeInactive
	}
	return false
}

func (x *ListBreakpointsRequest) GetAction() *ListBreakpointsRequest_BreakpointActionValue {
	if x != nil {
		return x.Action
	}
	return nil
}

// Deprecated: Do not use.
func (x *ListBreakpointsRequest) GetStripResults() bool {
	if x != nil {
		return x.StripResults
	}
	return false
}

func (x *ListBreakpointsRequest) GetWaitToken() string {
	if x != nil {
		return x.WaitToken
	}
	return ""
}

func (x *ListBreakpointsRequest) GetClientVersion() string {
	if x != nil {
		return x.ClientVersion
	}
	return ""
}

// Response for listing breakpoints.
type ListBreakpointsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of breakpoints matching the request.
	// The fields `id` and `location` are guaranteed to be set on each breakpoint.
	// The fields: `stack_frames`, `evaluated_expressions` and `variable_table`
	// are cleared on each breakpoint regardless of its status.
	Breakpoints []*Breakpoint `protobuf:"bytes,1,rep,name=breakpoints,proto3" json:"breakpoints,omitempty"`
	// A wait token that can be used in the next call to `list` (REST) or
	// `ListBreakpoints` (RPC) to block until the list of breakpoints has changes.
	NextWaitToken string `protobuf:"bytes,2,opt,name=next_wait_token,json=nextWaitToken,proto3" json:"next_wait_token,omitempty"`
}

func (x *ListBreakpointsResponse) Reset() {
	*x = ListBreakpointsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBreakpointsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBreakpointsResponse) ProtoMessage() {}

func (x *ListBreakpointsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBreakpointsResponse.ProtoReflect.Descriptor instead.
func (*ListBreakpointsResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_debugger_proto_rawDescGZIP(), []int{6}
}

func (x *ListBreakpointsResponse) GetBreakpoints() []*Breakpoint {
	if x != nil {
		return x.Breakpoints
	}
	return nil
}

func (x *ListBreakpointsResponse) GetNextWaitToken() string {
	if x != nil {
		return x.NextWaitToken
	}
	return ""
}

// Request to list debuggees.
type ListDebuggeesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Project number of a Google Cloud project whose debuggees to list.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// When set to `true`, the result includes all debuggees. Otherwise, the
	// result includes only debuggees that are active.
	IncludeInactive bool `protobuf:"varint,3,opt,name=include_inactive,json=includeInactive,proto3" json:"include_inactive,omitempty"`
	// Required. The client version making the call.
	// Schema: `domain/type/version` (e.g., `google.com/intellij/v1`).
	ClientVersion string `protobuf:"bytes,4,opt,name=client_version,json=clientVersion,proto3" json:"client_version,omitempty"`
}

func (x *ListDebuggeesRequest) Reset() {
	*x = ListDebuggeesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDebuggeesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDebuggeesRequest) ProtoMessage() {}

func (x *ListDebuggeesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDebuggeesRequest.ProtoReflect.Descriptor instead.
func (*ListDebuggeesRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_debugger_proto_rawDescGZIP(), []int{7}
}

func (x *ListDebuggeesRequest) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ListDebuggeesRequest) GetIncludeInactive() bool {
	if x != nil {
		return x.IncludeInactive
	}
	return false
}

func (x *ListDebuggeesRequest) GetClientVersion() string {
	if x != nil {
		return x.ClientVersion
	}
	return ""
}

// Response for listing debuggees.
type ListDebuggeesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of debuggees accessible to the calling user.
	// The fields `debuggee.id` and `description` are guaranteed to be set.
	// The `description` field is a human readable field provided by agents and
	// can be displayed to users.
	Debuggees []*Debuggee `protobuf:"bytes,1,rep,name=debuggees,proto3" json:"debuggees,omitempty"`
}

func (x *ListDebuggeesResponse) Reset() {
	*x = ListDebuggeesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDebuggeesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDebuggeesResponse) ProtoMessage() {}

func (x *ListDebuggeesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDebuggeesResponse.ProtoReflect.Descriptor instead.
func (*ListDebuggeesResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_debugger_proto_rawDescGZIP(), []int{8}
}

func (x *ListDebuggeesResponse) GetDebuggees() []*Debuggee {
	if x != nil {
		return x.Debuggees
	}
	return nil
}

// Wrapper message for `Breakpoint.Action`. Defines a filter on the action
// field of breakpoints.
type ListBreakpointsRequest_BreakpointActionValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Only breakpoints with the specified action will pass the filter.
	Value Breakpoint_Action `protobuf:"varint,1,opt,name=value,proto3,enum=google.devtools.clouddebugger.v2.Breakpoint_Action" json:"value,omitempty"`
}

func (x *ListBreakpointsRequest_BreakpointActionValue) Reset() {
	*x = ListBreakpointsRequest_BreakpointActionValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBreakpointsRequest_BreakpointActionValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBreakpointsRequest_BreakpointActionValue) ProtoMessage() {}

func (x *ListBreakpointsRequest_BreakpointActionValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBreakpointsRequest_BreakpointActionValue.ProtoReflect.Descriptor instead.
func (*ListBreakpointsRequest_BreakpointActionValue) Descriptor() ([]byte, []int) {
	return file_google_devtools_clouddebugger_v2_debugger_proto_rawDescGZIP(), []int{5, 0}
}

func (x *ListBreakpointsRequest_BreakpointActionValue) GetValue() Breakpoint_Action {
	if x != nil {
		return x.Value
	}
	return Breakpoint_CAPTURE
}

var File_google_devtools_clouddebugger_v2_debugger_proto protoreflect.FileDescriptor

var file_google_devtools_clouddebugger_v2_debugger_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2f,
	0x76, 0x32, 0x2f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbb, 0x01, 0x0a, 0x14, 0x53, 0x65, 0x74, 0x42, 0x72, 0x65,
	0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24,
	0x0a, 0x0b, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67,
	0x65, 0x65, 0x49, 0x64, 0x12, 0x51, 0x0a, 0x0a, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x72, 0x65, 0x61,
	0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x62, 0x72, 0x65,
	0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0x65, 0x0a, 0x15, 0x53, 0x65, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0a,
	0x62, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0a,
	0x62, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x92, 0x01, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64,
	0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x62, 0x72, 0x65,
	0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x65, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4c, 0x0a, 0x0a, 0x62, 0x72, 0x65, 0x61,
	0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0a, 0x62, 0x72, 0x65, 0x61,
	0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x95, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x65,
	0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x62, 0x72, 0x65, 0x61,
	0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd5,
	0x03, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x65, 0x62,
	0x75, 0x67, 0x67, 0x65, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x49, 0x64, 0x12,
	0x2a, 0x0a, 0x11, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x41, 0x6c, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x69,
	0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x69, 0x6e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6e,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x66, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65,
	0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x72,
	0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x27,
	0x0a, 0x0d, 0x73, 0x74, 0x72, 0x69, 0x70, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x70,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x77, 0x61, 0x69, 0x74, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x77, 0x61, 0x69,
	0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2a, 0x0a, 0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x1a, 0x62, 0x0a, 0x15, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x49, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x72,
	0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x91, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x42,
	0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x4e, 0x0a, 0x0b, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x42, 0x72, 0x65, 0x61, 0x6b,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x0b, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x77, 0x61, 0x69, 0x74, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x57, 0x61, 0x69, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8c, 0x01, 0x0a, 0x14, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x69, 0x6e,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x69, 0x6e,
	0x63, 0x6c, 0x75, 0x64, 0x65, 0x49, 0x6e, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x2a, 0x0a,
	0x0e, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x61, 0x0a, 0x15, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x48, 0x0a, 0x09, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62,
	0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65,
	0x65, 0x52, 0x09, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x73, 0x32, 0xf2, 0x09, 0x0a,
	0x09, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x32, 0x12, 0xf2, 0x01, 0x0a, 0x0d, 0x53,
	0x65, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x65, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75,
	0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x65, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x70, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22, 0x34, 0x2f, 0x76, 0x32, 0x2f, 0x64, 0x65, 0x62, 0x75, 0x67,
	0x67, 0x65, 0x72, 0x2f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x72, 0x65, 0x61,
	0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x73, 0x65, 0x74, 0x3a, 0x0a, 0x62, 0x72, 0x65,
	0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0xda, 0x41, 0x25, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67,
	0x65, 0x65, 0x5f, 0x69, 0x64, 0x2c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x2c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0xf5, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x74,
	0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x32, 0x2f,
	0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65,
	0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x62, 0x72,
	0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0xda, 0x41, 0x28, 0x64,
	0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x5f, 0x69, 0x64, 0x2c, 0x62, 0x72, 0x65, 0x61, 0x6b,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0xda, 0x01, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x2a, 0x40, 0x2f, 0x76, 0x32, 0x2f, 0x64, 0x65, 0x62,
	0x75, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x73, 0x2f,
	0x7b, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x72,
	0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x62, 0x72, 0x65, 0x61, 0x6b,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0xda, 0x41, 0x28, 0x64, 0x65, 0x62, 0x75,
	0x67, 0x67, 0x65, 0x65, 0x5f, 0x69, 0x64, 0x2c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0xdd, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x72, 0x65,
	0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x72, 0x65, 0x61, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x55, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x32, 0x2f, 0x64, 0x65, 0x62, 0x75, 0x67,
	0x67, 0x65, 0x72, 0x2f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x62, 0x72, 0x65, 0x61,
	0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0xda, 0x41, 0x1a, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67,
	0x65, 0x65, 0x5f, 0x69, 0x64, 0x2c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0xb9, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x62,
	0x75, 0x67, 0x67, 0x65, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65,
	0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65,
	0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x12,
	0x16, 0x2f, 0x76, 0x32, 0x2f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x64, 0x65,
	0x62, 0x75, 0x67, 0x67, 0x65, 0x65, 0x73, 0xda, 0x41, 0x16, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x2c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x1a, 0x7f, 0xca, 0x41, 0x1c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x5d, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65,
	0x72, 0x42, 0xbc, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x42, 0x0d, 0x44, 0x65, 0x62, 0x75,
	0x67, 0x67, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x32, 0x3b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67,
	0x65, 0x72, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x65, 0x72, 0x5c, 0x56, 0x32,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_clouddebugger_v2_debugger_proto_rawDescOnce sync.Once
	file_google_devtools_clouddebugger_v2_debugger_proto_rawDescData = file_google_devtools_clouddebugger_v2_debugger_proto_rawDesc
)

func file_google_devtools_clouddebugger_v2_debugger_proto_rawDescGZIP() []byte {
	file_google_devtools_clouddebugger_v2_debugger_proto_rawDescOnce.Do(func() {
		file_google_devtools_clouddebugger_v2_debugger_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_clouddebugger_v2_debugger_proto_rawDescData)
	})
	return file_google_devtools_clouddebugger_v2_debugger_proto_rawDescData
}

var file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_devtools_clouddebugger_v2_debugger_proto_goTypes = []interface{}{
	(*SetBreakpointRequest)(nil),                         // 0: google.devtools.clouddebugger.v2.SetBreakpointRequest
	(*SetBreakpointResponse)(nil),                        // 1: google.devtools.clouddebugger.v2.SetBreakpointResponse
	(*GetBreakpointRequest)(nil),                         // 2: google.devtools.clouddebugger.v2.GetBreakpointRequest
	(*GetBreakpointResponse)(nil),                        // 3: google.devtools.clouddebugger.v2.GetBreakpointResponse
	(*DeleteBreakpointRequest)(nil),                      // 4: google.devtools.clouddebugger.v2.DeleteBreakpointRequest
	(*ListBreakpointsRequest)(nil),                       // 5: google.devtools.clouddebugger.v2.ListBreakpointsRequest
	(*ListBreakpointsResponse)(nil),                      // 6: google.devtools.clouddebugger.v2.ListBreakpointsResponse
	(*ListDebuggeesRequest)(nil),                         // 7: google.devtools.clouddebugger.v2.ListDebuggeesRequest
	(*ListDebuggeesResponse)(nil),                        // 8: google.devtools.clouddebugger.v2.ListDebuggeesResponse
	(*ListBreakpointsRequest_BreakpointActionValue)(nil), // 9: google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
	(*Breakpoint)(nil),                                   // 10: google.devtools.clouddebugger.v2.Breakpoint
	(*Debuggee)(nil),                                     // 11: google.devtools.clouddebugger.v2.Debuggee
	(Breakpoint_Action)(0),                               // 12: google.devtools.clouddebugger.v2.Breakpoint.Action
	(*empty.Empty)(nil),                                  // 13: google.protobuf.Empty
}
var file_google_devtools_clouddebugger_v2_debugger_proto_depIdxs = []int32{
	10, // 0: google.devtools.clouddebugger.v2.SetBreakpointRequest.breakpoint:type_name -> google.devtools.clouddebugger.v2.Breakpoint
	10, // 1: google.devtools.clouddebugger.v2.SetBreakpointResponse.breakpoint:type_name -> google.devtools.clouddebugger.v2.Breakpoint
	10, // 2: google.devtools.clouddebugger.v2.GetBreakpointResponse.breakpoint:type_name -> google.devtools.clouddebugger.v2.Breakpoint
	9,  // 3: google.devtools.clouddebugger.v2.ListBreakpointsRequest.action:type_name -> google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue
	10, // 4: google.devtools.clouddebugger.v2.ListBreakpointsResponse.breakpoints:type_name -> google.devtools.clouddebugger.v2.Breakpoint
	11, // 5: google.devtools.clouddebugger.v2.ListDebuggeesResponse.debuggees:type_name -> google.devtools.clouddebugger.v2.Debuggee
	12, // 6: google.devtools.clouddebugger.v2.ListBreakpointsRequest.BreakpointActionValue.value:type_name -> google.devtools.clouddebugger.v2.Breakpoint.Action
	0,  // 7: google.devtools.clouddebugger.v2.Debugger2.SetBreakpoint:input_type -> google.devtools.clouddebugger.v2.SetBreakpointRequest
	2,  // 8: google.devtools.clouddebugger.v2.Debugger2.GetBreakpoint:input_type -> google.devtools.clouddebugger.v2.GetBreakpointRequest
	4,  // 9: google.devtools.clouddebugger.v2.Debugger2.DeleteBreakpoint:input_type -> google.devtools.clouddebugger.v2.DeleteBreakpointRequest
	5,  // 10: google.devtools.clouddebugger.v2.Debugger2.ListBreakpoints:input_type -> google.devtools.clouddebugger.v2.ListBreakpointsRequest
	7,  // 11: google.devtools.clouddebugger.v2.Debugger2.ListDebuggees:input_type -> google.devtools.clouddebugger.v2.ListDebuggeesRequest
	1,  // 12: google.devtools.clouddebugger.v2.Debugger2.SetBreakpoint:output_type -> google.devtools.clouddebugger.v2.SetBreakpointResponse
	3,  // 13: google.devtools.clouddebugger.v2.Debugger2.GetBreakpoint:output_type -> google.devtools.clouddebugger.v2.GetBreakpointResponse
	13, // 14: google.devtools.clouddebugger.v2.Debugger2.DeleteBreakpoint:output_type -> google.protobuf.Empty
	6,  // 15: google.devtools.clouddebugger.v2.Debugger2.ListBreakpoints:output_type -> google.devtools.clouddebugger.v2.ListBreakpointsResponse
	8,  // 16: google.devtools.clouddebugger.v2.Debugger2.ListDebuggees:output_type -> google.devtools.clouddebugger.v2.ListDebuggeesResponse
	12, // [12:17] is the sub-list for method output_type
	7,  // [7:12] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_devtools_clouddebugger_v2_debugger_proto_init() }
func file_google_devtools_clouddebugger_v2_debugger_proto_init() {
	if File_google_devtools_clouddebugger_v2_debugger_proto != nil {
		return
	}
	file_google_devtools_clouddebugger_v2_data_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetBreakpointRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SetBreakpointResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBreakpointRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBreakpointResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBreakpointRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBreakpointsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBreakpointsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDebuggeesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDebuggeesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBreakpointsRequest_BreakpointActionValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_clouddebugger_v2_debugger_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_clouddebugger_v2_debugger_proto_goTypes,
		DependencyIndexes: file_google_devtools_clouddebugger_v2_debugger_proto_depIdxs,
		MessageInfos:      file_google_devtools_clouddebugger_v2_debugger_proto_msgTypes,
	}.Build()
	File_google_devtools_clouddebugger_v2_debugger_proto = out.File
	file_google_devtools_clouddebugger_v2_debugger_proto_rawDesc = nil
	file_google_devtools_clouddebugger_v2_debugger_proto_goTypes = nil
	file_google_devtools_clouddebugger_v2_debugger_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// Debugger2Client is the client API for Debugger2 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type Debugger2Client interface {
	// Sets the breakpoint to the debuggee.
	SetBreakpoint(ctx context.Context, in *SetBreakpointRequest, opts ...grpc.CallOption) (*SetBreakpointResponse, error)
	// Gets breakpoint information.
	GetBreakpoint(ctx context.Context, in *GetBreakpointRequest, opts ...grpc.CallOption) (*GetBreakpointResponse, error)
	// Deletes the breakpoint from the debuggee.
	DeleteBreakpoint(ctx context.Context, in *DeleteBreakpointRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists all breakpoints for the debuggee.
	ListBreakpoints(ctx context.Context, in *ListBreakpointsRequest, opts ...grpc.CallOption) (*ListBreakpointsResponse, error)
	// Lists all the debuggees that the user has access to.
	ListDebuggees(ctx context.Context, in *ListDebuggeesRequest, opts ...grpc.CallOption) (*ListDebuggeesResponse, error)
}

type debugger2Client struct {
	cc grpc.ClientConnInterface
}

func NewDebugger2Client(cc grpc.ClientConnInterface) Debugger2Client {
	return &debugger2Client{cc}
}

func (c *debugger2Client) SetBreakpoint(ctx context.Context, in *SetBreakpointRequest, opts ...grpc.CallOption) (*SetBreakpointResponse, error) {
	out := new(SetBreakpointResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/SetBreakpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) GetBreakpoint(ctx context.Context, in *GetBreakpointRequest, opts ...grpc.CallOption) (*GetBreakpointResponse, error) {
	out := new(GetBreakpointResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/GetBreakpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) DeleteBreakpoint(ctx context.Context, in *DeleteBreakpointRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/DeleteBreakpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) ListBreakpoints(ctx context.Context, in *ListBreakpointsRequest, opts ...grpc.CallOption) (*ListBreakpointsResponse, error) {
	out := new(ListBreakpointsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/ListBreakpoints", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *debugger2Client) ListDebuggees(ctx context.Context, in *ListDebuggeesRequest, opts ...grpc.CallOption) (*ListDebuggeesResponse, error) {
	out := new(ListDebuggeesResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.clouddebugger.v2.Debugger2/ListDebuggees", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Debugger2Server is the server API for Debugger2 service.
type Debugger2Server interface {
	// Sets the breakpoint to the debuggee.
	SetBreakpoint(context.Context, *SetBreakpointRequest) (*SetBreakpointResponse, error)
	// Gets breakpoint information.
	GetBreakpoint(context.Context, *GetBreakpointRequest) (*GetBreakpointResponse, error)
	// Deletes the breakpoint from the debuggee.
	DeleteBreakpoint(context.Context, *DeleteBreakpointRequest) (*empty.Empty, error)
	// Lists all breakpoints for the debuggee.
	ListBreakpoints(context.Context, *ListBreakpointsRequest) (*ListBreakpointsResponse, error)
	// Lists all the debuggees that the user has access to.
	ListDebuggees(context.Context, *ListDebuggeesRequest) (*ListDebuggeesResponse, error)
}

// UnimplementedDebugger2Server can be embedded to have forward compatible implementations.
type UnimplementedDebugger2Server struct {
}

func (*UnimplementedDebugger2Server) SetBreakpoint(context.Context, *SetBreakpointRequest) (*SetBreakpointResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetBreakpoint not implemented")
}
func (*UnimplementedDebugger2Server) GetBreakpoint(context.Context, *GetBreakpointRequest) (*GetBreakpointResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBreakpoint not implemented")
}
func (*UnimplementedDebugger2Server) DeleteBreakpoint(context.Context, *DeleteBreakpointRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBreakpoint not implemented")
}
func (*UnimplementedDebugger2Server) ListBreakpoints(context.Context, *ListBreakpointsRequest) (*ListBreakpointsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBreakpoints not implemented")
}
func (*UnimplementedDebugger2Server) ListDebuggees(context.Context, *ListDebuggeesRequest) (*ListDebuggeesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDebuggees not implemented")
}

func RegisterDebugger2Server(s *grpc.Server, srv Debugger2Server) {
	s.RegisterService(&_Debugger2_serviceDesc, srv)
}

func _Debugger2_SetBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).SetBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/SetBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).SetBreakpoint(ctx, req.(*SetBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_GetBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).GetBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/GetBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).GetBreakpoint(ctx, req.(*GetBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_DeleteBreakpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBreakpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).DeleteBreakpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/DeleteBreakpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).DeleteBreakpoint(ctx, req.(*DeleteBreakpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_ListBreakpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBreakpointsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).ListBreakpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/ListBreakpoints",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).ListBreakpoints(ctx, req.(*ListBreakpointsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Debugger2_ListDebuggees_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDebuggeesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(Debugger2Server).ListDebuggees(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.clouddebugger.v2.Debugger2/ListDebuggees",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(Debugger2Server).ListDebuggees(ctx, req.(*ListDebuggeesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Debugger2_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.clouddebugger.v2.Debugger2",
	HandlerType: (*Debugger2Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SetBreakpoint",
			Handler:    _Debugger2_SetBreakpoint_Handler,
		},
		{
			MethodName: "GetBreakpoint",
			Handler:    _Debugger2_GetBreakpoint_Handler,
		},
		{
			MethodName: "DeleteBreakpoint",
			Handler:    _Debugger2_DeleteBreakpoint_Handler,
		},
		{
			MethodName: "ListBreakpoints",
			Handler:    _Debugger2_ListBreakpoints_Handler,
		},
		{
			MethodName: "ListDebuggees",
			Handler:    _Debugger2_ListDebuggees_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/clouddebugger/v2/debugger.proto",
}
