// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.2
// source: google/cloud/gaming/v1beta/game_server_deployments.proto

package gaming

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Request message for GameServerDeploymentsService.ListGameServerDeployments.
type ListGameServerDeploymentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name. Uses the form:
	// `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.  If unspecified, server
	// will pick an appropriate default. Server may return fewer items than
	// requested. A caller should only rely on response's
	// [next_page_token][google.cloud.gaming.v1beta.ListGameServerDeploymentsResponse.next_page_token] to
	// determine if there are more GameServerDeployments left to be queried.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous List request,
	// if any.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter to apply to list results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Specifies the ordering of results following syntax at
	// https://cloud.google.com/apis/design/design_patterns#sorting_order.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListGameServerDeploymentsRequest) Reset() {
	*x = ListGameServerDeploymentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGameServerDeploymentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGameServerDeploymentsRequest) ProtoMessage() {}

func (x *ListGameServerDeploymentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGameServerDeploymentsRequest.ProtoReflect.Descriptor instead.
func (*ListGameServerDeploymentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{0}
}

func (x *ListGameServerDeploymentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGameServerDeploymentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGameServerDeploymentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListGameServerDeploymentsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListGameServerDeploymentsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for GameServerDeploymentsService.ListGameServerDeployments.
type ListGameServerDeploymentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of Game Server Delpoyments.
	GameServerDeployments []*GameServerDeployment `protobuf:"bytes,1,rep,name=game_server_deployments,json=gameServerDeployments,proto3" json:"game_server_deployments,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// List of Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,4,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListGameServerDeploymentsResponse) Reset() {
	*x = ListGameServerDeploymentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListGameServerDeploymentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGameServerDeploymentsResponse) ProtoMessage() {}

func (x *ListGameServerDeploymentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGameServerDeploymentsResponse.ProtoReflect.Descriptor instead.
func (*ListGameServerDeploymentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{1}
}

func (x *ListGameServerDeploymentsResponse) GetGameServerDeployments() []*GameServerDeployment {
	if x != nil {
		return x.GameServerDeployments
	}
	return nil
}

func (x *ListGameServerDeploymentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListGameServerDeploymentsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for GameServerDeploymentsService.GetGameServerDeployment.
type GetGameServerDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Game Server Deployment to retrieve. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGameServerDeploymentRequest) Reset() {
	*x = GetGameServerDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGameServerDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGameServerDeploymentRequest) ProtoMessage() {}

func (x *GetGameServerDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGameServerDeploymentRequest.ProtoReflect.Descriptor instead.
func (*GetGameServerDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{2}
}

func (x *GetGameServerDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// GameServerDeploymentsService.GetGameServerDeploymentRollout.
type GetGameServerDeploymentRolloutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Game Server Deployment to retrieve. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGameServerDeploymentRolloutRequest) Reset() {
	*x = GetGameServerDeploymentRolloutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetGameServerDeploymentRolloutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGameServerDeploymentRolloutRequest) ProtoMessage() {}

func (x *GetGameServerDeploymentRolloutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGameServerDeploymentRolloutRequest.ProtoReflect.Descriptor instead.
func (*GetGameServerDeploymentRolloutRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{3}
}

func (x *GetGameServerDeploymentRolloutRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GameServerDeploymentsService.CreateGameServerDeployment.
type CreateGameServerDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name. Uses the form:
	// `projects/{project}/locations/{location}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the Game Server Deployment resource to be created.
	DeploymentId string `protobuf:"bytes,2,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Required. The Game Server Deployment resource to be created.
	GameServerDeployment *GameServerDeployment `protobuf:"bytes,3,opt,name=game_server_deployment,json=gameServerDeployment,proto3" json:"game_server_deployment,omitempty"`
}

func (x *CreateGameServerDeploymentRequest) Reset() {
	*x = CreateGameServerDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateGameServerDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGameServerDeploymentRequest) ProtoMessage() {}

func (x *CreateGameServerDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGameServerDeploymentRequest.ProtoReflect.Descriptor instead.
func (*CreateGameServerDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{4}
}

func (x *CreateGameServerDeploymentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGameServerDeploymentRequest) GetDeploymentId() string {
	if x != nil {
		return x.DeploymentId
	}
	return ""
}

func (x *CreateGameServerDeploymentRequest) GetGameServerDeployment() *GameServerDeployment {
	if x != nil {
		return x.GameServerDeployment
	}
	return nil
}

// Request message for GameServerDeploymentsService.DeleteGameServerDeployment.
type DeleteGameServerDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Game Server Deployment to delete. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteGameServerDeploymentRequest) Reset() {
	*x = DeleteGameServerDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteGameServerDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGameServerDeploymentRequest) ProtoMessage() {}

func (x *DeleteGameServerDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGameServerDeploymentRequest.ProtoReflect.Descriptor instead.
func (*DeleteGameServerDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteGameServerDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for GameServerDeploymentsService.UpdateGameServerDeployment.
// Only allows updates for labels.
type UpdateGameServerDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Game Server Deployment to be updated.
	// Only fields specified in update_mask are updated.
	GameServerDeployment *GameServerDeployment `protobuf:"bytes,1,opt,name=game_server_deployment,json=gameServerDeployment,proto3" json:"game_server_deployment,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. For the `FieldMask` definition, see
	//
	// https:
	// //developers.google.com/protocol-buffers
	// // /docs/reference/google.protobuf#fieldmask
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGameServerDeploymentRequest) Reset() {
	*x = UpdateGameServerDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGameServerDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGameServerDeploymentRequest) ProtoMessage() {}

func (x *UpdateGameServerDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGameServerDeploymentRequest.ProtoReflect.Descriptor instead.
func (*UpdateGameServerDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateGameServerDeploymentRequest) GetGameServerDeployment() *GameServerDeployment {
	if x != nil {
		return x.GameServerDeployment
	}
	return nil
}

func (x *UpdateGameServerDeploymentRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for
// GameServerDeploymentsService.UpdateGameServerRolloutDeployment.
type UpdateGameServerDeploymentRolloutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Game Server Deployment Rollout to be updated.
	// Only fields specified in update_mask are updated.
	Rollout *GameServerDeploymentRollout `protobuf:"bytes,1,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Required. Mask of fields to update. At least one path must be supplied in
	// this field. For the `FieldMask` definition, see
	//
	// https:
	// //developers.google.com/protocol-buffers
	// // /docs/reference/google.protobuf#fieldmask
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateGameServerDeploymentRolloutRequest) Reset() {
	*x = UpdateGameServerDeploymentRolloutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateGameServerDeploymentRolloutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGameServerDeploymentRolloutRequest) ProtoMessage() {}

func (x *UpdateGameServerDeploymentRolloutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGameServerDeploymentRolloutRequest.ProtoReflect.Descriptor instead.
func (*UpdateGameServerDeploymentRolloutRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateGameServerDeploymentRolloutRequest) GetRollout() *GameServerDeploymentRollout {
	if x != nil {
		return x.Rollout
	}
	return nil
}

func (x *UpdateGameServerDeploymentRolloutRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for GameServerDeploymentsService.FetchDeploymentState.
type FetchDeploymentStateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Game Server Deployment. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *FetchDeploymentStateRequest) Reset() {
	*x = FetchDeploymentStateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchDeploymentStateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchDeploymentStateRequest) ProtoMessage() {}

func (x *FetchDeploymentStateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchDeploymentStateRequest.ProtoReflect.Descriptor instead.
func (*FetchDeploymentStateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{8}
}

func (x *FetchDeploymentStateRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for GameServerDeploymentsService.FetchDeploymentState.
type FetchDeploymentStateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The state of the Game Server Deployment in each Game Server Cluster.
	ClusterState []*FetchDeploymentStateResponse_DeployedClusterState `protobuf:"bytes,1,rep,name=cluster_state,json=clusterState,proto3" json:"cluster_state,omitempty"`
	// List of Locations that could not be reached.
	Unavailable []string `protobuf:"bytes,2,rep,name=unavailable,proto3" json:"unavailable,omitempty"`
}

func (x *FetchDeploymentStateResponse) Reset() {
	*x = FetchDeploymentStateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchDeploymentStateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchDeploymentStateResponse) ProtoMessage() {}

func (x *FetchDeploymentStateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchDeploymentStateResponse.ProtoReflect.Descriptor instead.
func (*FetchDeploymentStateResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{9}
}

func (x *FetchDeploymentStateResponse) GetClusterState() []*FetchDeploymentStateResponse_DeployedClusterState {
	if x != nil {
		return x.ClusterState
	}
	return nil
}

func (x *FetchDeploymentStateResponse) GetUnavailable() []string {
	if x != nil {
		return x.Unavailable
	}
	return nil
}

// A Game Server Deployment resource.
type GameServerDeployment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Game Server Deployment. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment}`.
	// For example,
	//
	// `projects/my-project/locations/{location}/gameServerDeployments/my-deployment`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last-modified time.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The labels associated with this Game Server Deployment. Each label is a
	// key-value pair.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// ETag of the resource.
	Etag string `protobuf:"bytes,7,opt,name=etag,proto3" json:"etag,omitempty"`
	// Human readable description of the Game Server Deployment.
	Description string `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *GameServerDeployment) Reset() {
	*x = GameServerDeployment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GameServerDeployment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GameServerDeployment) ProtoMessage() {}

func (x *GameServerDeployment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GameServerDeployment.ProtoReflect.Descriptor instead.
func (*GameServerDeployment) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{10}
}

func (x *GameServerDeployment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GameServerDeployment) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *GameServerDeployment) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *GameServerDeployment) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *GameServerDeployment) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *GameServerDeployment) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// A Game Server Config override.
type GameServerConfigOverride struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Selector chooses the Game Server Config targets.
	//
	// Types that are assignable to Selector:
	//	*GameServerConfigOverride_RealmsSelector
	Selector isGameServerConfigOverride_Selector `protobuf_oneof:"selector"`
	// Selects the Game Server Config and how it should be applied.
	//
	// Types that are assignable to Change:
	//	*GameServerConfigOverride_ConfigVersion
	Change isGameServerConfigOverride_Change `protobuf_oneof:"change"`
}

func (x *GameServerConfigOverride) Reset() {
	*x = GameServerConfigOverride{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GameServerConfigOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GameServerConfigOverride) ProtoMessage() {}

func (x *GameServerConfigOverride) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GameServerConfigOverride.ProtoReflect.Descriptor instead.
func (*GameServerConfigOverride) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{11}
}

func (m *GameServerConfigOverride) GetSelector() isGameServerConfigOverride_Selector {
	if m != nil {
		return m.Selector
	}
	return nil
}

func (x *GameServerConfigOverride) GetRealmsSelector() *RealmSelector {
	if x, ok := x.GetSelector().(*GameServerConfigOverride_RealmsSelector); ok {
		return x.RealmsSelector
	}
	return nil
}

func (m *GameServerConfigOverride) GetChange() isGameServerConfigOverride_Change {
	if m != nil {
		return m.Change
	}
	return nil
}

func (x *GameServerConfigOverride) GetConfigVersion() string {
	if x, ok := x.GetChange().(*GameServerConfigOverride_ConfigVersion); ok {
		return x.ConfigVersion
	}
	return ""
}

type isGameServerConfigOverride_Selector interface {
	isGameServerConfigOverride_Selector()
}

type GameServerConfigOverride_RealmsSelector struct {
	// Selector for choosing applicable realms.
	RealmsSelector *RealmSelector `protobuf:"bytes,1,opt,name=realms_selector,json=realmsSelector,proto3,oneof"`
}

func (*GameServerConfigOverride_RealmsSelector) isGameServerConfigOverride_Selector() {}

type isGameServerConfigOverride_Change interface {
	isGameServerConfigOverride_Change()
}

type GameServerConfigOverride_ConfigVersion struct {
	// The game server config for this override.
	ConfigVersion string `protobuf:"bytes,100,opt,name=config_version,json=configVersion,proto3,oneof"`
}

func (*GameServerConfigOverride_ConfigVersion) isGameServerConfigOverride_Change() {}

// The Game Server Deployment Rollout which represents the desired rollout
// state.
type GameServerDeploymentRollout struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the Game Server Deployment Rollout. Uses the form:
	//
	// `projects/{project}/locations/{location}/gameServerDeployments/{deployment}/rollout`.
	// For example,
	//
	// `projects/my-project/locations/{location}/gameServerDeployments/my-deployment/rollout`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last-modified time.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The default Game Server Config is applied to all Realms unless overridden
	// in the Rollout. For example,
	//
	// `projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config`.
	DefaultGameServerConfig string `protobuf:"bytes,4,opt,name=default_game_server_config,json=defaultGameServerConfig,proto3" json:"default_game_server_config,omitempty"`
	// Contains the Game Server Config Rollout overrides. Overrides are processed
	// in the order they are listed. Once a match is found for a Realm, the rest
	// of the list is not processed.
	GameServerConfigOverrides []*GameServerConfigOverride `protobuf:"bytes,5,rep,name=game_server_config_overrides,json=gameServerConfigOverrides,proto3" json:"game_server_config_overrides,omitempty"`
	// ETag of the resource.
	Etag string `protobuf:"bytes,6,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *GameServerDeploymentRollout) Reset() {
	*x = GameServerDeploymentRollout{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GameServerDeploymentRollout) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GameServerDeploymentRollout) ProtoMessage() {}

func (x *GameServerDeploymentRollout) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GameServerDeploymentRollout.ProtoReflect.Descriptor instead.
func (*GameServerDeploymentRollout) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{12}
}

func (x *GameServerDeploymentRollout) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GameServerDeploymentRollout) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *GameServerDeploymentRollout) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *GameServerDeploymentRollout) GetDefaultGameServerConfig() string {
	if x != nil {
		return x.DefaultGameServerConfig
	}
	return ""
}

func (x *GameServerDeploymentRollout) GetGameServerConfigOverrides() []*GameServerConfigOverride {
	if x != nil {
		return x.GameServerConfigOverrides
	}
	return nil
}

func (x *GameServerDeploymentRollout) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Request message for PreviewGameServerDeploymentRollout.
type PreviewGameServerDeploymentRolloutRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Game Server Deployment Rollout to be updated.
	// Only fields specified in update_mask are updated.
	Rollout *GameServerDeploymentRollout `protobuf:"bytes,1,opt,name=rollout,proto3" json:"rollout,omitempty"`
	// Optional. Mask of fields to update. At least one path must be supplied in
	// this field. For the `FieldMask` definition, see
	//
	// https:
	// //developers.google.com/protocol-buffers
	// // /docs/reference/google.protobuf#fieldmask
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The target timestamp to compute the preview. Defaults to the immediately
	// after the proposed Rollout completes.
	PreviewTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=preview_time,json=previewTime,proto3" json:"preview_time,omitempty"`
}

func (x *PreviewGameServerDeploymentRolloutRequest) Reset() {
	*x = PreviewGameServerDeploymentRolloutRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewGameServerDeploymentRolloutRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewGameServerDeploymentRolloutRequest) ProtoMessage() {}

func (x *PreviewGameServerDeploymentRolloutRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewGameServerDeploymentRolloutRequest.ProtoReflect.Descriptor instead.
func (*PreviewGameServerDeploymentRolloutRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{13}
}

func (x *PreviewGameServerDeploymentRolloutRequest) GetRollout() *GameServerDeploymentRollout {
	if x != nil {
		return x.Rollout
	}
	return nil
}

func (x *PreviewGameServerDeploymentRolloutRequest) GetUpdateMask() *field_mask.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *PreviewGameServerDeploymentRolloutRequest) GetPreviewTime() *timestamp.Timestamp {
	if x != nil {
		return x.PreviewTime
	}
	return nil
}

// Response message for PreviewGameServerDeploymentRollout.
// This has details about the Agones fleet and autoscaler to be actuated.
type PreviewGameServerDeploymentRolloutResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Locations that could not be reached on this request.
	Unavailable []string `protobuf:"bytes,2,rep,name=unavailable,proto3" json:"unavailable,omitempty"`
	// ETag of the Game Server Deployment.
	Etag string `protobuf:"bytes,3,opt,name=etag,proto3" json:"etag,omitempty"`
	// The target state.
	TargetState *TargetState `protobuf:"bytes,4,opt,name=target_state,json=targetState,proto3" json:"target_state,omitempty"`
}

func (x *PreviewGameServerDeploymentRolloutResponse) Reset() {
	*x = PreviewGameServerDeploymentRolloutResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewGameServerDeploymentRolloutResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewGameServerDeploymentRolloutResponse) ProtoMessage() {}

func (x *PreviewGameServerDeploymentRolloutResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewGameServerDeploymentRolloutResponse.ProtoReflect.Descriptor instead.
func (*PreviewGameServerDeploymentRolloutResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{14}
}

func (x *PreviewGameServerDeploymentRolloutResponse) GetUnavailable() []string {
	if x != nil {
		return x.Unavailable
	}
	return nil
}

func (x *PreviewGameServerDeploymentRolloutResponse) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *PreviewGameServerDeploymentRolloutResponse) GetTargetState() *TargetState {
	if x != nil {
		return x.TargetState
	}
	return nil
}

// The Game Server Cluster changes made by the Game Server Deployment.
type FetchDeploymentStateResponse_DeployedClusterState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the cluster.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// The details about the Agones fleets and autoscalers created in the
	// Game Server Cluster.
	FleetDetails []*DeployedFleetDetails `protobuf:"bytes,2,rep,name=fleet_details,json=fleetDetails,proto3" json:"fleet_details,omitempty"`
}

func (x *FetchDeploymentStateResponse_DeployedClusterState) Reset() {
	*x = FetchDeploymentStateResponse_DeployedClusterState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FetchDeploymentStateResponse_DeployedClusterState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchDeploymentStateResponse_DeployedClusterState) ProtoMessage() {}

func (x *FetchDeploymentStateResponse_DeployedClusterState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchDeploymentStateResponse_DeployedClusterState.ProtoReflect.Descriptor instead.
func (*FetchDeploymentStateResponse_DeployedClusterState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP(), []int{9, 0}
}

func (x *FetchDeploymentStateResponse_DeployedClusterState) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *FetchDeploymentStateResponse_DeployedClusterState) GetFleetDetails() []*DeployedFleetDetails {
	if x != nil {
		return x.FleetDetails
	}
	return nil
}

var File_google_cloud_gaming_v1beta_game_server_deployments_proto protoreflect.FileDescriptor

var file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDesc = []byte{
	0x0a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x67, 0x61, 0x6d,
	0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf7, 0x01, 0x0a,
	0x20, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x67, 0x61, 0x6d, 0x65, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xd7, 0x01, 0x0a, 0x21, 0x4c, 0x69, 0x73, 0x74, 0x47,
	0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x68, 0x0a, 0x17,
	0x67, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x61, 0x6d, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x15, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x6e, 0x0a, 0x1e, 0x47, 0x65, 0x74, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x67, 0x61, 0x6d, 0x65, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x75, 0x0a, 0x25, 0x47, 0x65, 0x74, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f,
	0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a,
	0x30, 0x67, 0x61, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x8c, 0x02, 0x0a, 0x21, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x67, 0x61, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x28, 0x0a, 0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x6b, 0x0a, 0x16, 0x67, 0x61, 0x6d,
	0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x14, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x71, 0x0a, 0x21, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x32, 0x0a, 0x30, 0x67, 0x61, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47,
	0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd2, 0x01, 0x0a, 0x21, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x6b, 0x0a, 0x16, 0x67, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x61, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x14, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xc4,
	0x01, 0x0a, 0x28, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56, 0x0a, 0x07, 0x72,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f,
	0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72, 0x6f, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x36, 0x0a, 0x1b, 0x46, 0x65, 0x74, 0x63, 0x68, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbe, 0x02,
	0x0a, 0x1c, 0x46, 0x65, 0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x72,
	0x0a, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x0c, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c,
	0x61, 0x62, 0x6c, 0x65, 0x1a, 0x87, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65,
	0x64, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x55, 0x0a, 0x0d, 0x66, 0x6c, 0x65, 0x65, 0x74,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x65, 0x64, 0x46, 0x6c, 0x65, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x52, 0x0c, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xf9,
	0x03, 0x0a, 0x14, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x54, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x61, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e, 0x0a, 0x30, 0x67, 0x61,
	0x6d, 0x65, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65,
	0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4a,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x22, 0xaf, 0x01, 0x0a, 0x18, 0x47,
	0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x54, 0x0a, 0x0f, 0x72, 0x65, 0x61, 0x6c, 0x6d,
	0x73, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x52, 0x65,
	0x61, 0x6c, 0x6d, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x48, 0x00, 0x52, 0x0e, 0x72,
	0x65, 0x61, 0x6c, 0x6d, 0x73, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x27, 0x0a,
	0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x64, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x0a, 0x08, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x22, 0x91, 0x04, 0x0a,
	0x1b, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x1a, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f,
	0x67, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x75, 0x0a, 0x1c, 0x67, 0x61, 0x6d, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x19, 0x67,
	0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x3a, 0x91, 0x01, 0xea,
	0x41, 0x8d, 0x01, 0x0a, 0x37, 0x67, 0x61, 0x6d, 0x65, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x52, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x67, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74,
	0x22, 0x89, 0x02, 0x0a, 0x29, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x47, 0x61, 0x6d, 0x65,
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x56,
	0x0a, 0x07, 0x72, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x61, 0x6d,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x72,
	0x6f, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x42, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xae, 0x01, 0x0a,
	0x2a, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x47, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x6c, 0x6c,
	0x6f, 0x75, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x75,
	0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x75, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x12, 0x4a, 0x0a, 0x0c, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x64, 0x0a,
	0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x50,
	0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x3b, 0x67, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescOnce sync.Once
	file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescData = file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDesc
)

func file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescGZIP() []byte {
	file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescOnce.Do(func() {
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescData)
	})
	return file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDescData
}

var file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes = make([]protoimpl.MessageInfo, 17)
var file_google_cloud_gaming_v1beta_game_server_deployments_proto_goTypes = []interface{}{
	(*ListGameServerDeploymentsRequest)(nil),                  // 0: google.cloud.gaming.v1beta.ListGameServerDeploymentsRequest
	(*ListGameServerDeploymentsResponse)(nil),                 // 1: google.cloud.gaming.v1beta.ListGameServerDeploymentsResponse
	(*GetGameServerDeploymentRequest)(nil),                    // 2: google.cloud.gaming.v1beta.GetGameServerDeploymentRequest
	(*GetGameServerDeploymentRolloutRequest)(nil),             // 3: google.cloud.gaming.v1beta.GetGameServerDeploymentRolloutRequest
	(*CreateGameServerDeploymentRequest)(nil),                 // 4: google.cloud.gaming.v1beta.CreateGameServerDeploymentRequest
	(*DeleteGameServerDeploymentRequest)(nil),                 // 5: google.cloud.gaming.v1beta.DeleteGameServerDeploymentRequest
	(*UpdateGameServerDeploymentRequest)(nil),                 // 6: google.cloud.gaming.v1beta.UpdateGameServerDeploymentRequest
	(*UpdateGameServerDeploymentRolloutRequest)(nil),          // 7: google.cloud.gaming.v1beta.UpdateGameServerDeploymentRolloutRequest
	(*FetchDeploymentStateRequest)(nil),                       // 8: google.cloud.gaming.v1beta.FetchDeploymentStateRequest
	(*FetchDeploymentStateResponse)(nil),                      // 9: google.cloud.gaming.v1beta.FetchDeploymentStateResponse
	(*GameServerDeployment)(nil),                              // 10: google.cloud.gaming.v1beta.GameServerDeployment
	(*GameServerConfigOverride)(nil),                          // 11: google.cloud.gaming.v1beta.GameServerConfigOverride
	(*GameServerDeploymentRollout)(nil),                       // 12: google.cloud.gaming.v1beta.GameServerDeploymentRollout
	(*PreviewGameServerDeploymentRolloutRequest)(nil),         // 13: google.cloud.gaming.v1beta.PreviewGameServerDeploymentRolloutRequest
	(*PreviewGameServerDeploymentRolloutResponse)(nil),        // 14: google.cloud.gaming.v1beta.PreviewGameServerDeploymentRolloutResponse
	(*FetchDeploymentStateResponse_DeployedClusterState)(nil), // 15: google.cloud.gaming.v1beta.FetchDeploymentStateResponse.DeployedClusterState
	nil,                          // 16: google.cloud.gaming.v1beta.GameServerDeployment.LabelsEntry
	(*field_mask.FieldMask)(nil), // 17: google.protobuf.FieldMask
	(*timestamp.Timestamp)(nil),  // 18: google.protobuf.Timestamp
	(*RealmSelector)(nil),        // 19: google.cloud.gaming.v1beta.RealmSelector
	(*TargetState)(nil),          // 20: google.cloud.gaming.v1beta.TargetState
	(*DeployedFleetDetails)(nil), // 21: google.cloud.gaming.v1beta.DeployedFleetDetails
}
var file_google_cloud_gaming_v1beta_game_server_deployments_proto_depIdxs = []int32{
	10, // 0: google.cloud.gaming.v1beta.ListGameServerDeploymentsResponse.game_server_deployments:type_name -> google.cloud.gaming.v1beta.GameServerDeployment
	10, // 1: google.cloud.gaming.v1beta.CreateGameServerDeploymentRequest.game_server_deployment:type_name -> google.cloud.gaming.v1beta.GameServerDeployment
	10, // 2: google.cloud.gaming.v1beta.UpdateGameServerDeploymentRequest.game_server_deployment:type_name -> google.cloud.gaming.v1beta.GameServerDeployment
	17, // 3: google.cloud.gaming.v1beta.UpdateGameServerDeploymentRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 4: google.cloud.gaming.v1beta.UpdateGameServerDeploymentRolloutRequest.rollout:type_name -> google.cloud.gaming.v1beta.GameServerDeploymentRollout
	17, // 5: google.cloud.gaming.v1beta.UpdateGameServerDeploymentRolloutRequest.update_mask:type_name -> google.protobuf.FieldMask
	15, // 6: google.cloud.gaming.v1beta.FetchDeploymentStateResponse.cluster_state:type_name -> google.cloud.gaming.v1beta.FetchDeploymentStateResponse.DeployedClusterState
	18, // 7: google.cloud.gaming.v1beta.GameServerDeployment.create_time:type_name -> google.protobuf.Timestamp
	18, // 8: google.cloud.gaming.v1beta.GameServerDeployment.update_time:type_name -> google.protobuf.Timestamp
	16, // 9: google.cloud.gaming.v1beta.GameServerDeployment.labels:type_name -> google.cloud.gaming.v1beta.GameServerDeployment.LabelsEntry
	19, // 10: google.cloud.gaming.v1beta.GameServerConfigOverride.realms_selector:type_name -> google.cloud.gaming.v1beta.RealmSelector
	18, // 11: google.cloud.gaming.v1beta.GameServerDeploymentRollout.create_time:type_name -> google.protobuf.Timestamp
	18, // 12: google.cloud.gaming.v1beta.GameServerDeploymentRollout.update_time:type_name -> google.protobuf.Timestamp
	11, // 13: google.cloud.gaming.v1beta.GameServerDeploymentRollout.game_server_config_overrides:type_name -> google.cloud.gaming.v1beta.GameServerConfigOverride
	12, // 14: google.cloud.gaming.v1beta.PreviewGameServerDeploymentRolloutRequest.rollout:type_name -> google.cloud.gaming.v1beta.GameServerDeploymentRollout
	17, // 15: google.cloud.gaming.v1beta.PreviewGameServerDeploymentRolloutRequest.update_mask:type_name -> google.protobuf.FieldMask
	18, // 16: google.cloud.gaming.v1beta.PreviewGameServerDeploymentRolloutRequest.preview_time:type_name -> google.protobuf.Timestamp
	20, // 17: google.cloud.gaming.v1beta.PreviewGameServerDeploymentRolloutResponse.target_state:type_name -> google.cloud.gaming.v1beta.TargetState
	21, // 18: google.cloud.gaming.v1beta.FetchDeploymentStateResponse.DeployedClusterState.fleet_details:type_name -> google.cloud.gaming.v1beta.DeployedFleetDetails
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_gaming_v1beta_game_server_deployments_proto_init() }
func file_google_cloud_gaming_v1beta_game_server_deployments_proto_init() {
	if File_google_cloud_gaming_v1beta_game_server_deployments_proto != nil {
		return
	}
	file_google_cloud_gaming_v1beta_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGameServerDeploymentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListGameServerDeploymentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGameServerDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetGameServerDeploymentRolloutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateGameServerDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteGameServerDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGameServerDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateGameServerDeploymentRolloutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchDeploymentStateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchDeploymentStateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GameServerDeployment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GameServerConfigOverride); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GameServerDeploymentRollout); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewGameServerDeploymentRolloutRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewGameServerDeploymentRolloutResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FetchDeploymentStateResponse_DeployedClusterState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*GameServerConfigOverride_RealmsSelector)(nil),
		(*GameServerConfigOverride_ConfigVersion)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   17,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gaming_v1beta_game_server_deployments_proto_goTypes,
		DependencyIndexes: file_google_cloud_gaming_v1beta_game_server_deployments_proto_depIdxs,
		MessageInfos:      file_google_cloud_gaming_v1beta_game_server_deployments_proto_msgTypes,
	}.Build()
	File_google_cloud_gaming_v1beta_game_server_deployments_proto = out.File
	file_google_cloud_gaming_v1beta_game_server_deployments_proto_rawDesc = nil
	file_google_cloud_gaming_v1beta_game_server_deployments_proto_goTypes = nil
	file_google_cloud_gaming_v1beta_game_server_deployments_proto_depIdxs = nil
}
