// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type AuthorizeIpRulesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// The rules to add to the group.
	//
	// UserRules is a required field
	UserRules []IpRuleItem `type:"list" required:"true"`
}

// String returns the string representation
func (s AuthorizeIpRulesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeIpRulesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AuthorizeIpRulesInput"}

	if s.GroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupId"))
	}

	if s.UserRules == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AuthorizeIpRulesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AuthorizeIpRulesOutput) String() string {
	return awsutil.Prettify(s)
}

const opAuthorizeIpRules = "AuthorizeIpRules"

// AuthorizeIpRulesRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Adds one or more rules to the specified IP access control group.
//
// This action gives users permission to access their WorkSpaces from the CIDR
// address ranges specified in the rules.
//
//    // Example sending a request using AuthorizeIpRulesRequest.
//    req := client.AuthorizeIpRulesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules
func (c *Client) AuthorizeIpRulesRequest(input *AuthorizeIpRulesInput) AuthorizeIpRulesRequest {
	op := &aws.Operation{
		Name:       opAuthorizeIpRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeIpRulesInput{}
	}

	req := c.newRequest(op, input, &AuthorizeIpRulesOutput{})
	return AuthorizeIpRulesRequest{Request: req, Input: input, Copy: c.AuthorizeIpRulesRequest}
}

// AuthorizeIpRulesRequest is the request type for the
// AuthorizeIpRules API operation.
type AuthorizeIpRulesRequest struct {
	*aws.Request
	Input *AuthorizeIpRulesInput
	Copy  func(*AuthorizeIpRulesInput) AuthorizeIpRulesRequest
}

// Send marshals and sends the AuthorizeIpRules API request.
func (r AuthorizeIpRulesRequest) Send(ctx context.Context) (*AuthorizeIpRulesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AuthorizeIpRulesResponse{
		AuthorizeIpRulesOutput: r.Request.Data.(*AuthorizeIpRulesOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AuthorizeIpRulesResponse is the response type for the
// AuthorizeIpRules API operation.
type AuthorizeIpRulesResponse struct {
	*AuthorizeIpRulesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AuthorizeIpRules request.
func (r *AuthorizeIpRulesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
