// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workmail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListResourceDelegatesInput struct {
	_ struct{} `type:"structure"`

	// The number of maximum results in a page.
	MaxResults *int64 `min:"1" type:"integer"`

	// The token used to paginate through the delegates associated with a resource.
	NextToken *string `min:"1" type:"string"`

	// The identifier for the organization that contains the resource for which
	// delegates are listed.
	//
	// OrganizationId is a required field
	OrganizationId *string `type:"string" required:"true"`

	// The identifier for the resource whose delegates are listed.
	//
	// ResourceId is a required field
	ResourceId *string `min:"12" type:"string" required:"true"`
}

// String returns the string representation
func (s ListResourceDelegatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceDelegatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListResourceDelegatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.OrganizationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrganizationId"))
	}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 12 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListResourceDelegatesOutput struct {
	_ struct{} `type:"structure"`

	// One page of the resource's delegates.
	Delegates []Delegate `type:"list"`

	// The token used to paginate through the delegates associated with a resource.
	// While results are still available, it has an associated value. When the last
	// page is reached, the token is empty.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListResourceDelegatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListResourceDelegates = "ListResourceDelegates"

// ListResourceDelegatesRequest returns a request value for making API operation for
// Amazon WorkMail.
//
// Lists the delegates associated with a resource. Users and groups can be resource
// delegates and answer requests on behalf of the resource.
//
//    // Example sending a request using ListResourceDelegatesRequest.
//    req := client.ListResourceDelegatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates
func (c *Client) ListResourceDelegatesRequest(input *ListResourceDelegatesInput) ListResourceDelegatesRequest {
	op := &aws.Operation{
		Name:       opListResourceDelegates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListResourceDelegatesInput{}
	}

	req := c.newRequest(op, input, &ListResourceDelegatesOutput{})
	return ListResourceDelegatesRequest{Request: req, Input: input, Copy: c.ListResourceDelegatesRequest}
}

// ListResourceDelegatesRequest is the request type for the
// ListResourceDelegates API operation.
type ListResourceDelegatesRequest struct {
	*aws.Request
	Input *ListResourceDelegatesInput
	Copy  func(*ListResourceDelegatesInput) ListResourceDelegatesRequest
}

// Send marshals and sends the ListResourceDelegates API request.
func (r ListResourceDelegatesRequest) Send(ctx context.Context) (*ListResourceDelegatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListResourceDelegatesResponse{
		ListResourceDelegatesOutput: r.Request.Data.(*ListResourceDelegatesOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListResourceDelegatesRequestPaginator returns a paginator for ListResourceDelegates.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListResourceDelegatesRequest(input)
//   p := workmail.NewListResourceDelegatesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListResourceDelegatesPaginator(req ListResourceDelegatesRequest) ListResourceDelegatesPaginator {
	return ListResourceDelegatesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListResourceDelegatesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListResourceDelegatesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListResourceDelegatesPaginator struct {
	aws.Pager
}

func (p *ListResourceDelegatesPaginator) CurrentPage() *ListResourceDelegatesOutput {
	return p.Pager.CurrentPage().(*ListResourceDelegatesOutput)
}

// ListResourceDelegatesResponse is the response type for the
// ListResourceDelegates API operation.
type ListResourceDelegatesResponse struct {
	*ListResourceDelegatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListResourceDelegates request.
func (r *ListResourceDelegatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
