// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sfn

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type SendTaskHeartbeatInput struct {
	_ struct{} `type:"structure"`

	// The token that represents this task. Task tokens are generated by Step Functions
	// when tasks are assigned to a worker, or in the context object (https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html)
	// when a workflow enters a task state. See GetActivityTaskOutput$taskToken.
	//
	// TaskToken is a required field
	TaskToken *string `locationName:"taskToken" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SendTaskHeartbeatInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendTaskHeartbeatInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SendTaskHeartbeatInput"}

	if s.TaskToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("TaskToken"))
	}
	if s.TaskToken != nil && len(*s.TaskToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TaskToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SendTaskHeartbeatOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SendTaskHeartbeatOutput) String() string {
	return awsutil.Prettify(s)
}

const opSendTaskHeartbeat = "SendTaskHeartbeat"

// SendTaskHeartbeatRequest returns a request value for making API operation for
// AWS Step Functions.
//
// Used by activity workers and task states using the callback (https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token)
// pattern to report to Step Functions that the task represented by the specified
// taskToken is still making progress. This action resets the Heartbeat clock.
// The Heartbeat threshold is specified in the state machine's Amazon States
// Language definition (HeartbeatSeconds). This action does not in itself create
// an event in the execution history. However, if the task times out, the execution
// history contains an ActivityTimedOut entry for activities, or a TaskTimedOut
// entry for for tasks using the job run (https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-sync)
// or callback (https://docs.aws.amazon.com/step-functions/latest/dg/connect-to-resource.html#connect-wait-token)
// pattern.
//
// The Timeout of a task, defined in the state machine's Amazon States Language
// definition, is its maximum allowed duration, regardless of the number of
// SendTaskHeartbeat requests received. Use HeartbeatSeconds to configure the
// timeout interval for heartbeats.
//
//    // Example sending a request using SendTaskHeartbeatRequest.
//    req := client.SendTaskHeartbeatRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/SendTaskHeartbeat
func (c *Client) SendTaskHeartbeatRequest(input *SendTaskHeartbeatInput) SendTaskHeartbeatRequest {
	op := &aws.Operation{
		Name:       opSendTaskHeartbeat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendTaskHeartbeatInput{}
	}

	req := c.newRequest(op, input, &SendTaskHeartbeatOutput{})
	return SendTaskHeartbeatRequest{Request: req, Input: input, Copy: c.SendTaskHeartbeatRequest}
}

// SendTaskHeartbeatRequest is the request type for the
// SendTaskHeartbeat API operation.
type SendTaskHeartbeatRequest struct {
	*aws.Request
	Input *SendTaskHeartbeatInput
	Copy  func(*SendTaskHeartbeatInput) SendTaskHeartbeatRequest
}

// Send marshals and sends the SendTaskHeartbeat API request.
func (r SendTaskHeartbeatRequest) Send(ctx context.Context) (*SendTaskHeartbeatResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SendTaskHeartbeatResponse{
		SendTaskHeartbeatOutput: r.Request.Data.(*SendTaskHeartbeatOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SendTaskHeartbeatResponse is the response type for the
// SendTaskHeartbeat API operation.
type SendTaskHeartbeatResponse struct {
	*SendTaskHeartbeatOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SendTaskHeartbeat request.
func (r *SendTaskHeartbeatResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
