// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to return the details of a receipt rule. You use receipt
// rules to receive email with Amazon SES. For more information, see the Amazon
// SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
type DescribeReceiptRuleInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule.
	//
	// RuleName is a required field
	RuleName *string `type:"string" required:"true"`

	// The name of the receipt rule set that the receipt rule belongs to.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeReceiptRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReceiptRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeReceiptRuleInput"}

	if s.RuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleName"))
	}

	if s.RuleSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the details of a receipt rule.
type DescribeReceiptRuleOutput struct {
	_ struct{} `type:"structure"`

	// A data structure that contains the specified receipt rule's name, actions,
	// recipients, domains, enabled status, scan status, and Transport Layer Security
	// (TLS) policy.
	Rule *ReceiptRule `type:"structure"`
}

// String returns the string representation
func (s DescribeReceiptRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeReceiptRule = "DescribeReceiptRule"

// DescribeReceiptRuleRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Returns the details of the specified receipt rule.
//
// For information about setting up receipt rules, see the Amazon SES Developer
// Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-receipt-rules.html).
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using DescribeReceiptRuleRequest.
//    req := client.DescribeReceiptRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRule
func (c *Client) DescribeReceiptRuleRequest(input *DescribeReceiptRuleInput) DescribeReceiptRuleRequest {
	op := &aws.Operation{
		Name:       opDescribeReceiptRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReceiptRuleInput{}
	}

	req := c.newRequest(op, input, &DescribeReceiptRuleOutput{})
	return DescribeReceiptRuleRequest{Request: req, Input: input, Copy: c.DescribeReceiptRuleRequest}
}

// DescribeReceiptRuleRequest is the request type for the
// DescribeReceiptRule API operation.
type DescribeReceiptRuleRequest struct {
	*aws.Request
	Input *DescribeReceiptRuleInput
	Copy  func(*DescribeReceiptRuleInput) DescribeReceiptRuleRequest
}

// Send marshals and sends the DescribeReceiptRule API request.
func (r DescribeReceiptRuleRequest) Send(ctx context.Context) (*DescribeReceiptRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeReceiptRuleResponse{
		DescribeReceiptRuleOutput: r.Request.Data.(*DescribeReceiptRuleOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeReceiptRuleResponse is the response type for the
// DescribeReceiptRule API operation.
type DescribeReceiptRuleResponse struct {
	*DescribeReceiptRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeReceiptRule request.
func (r *DescribeReceiptRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
