// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeletePortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The portfolio identifier.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePortfolioInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePortfolioInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeletePortfolioOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeletePortfolio = "DeletePortfolio"

// DeletePortfolioRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Deletes the specified portfolio.
//
// You cannot delete a portfolio if it was shared with you or if it has associated
// products, users, constraints, or shared accounts.
//
//    // Example sending a request using DeletePortfolioRequest.
//    req := client.DeletePortfolioRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DeletePortfolio
func (c *Client) DeletePortfolioRequest(input *DeletePortfolioInput) DeletePortfolioRequest {
	op := &aws.Operation{
		Name:       opDeletePortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePortfolioInput{}
	}

	req := c.newRequest(op, input, &DeletePortfolioOutput{})
	return DeletePortfolioRequest{Request: req, Input: input, Copy: c.DeletePortfolioRequest}
}

// DeletePortfolioRequest is the request type for the
// DeletePortfolio API operation.
type DeletePortfolioRequest struct {
	*aws.Request
	Input *DeletePortfolioInput
	Copy  func(*DeletePortfolioInput) DeletePortfolioRequest
}

// Send marshals and sends the DeletePortfolio API request.
func (r DeletePortfolioRequest) Send(ctx context.Context) (*DeletePortfolioResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePortfolioResponse{
		DeletePortfolioOutput: r.Request.Data.(*DeletePortfolioOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePortfolioResponse is the response type for the
// DeletePortfolio API operation.
type DeletePortfolioResponse struct {
	*DeletePortfolioOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePortfolio request.
func (r *DeletePortfolioResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
