// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package schemas

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListRegistriesInput struct {
	_ struct{} `type:"structure"`

	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	RegistryNamePrefix *string `location:"querystring" locationName:"registryNamePrefix" type:"string"`

	Scope *string `location:"querystring" locationName:"scope" type:"string"`
}

// String returns the string representation
func (s ListRegistriesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRegistriesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RegistryNamePrefix != nil {
		v := *s.RegistryNamePrefix

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "registryNamePrefix", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Scope != nil {
		v := *s.Scope

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "scope", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ListRegistriesOutput struct {
	_ struct{} `type:"structure"`

	NextToken *string `type:"string"`

	Registries []RegistrySummary `type:"list"`
}

// String returns the string representation
func (s ListRegistriesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRegistriesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Registries != nil {
		v := s.Registries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Registries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListRegistries = "ListRegistries"

// ListRegistriesRequest returns a request value for making API operation for
// Schemas.
//
// List the registries.
//
//    // Example sending a request using ListRegistriesRequest.
//    req := client.ListRegistriesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/schemas-2019-12-02/ListRegistries
func (c *Client) ListRegistriesRequest(input *ListRegistriesInput) ListRegistriesRequest {
	op := &aws.Operation{
		Name:       opListRegistries,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/registries",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRegistriesInput{}
	}

	req := c.newRequest(op, input, &ListRegistriesOutput{})
	return ListRegistriesRequest{Request: req, Input: input, Copy: c.ListRegistriesRequest}
}

// ListRegistriesRequest is the request type for the
// ListRegistries API operation.
type ListRegistriesRequest struct {
	*aws.Request
	Input *ListRegistriesInput
	Copy  func(*ListRegistriesInput) ListRegistriesRequest
}

// Send marshals and sends the ListRegistries API request.
func (r ListRegistriesRequest) Send(ctx context.Context) (*ListRegistriesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRegistriesResponse{
		ListRegistriesOutput: r.Request.Data.(*ListRegistriesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRegistriesRequestPaginator returns a paginator for ListRegistries.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRegistriesRequest(input)
//   p := schemas.NewListRegistriesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRegistriesPaginator(req ListRegistriesRequest) ListRegistriesPaginator {
	return ListRegistriesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRegistriesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRegistriesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRegistriesPaginator struct {
	aws.Pager
}

func (p *ListRegistriesPaginator) CurrentPage() *ListRegistriesOutput {
	return p.Pager.CurrentPage().(*ListRegistriesOutput)
}

// ListRegistriesResponse is the response type for the
// ListRegistries API operation.
type ListRegistriesResponse struct {
	*ListRegistriesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRegistries request.
func (r *ListRegistriesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
