// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemakera2iruntime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StartHumanLoopInput struct {
	_ struct{} `type:"structure"`

	// Attributes of the data specified by the customer.
	DataAttributes *HumanReviewDataAttributes `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow definition.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `type:"string" required:"true"`

	// An object containing information about the human loop.
	//
	// HumanLoopInput is a required field
	HumanLoopInput *HumanLoopInputContent `type:"structure" required:"true"`

	// The name of the human loop.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartHumanLoopInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartHumanLoopInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartHumanLoopInput"}

	if s.FlowDefinitionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FlowDefinitionArn"))
	}

	if s.HumanLoopInput == nil {
		invalidParams.Add(aws.NewErrParamRequired("HumanLoopInput"))
	}

	if s.HumanLoopName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HumanLoopName"))
	}
	if s.HumanLoopName != nil && len(*s.HumanLoopName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HumanLoopName", 1))
	}
	if s.DataAttributes != nil {
		if err := s.DataAttributes.Validate(); err != nil {
			invalidParams.AddNested("DataAttributes", err.(aws.ErrInvalidParams))
		}
	}
	if s.HumanLoopInput != nil {
		if err := s.HumanLoopInput.Validate(); err != nil {
			invalidParams.AddNested("HumanLoopInput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartHumanLoopInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.DataAttributes != nil {
		v := s.DataAttributes

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DataAttributes", v, metadata)
	}
	if s.FlowDefinitionArn != nil {
		v := *s.FlowDefinitionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FlowDefinitionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.HumanLoopInput != nil {
		v := s.HumanLoopInput

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "HumanLoopInput", v, metadata)
	}
	if s.HumanLoopName != nil {
		v := *s.HumanLoopName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HumanLoopName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StartHumanLoopOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the human loop activation.
	HumanLoopActivationResults *HumanLoopActivationResults `type:"structure"`

	// The Amazon Resource Name (ARN) of the human loop.
	HumanLoopArn *string `type:"string"`
}

// String returns the string representation
func (s StartHumanLoopOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartHumanLoopOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.HumanLoopActivationResults != nil {
		v := s.HumanLoopActivationResults

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "HumanLoopActivationResults", v, metadata)
	}
	if s.HumanLoopArn != nil {
		v := *s.HumanLoopArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HumanLoopArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opStartHumanLoop = "StartHumanLoop"

// StartHumanLoopRequest returns a request value for making API operation for
// Amazon Augmented AI Runtime.
//
// Starts a human loop, provided that at least one activation condition is met.
//
//    // Example sending a request using StartHumanLoopRequest.
//    req := client.StartHumanLoopRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-a2i-runtime-2019-11-07/StartHumanLoop
func (c *Client) StartHumanLoopRequest(input *StartHumanLoopInput) StartHumanLoopRequest {
	op := &aws.Operation{
		Name:       opStartHumanLoop,
		HTTPMethod: "POST",
		HTTPPath:   "/human-loops",
	}

	if input == nil {
		input = &StartHumanLoopInput{}
	}

	req := c.newRequest(op, input, &StartHumanLoopOutput{})
	return StartHumanLoopRequest{Request: req, Input: input, Copy: c.StartHumanLoopRequest}
}

// StartHumanLoopRequest is the request type for the
// StartHumanLoop API operation.
type StartHumanLoopRequest struct {
	*aws.Request
	Input *StartHumanLoopInput
	Copy  func(*StartHumanLoopInput) StartHumanLoopRequest
}

// Send marshals and sends the StartHumanLoop API request.
func (r StartHumanLoopRequest) Send(ctx context.Context) (*StartHumanLoopResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartHumanLoopResponse{
		StartHumanLoopOutput: r.Request.Data.(*StartHumanLoopOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartHumanLoopResponse is the response type for the
// StartHumanLoop API operation.
type StartHumanLoopResponse struct {
	*StartHumanLoopOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartHumanLoop request.
func (r *StartHumanLoopResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
