// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3control

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetAccessPointPolicyInput struct {
	_ struct{} `type:"structure"`

	// The account ID for the account that owns the specified access point.
	//
	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The name of the access point whose policy you want to retrieve.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAccessPointPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAccessPointPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAccessPointPolicyInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAccessPointPolicyInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-account-id", protocol.StringValue(v), metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.StringValue(v), metadata)
	}
	return nil
}

type GetAccessPointPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The access point policy associated with the specified access point.
	Policy *string `type:"string"`
}

// String returns the string representation
func (s GetAccessPointPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAccessPointPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Policy != nil {
		v := *s.Policy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Policy", protocol.StringValue(v), metadata)
	}
	return nil
}

const opGetAccessPointPolicy = "GetAccessPointPolicy"

// GetAccessPointPolicyRequest returns a request value for making API operation for
// AWS S3 Control.
//
// Returns the access point policy associated with the specified access point.
//
//    // Example sending a request using GetAccessPointPolicyRequest.
//    req := client.GetAccessPointPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/GetAccessPointPolicy
func (c *Client) GetAccessPointPolicyRequest(input *GetAccessPointPolicyInput) GetAccessPointPolicyRequest {
	op := &aws.Operation{
		Name:       opGetAccessPointPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/accesspoint/{name}/policy",
	}

	if input == nil {
		input = &GetAccessPointPolicyInput{}
	}

	req := c.newRequest(op, input, &GetAccessPointPolicyOutput{})
	req.Handlers.Build.PushBackNamed(buildPrefixHostHandler("AccountID", aws.StringValue(input.AccountId)))
	req.Handlers.Build.PushBackNamed(buildRemoveHeaderHandler("X-Amz-Account-Id"))
	return GetAccessPointPolicyRequest{Request: req, Input: input, Copy: c.GetAccessPointPolicyRequest}
}

// GetAccessPointPolicyRequest is the request type for the
// GetAccessPointPolicy API operation.
type GetAccessPointPolicyRequest struct {
	*aws.Request
	Input *GetAccessPointPolicyInput
	Copy  func(*GetAccessPointPolicyInput) GetAccessPointPolicyRequest
}

// Send marshals and sends the GetAccessPointPolicy API request.
func (r GetAccessPointPolicyRequest) Send(ctx context.Context) (*GetAccessPointPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAccessPointPolicyResponse{
		GetAccessPointPolicyOutput: r.Request.Data.(*GetAccessPointPolicyOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAccessPointPolicyResponse is the response type for the
// GetAccessPointPolicy API operation.
type GetAccessPointPolicyResponse struct {
	*GetAccessPointPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAccessPointPolicy request.
func (r *GetAccessPointPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
