// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type ModifyClusterSnapshotScheduleInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the cluster whose snapshot schedule you want to modify.
	//
	// ClusterIdentifier is a required field
	ClusterIdentifier *string `type:"string" required:"true"`

	// A boolean to indicate whether to remove the assoiciation between the cluster
	// and the schedule.
	DisassociateSchedule *bool `type:"boolean"`

	// A unique alphanumeric identifier for the schedule that you want to associate
	// with the cluster.
	ScheduleIdentifier *string `type:"string"`
}

// String returns the string representation
func (s ModifyClusterSnapshotScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClusterSnapshotScheduleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyClusterSnapshotScheduleInput"}

	if s.ClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ModifyClusterSnapshotScheduleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyClusterSnapshotScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyClusterSnapshotSchedule = "ModifyClusterSnapshotSchedule"

// ModifyClusterSnapshotScheduleRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Modifies a snapshot schedule for a cluster.
//
//    // Example sending a request using ModifyClusterSnapshotScheduleRequest.
//    req := client.ModifyClusterSnapshotScheduleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ModifyClusterSnapshotSchedule
func (c *Client) ModifyClusterSnapshotScheduleRequest(input *ModifyClusterSnapshotScheduleInput) ModifyClusterSnapshotScheduleRequest {
	op := &aws.Operation{
		Name:       opModifyClusterSnapshotSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClusterSnapshotScheduleInput{}
	}

	req := c.newRequest(op, input, &ModifyClusterSnapshotScheduleOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return ModifyClusterSnapshotScheduleRequest{Request: req, Input: input, Copy: c.ModifyClusterSnapshotScheduleRequest}
}

// ModifyClusterSnapshotScheduleRequest is the request type for the
// ModifyClusterSnapshotSchedule API operation.
type ModifyClusterSnapshotScheduleRequest struct {
	*aws.Request
	Input *ModifyClusterSnapshotScheduleInput
	Copy  func(*ModifyClusterSnapshotScheduleInput) ModifyClusterSnapshotScheduleRequest
}

// Send marshals and sends the ModifyClusterSnapshotSchedule API request.
func (r ModifyClusterSnapshotScheduleRequest) Send(ctx context.Context) (*ModifyClusterSnapshotScheduleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyClusterSnapshotScheduleResponse{
		ModifyClusterSnapshotScheduleOutput: r.Request.Data.(*ModifyClusterSnapshotScheduleOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyClusterSnapshotScheduleResponse is the response type for the
// ModifyClusterSnapshotSchedule API operation.
type ModifyClusterSnapshotScheduleResponse struct {
	*ModifyClusterSnapshotScheduleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyClusterSnapshotSchedule request.
func (r *ModifyClusterSnapshotScheduleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
