// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateHsmConfigurationInput struct {
	_ struct{} `type:"structure"`

	// A text description of the HSM configuration to be created.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The identifier to be assigned to the new Amazon Redshift HSM configuration.
	//
	// HsmConfigurationIdentifier is a required field
	HsmConfigurationIdentifier *string `type:"string" required:"true"`

	// The IP address that the Amazon Redshift cluster must use to access the HSM.
	//
	// HsmIpAddress is a required field
	HsmIpAddress *string `type:"string" required:"true"`

	// The name of the partition in the HSM where the Amazon Redshift clusters will
	// store their database encryption keys.
	//
	// HsmPartitionName is a required field
	HsmPartitionName *string `type:"string" required:"true"`

	// The password required to access the HSM partition.
	//
	// HsmPartitionPassword is a required field
	HsmPartitionPassword *string `type:"string" required:"true"`

	// The HSMs public certificate file. When using Cloud HSM, the file name is
	// server.pem.
	//
	// HsmServerPublicCertificate is a required field
	HsmServerPublicCertificate *string `type:"string" required:"true"`

	// A list of tag instances.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateHsmConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHsmConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateHsmConfigurationInput"}

	if s.Description == nil {
		invalidParams.Add(aws.NewErrParamRequired("Description"))
	}

	if s.HsmConfigurationIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("HsmConfigurationIdentifier"))
	}

	if s.HsmIpAddress == nil {
		invalidParams.Add(aws.NewErrParamRequired("HsmIpAddress"))
	}

	if s.HsmPartitionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HsmPartitionName"))
	}

	if s.HsmPartitionPassword == nil {
		invalidParams.Add(aws.NewErrParamRequired("HsmPartitionPassword"))
	}

	if s.HsmServerPublicCertificate == nil {
		invalidParams.Add(aws.NewErrParamRequired("HsmServerPublicCertificate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateHsmConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Returns information about an HSM configuration, which is an object that describes
	// to Amazon Redshift clusters the information they require to connect to an
	// HSM where they can store database encryption keys.
	HsmConfiguration *HsmConfiguration `type:"structure"`
}

// String returns the string representation
func (s CreateHsmConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateHsmConfiguration = "CreateHsmConfiguration"

// CreateHsmConfigurationRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Creates an HSM configuration that contains the information required by an
// Amazon Redshift cluster to store and use database encryption keys in a Hardware
// Security Module (HSM). After creating the HSM configuration, you can specify
// it as a parameter when creating a cluster. The cluster will then store its
// encryption keys in the HSM.
//
// In addition to creating an HSM configuration, you must also create an HSM
// client certificate. For more information, go to Hardware Security Modules
// (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-HSM.html)
// in the Amazon Redshift Cluster Management Guide.
//
//    // Example sending a request using CreateHsmConfigurationRequest.
//    req := client.CreateHsmConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/CreateHsmConfiguration
func (c *Client) CreateHsmConfigurationRequest(input *CreateHsmConfigurationInput) CreateHsmConfigurationRequest {
	op := &aws.Operation{
		Name:       opCreateHsmConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHsmConfigurationInput{}
	}

	req := c.newRequest(op, input, &CreateHsmConfigurationOutput{})
	return CreateHsmConfigurationRequest{Request: req, Input: input, Copy: c.CreateHsmConfigurationRequest}
}

// CreateHsmConfigurationRequest is the request type for the
// CreateHsmConfiguration API operation.
type CreateHsmConfigurationRequest struct {
	*aws.Request
	Input *CreateHsmConfigurationInput
	Copy  func(*CreateHsmConfigurationInput) CreateHsmConfigurationRequest
}

// Send marshals and sends the CreateHsmConfiguration API request.
func (r CreateHsmConfigurationRequest) Send(ctx context.Context) (*CreateHsmConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateHsmConfigurationResponse{
		CreateHsmConfigurationOutput: r.Request.Data.(*CreateHsmConfigurationOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateHsmConfigurationResponse is the response type for the
// CreateHsmConfiguration API operation.
type CreateHsmConfigurationResponse struct {
	*CreateHsmConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateHsmConfiguration request.
func (r *CreateHsmConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
