// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes a quota for an AWS account.
//
// The following are account quotas:
//
//    * AllocatedStorage - The total allocated storage per account, in GiB.
//    The used value is the total allocated storage in the account, in GiB.
//
//    * AuthorizationsPerDBSecurityGroup - The number of ingress rules per DB
//    security group. The used value is the highest number of ingress rules
//    in a DB security group in the account. Other DB security groups in the
//    account might have a lower number of ingress rules.
//
//    * CustomEndpointsPerDBCluster - The number of custom endpoints per DB
//    cluster. The used value is the highest number of custom endpoints in a
//    DB clusters in the account. Other DB clusters in the account might have
//    a lower number of custom endpoints.
//
//    * DBClusterParameterGroups - The number of DB cluster parameter groups
//    per account, excluding default parameter groups. The used value is the
//    count of nondefault DB cluster parameter groups in the account.
//
//    * DBClusterRoles - The number of associated AWS Identity and Access Management
//    (IAM) roles per DB cluster. The used value is the highest number of associated
//    IAM roles for a DB cluster in the account. Other DB clusters in the account
//    might have a lower number of associated IAM roles.
//
//    * DBClusters - The number of DB clusters per account. The used value is
//    the count of DB clusters in the account.
//
//    * DBInstanceRoles - The number of associated IAM roles per DB instance.
//    The used value is the highest number of associated IAM roles for a DB
//    instance in the account. Other DB instances in the account might have
//    a lower number of associated IAM roles.
//
//    * DBInstances - The number of DB instances per account. The used value
//    is the count of the DB instances in the account.
//
//    * DBParameterGroups - The number of DB parameter groups per account, excluding
//    default parameter groups. The used value is the count of nondefault DB
//    parameter groups in the account.
//
//    * DBSecurityGroups - The number of DB security groups (not VPC security
//    groups) per account, excluding the default security group. The used value
//    is the count of nondefault DB security groups in the account.
//
//    * DBSubnetGroups - The number of DB subnet groups per account. The used
//    value is the count of the DB subnet groups in the account.
//
//    * EventSubscriptions - The number of event subscriptions per account.
//    The used value is the count of the event subscriptions in the account.
//
//    * ManualSnapshots - The number of manual DB snapshots per account. The
//    used value is the count of the manual DB snapshots in the account.
//
//    * OptionGroups - The number of DB option groups per account, excluding
//    default option groups. The used value is the count of nondefault DB option
//    groups in the account.
//
//    * ReadReplicasPerMaster - The number of Read Replicas per DB instance.
//    The used value is the highest number of Read Replicas for a DB instance
//    in the account. Other DB instances in the account might have a lower number
//    of Read Replicas.
//
//    * ReservedDBInstances - The number of reserved DB instances per account.
//    The used value is the count of the active reserved DB instances in the
//    account.
//
//    * SubnetsPerDBSubnetGroup - The number of subnets per DB subnet group.
//    The used value is highest number of subnets for a DB subnet group in the
//    account. Other DB subnet groups in the account might have a lower number
//    of subnets.
//
// For more information, see Limits (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Limits.html)
// in the Amazon RDS User Guide and Limits (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/CHAP_Limits.html)
// in the Amazon Aurora User Guide.
type AccountQuota struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon RDS quota for this AWS account.
	AccountQuotaName *string `type:"string"`

	// The maximum allowed value for the quota.
	Max *int64 `type:"long"`

	// The amount currently used toward the quota maximum.
	Used *int64 `type:"long"`
}

// String returns the string representation
func (s AccountQuota) String() string {
	return awsutil.Prettify(s)
}

// Contains Availability Zone information.
//
// This data type is used as an element in the OrderableDBInstanceOption data
// type.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// Contains the available processor feature information for the DB instance
// class of a DB instance.
//
// For more information, see Configuring the Processor of the DB Instance Class
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor)
// in the Amazon RDS User Guide.
type AvailableProcessorFeature struct {
	_ struct{} `type:"structure"`

	// The allowed values for the processor feature of the DB instance class.
	AllowedValues *string `type:"string"`

	// The default value for the processor feature of the DB instance class.
	DefaultValue *string `type:"string"`

	// The name of the processor feature. Valid names are coreCount and threadsPerCore.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailableProcessorFeature) String() string {
	return awsutil.Prettify(s)
}

// A CA certificate for an AWS account.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// The unique key that identifies a certificate.
	CertificateIdentifier *string `type:"string"`

	// The type of the certificate.
	CertificateType *string `type:"string"`

	// The thumbprint of the certificate.
	Thumbprint *string `type:"string"`

	// The starting date from which the certificate is valid.
	ValidFrom *time.Time `type:"timestamp"`

	// The final date that the certificate continues to be valid.
	ValidTill *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the action DescribeDBEngineVersions.
type CharacterSet struct {
	_ struct{} `type:"structure"`

	// The description of the character set.
	CharacterSetDescription *string `type:"string"`

	// The name of the character set.
	CharacterSetName *string `type:"string"`
}

// String returns the string representation
func (s CharacterSet) String() string {
	return awsutil.Prettify(s)
}

// The configuration setting for the log types to be enabled for export to CloudWatch
// Logs for a specific DB instance or DB cluster.
//
// The EnableLogTypes and DisableLogTypes arrays determine which logs will be
// exported (or not exported) to CloudWatch Logs. The values within these arrays
// depend on the DB engine being used. For more information, see Publishing
// Database Logs to Amazon CloudWatch Logs (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch)
// in the Amazon RDS User Guide.
type CloudwatchLogsExportConfiguration struct {
	_ struct{} `type:"structure"`

	// The list of log types to disable.
	DisableLogTypes []string `type:"list"`

	// The list of log types to enable.
	EnableLogTypes []string `type:"list"`
}

// String returns the string representation
func (s CloudwatchLogsExportConfiguration) String() string {
	return awsutil.Prettify(s)
}

//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Specifies the settings that control the size and behavior of the connection
// pool associated with a DBProxyTargetGroup.
type ConnectionPoolConfiguration struct {
	_ struct{} `type:"structure"`

	// The number of seconds for a proxy to wait for a connection to become available
	// in the connection pool. Only applies when the proxy has opened its maximum
	// number of connections and all connections are busy with client sessions.
	//
	// Default: 120
	//
	// Constraints: between 1 and 3600, or 0 representing unlimited
	ConnectionBorrowTimeout *int64 `type:"integer"`

	// One or more SQL statements for the proxy to run when opening each new database
	// connection. Typically used with SET statements to make sure that each connection
	// has identical settings such as time zone and character set. For multiple
	// statements, use semicolons as the separator. You can also include multiple
	// variables in a single SET statement, such as SET x=1, y=2.
	//
	// Default: no initialization query
	InitQuery *string `type:"string"`

	// The maximum size of the connection pool for each target in a target group.
	// For Aurora MySQL, it is expressed as a percentage of the max_connections
	// setting for the RDS DB instance or Aurora DB cluster used by the target group.
	//
	// Default: 100
	//
	// Constraints: between 1 and 100
	MaxConnectionsPercent *int64 `type:"integer"`

	// Controls how actively the proxy closes idle database connections in the connection
	// pool. A high value enables the proxy to leave a high percentage of idle connections
	// open. A low value causes the proxy to close idle client connections and return
	// the underlying database connections to the connection pool. For Aurora MySQL,
	// it is expressed as a percentage of the max_connections setting for the RDS
	// DB instance or Aurora DB cluster used by the target group.
	//
	// Default: 50
	//
	// Constraints: between 0 and MaxConnectionsPercent
	MaxIdleConnectionsPercent *int64 `type:"integer"`

	// Each item in the list represents a class of SQL operations that normally
	// cause all later statements in a session using a proxy to be pinned to the
	// same underlying database connection. Including an item in the list exempts
	// that class of SQL operations from the pinning behavior.
	//
	// Default: no session pinning filters
	SessionPinningFilters []string `type:"list"`
}

// String returns the string representation
func (s ConnectionPoolConfiguration) String() string {
	return awsutil.Prettify(s)
}

//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Displays the settings that control the size and behavior of the connection
// pool associated with a DBProxyTarget.
type ConnectionPoolConfigurationInfo struct {
	_ struct{} `type:"structure"`

	// The number of seconds for a proxy to wait for a connection to become available
	// in the connection pool. Only applies when the proxy has opened its maximum
	// number of connections and all connections are busy with client sessions.
	ConnectionBorrowTimeout *int64 `type:"integer"`

	// One or more SQL statements for the proxy to run when opening each new database
	// connection. Typically used with SET statements to make sure that each connection
	// has identical settings such as time zone and character set. This setting
	// is empty by default. For multiple statements, use semicolons as the separator.
	// You can also include multiple variables in a single SET statement, such as
	// SET x=1, y=2.
	InitQuery *string `type:"string"`

	// The maximum size of the connection pool for each target in a target group.
	// For Aurora MySQL, it is expressed as a percentage of the max_connections
	// setting for the RDS DB instance or Aurora DB cluster used by the target group.
	MaxConnectionsPercent *int64 `type:"integer"`

	// Controls how actively the proxy closes idle database connections in the connection
	// pool. A high value enables the proxy to leave a high percentage of idle connections
	// open. A low value causes the proxy to close idle client connections and return
	// the underlying database connections to the connection pool. For Aurora MySQL,
	// it is expressed as a percentage of the max_connections setting for the RDS
	// DB instance or Aurora DB cluster used by the target group.
	MaxIdleConnectionsPercent *int64 `type:"integer"`

	// Each item in the list represents a class of SQL operations that normally
	// cause all later statements in a session using a proxy to be pinned to the
	// same underlying database connection. Including an item in the list exempts
	// that class of SQL operations from the pinning behavior. Currently, the only
	// allowed value is EXCLUDE_VARIABLE_SETS.
	SessionPinningFilters []string `type:"list"`
}

// String returns the string representation
func (s ConnectionPoolConfigurationInfo) String() string {
	return awsutil.Prettify(s)
}

// A custom Availability Zone (AZ) is an on-premises AZ that is integrated with
// a VMware vSphere cluster.
//
// For more information about RDS on VMware, see the RDS on VMware User Guide.
// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
type CustomAvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The identifier of the custom AZ.
	//
	// Amazon RDS generates a unique identifier when a custom AZ is created.
	CustomAvailabilityZoneId *string `type:"string"`

	// The name of the custom AZ.
	CustomAvailabilityZoneName *string `type:"string"`

	// The status of the custom AZ.
	CustomAvailabilityZoneStatus *string `type:"string"`

	// Information about the virtual private network (VPN) between the VMware vSphere
	// cluster and the AWS website.
	VpnDetails *VpnDetails `type:"structure"`
}

// String returns the string representation
func (s CustomAvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of an Amazon Aurora DB cluster.
//
// This data type is used as a response element in the DescribeDBClusters, StopDBCluster,
// and StartDBCluster actions.
type DBCluster struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon Kinesis data stream used for the database activity
	// stream.
	ActivityStreamKinesisStreamName *string `type:"string"`

	// The AWS KMS key identifier used for encrypting messages in the database activity
	// stream.
	ActivityStreamKmsKeyId *string `type:"string"`

	// The mode of the database activity stream. Database events such as a change
	// or access generate an activity stream event. The database session can handle
	// these events either synchronously or asynchronously.
	ActivityStreamMode ActivityStreamMode `type:"string" enum:"true"`

	// The status of the database activity stream.
	ActivityStreamStatus ActivityStreamStatus `type:"string" enum:"true"`

	// For all database engines except Amazon Aurora, AllocatedStorage specifies
	// the allocated storage size in gibibytes (GiB). For Aurora, AllocatedStorage
	// always returns 1, because Aurora DB cluster storage size isn't fixed, but
	// instead automatically adjusts as needed.
	AllocatedStorage *int64 `type:"integer"`

	// Provides a list of the AWS Identity and Access Management (IAM) roles that
	// are associated with the DB cluster. IAM roles that are associated with a
	// DB cluster grant permission for the DB cluster to access other AWS services
	// on your behalf.
	AssociatedRoles []DBClusterRole `locationNameList:"DBClusterRole" type:"list"`

	// Provides the list of Availability Zones (AZs) where instances in the DB cluster
	// can be created.
	AvailabilityZones []string `locationNameList:"AvailabilityZone" type:"list"`

	// The number of change records stored for Backtrack.
	BacktrackConsumedChangeRecords *int64 `type:"long"`

	// The target backtrack window, in seconds. If this value is set to 0, backtracking
	// is disabled for the DB cluster. Otherwise, backtracking is enabled.
	BacktrackWindow *int64 `type:"long"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The current capacity of an Aurora Serverless DB cluster. The capacity is
	// 0 (zero) when the cluster is paused.
	//
	// For more information about Aurora Serverless, see Using Amazon Aurora Serverless
	// (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
	// in the Amazon Aurora User Guide.
	Capacity *int64 `type:"integer"`

	// If present, specifies the name of the character set that this cluster is
	// associated with.
	CharacterSetName *string `type:"string"`

	// Identifies the clone group to which the DB cluster is associated.
	CloneGroupId *string `type:"string"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp"`

	// Specifies whether tags are copied from the DB cluster to snapshots of the
	// DB cluster.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// Specifies whether the DB cluster is a clone of a DB cluster owned by a different
	// AWS account.
	CrossAccountClone *bool `type:"boolean"`

	// Identifies all custom endpoints associated with the cluster.
	CustomEndpoints []string `type:"list"`

	// The Amazon Resource Name (ARN) for the DB cluster.
	DBClusterArn *string `type:"string"`

	// Contains a user-supplied DB cluster identifier. This identifier is the unique
	// key that identifies a DB cluster.
	DBClusterIdentifier *string `type:"string"`

	// Provides the list of instances that make up the DB cluster.
	DBClusterMembers []DBClusterMember `locationNameList:"DBClusterMember" type:"list"`

	// Provides the list of option group memberships for this DB cluster.
	DBClusterOptionGroupMemberships []DBClusterOptionGroupStatus `locationNameList:"DBClusterOptionGroup" type:"list"`

	// Specifies the name of the DB cluster parameter group for the DB cluster.
	DBClusterParameterGroup *string `type:"string"`

	// Specifies information on the subnet group associated with the DB cluster,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *string `type:"string"`

	// Contains the name of the initial database of this DB cluster that was provided
	// at create time, if one was specified when the DB cluster was created. This
	// same name is returned for the life of the DB cluster.
	DatabaseName *string `type:"string"`

	// The AWS Region-unique, immutable identifier for the DB cluster. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// cluster is accessed.
	DbClusterResourceId *string `type:"string"`

	// Indicates if the DB cluster has deletion protection enabled. The database
	// can't be deleted when deletion protection is enabled.
	DeletionProtection *bool `type:"boolean"`

	// The earliest time to which a DB cluster can be backtracked.
	EarliestBacktrackTime *time.Time `type:"timestamp"`

	// The earliest time to which a database can be restored with point-in-time
	// restore.
	EarliestRestorableTime *time.Time `type:"timestamp"`

	// A list of log types that this DB cluster is configured to export to CloudWatch
	// Logs.
	//
	// Log types vary by DB engine. For information about the log types for each
	// DB engine, see Amazon RDS Database Log Files (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_LogAccess.html)
	// in the Amazon Aurora User Guide.
	EnabledCloudwatchLogsExports []string `type:"list"`

	// Specifies the connection endpoint for the primary instance of the DB cluster.
	Endpoint *string `type:"string"`

	// Provides the name of the database engine to be used for this DB cluster.
	Engine *string `type:"string"`

	// The DB engine mode of the DB cluster, either provisioned, serverless, parallelquery,
	// global, or multimaster.
	EngineMode *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// A value that indicates whether the HTTP endpoint for an Aurora Serverless
	// DB cluster is enabled.
	//
	// When enabled, the HTTP endpoint provides a connectionless web service API
	// for running SQL queries on the Aurora Serverless DB cluster. You can also
	// query your database from inside the RDS console with the query editor.
	//
	// For more information, see Using the Data API for Aurora Serverless (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html)
	// in the Amazon Aurora User Guide.
	HttpEndpointEnabled *bool `type:"boolean"`

	// A value that indicates whether the mapping of AWS Identity and Access Management
	// (IAM) accounts to database accounts is enabled.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// If StorageEncrypted is enabled, the AWS KMS key identifier for the encrypted
	// DB cluster.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp"`

	// Contains the master username for the DB cluster.
	MasterUsername *string `type:"string"`

	// Specifies whether the DB cluster has instances in multiple Availability Zones.
	MultiAZ *bool `type:"boolean"`

	// Specifies the progress of the operation as a percentage.
	PercentProgress *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// Contains one or more identifiers of the Read Replicas associated with this
	// DB cluster.
	ReadReplicaIdentifiers []string `locationNameList:"ReadReplicaIdentifier" type:"list"`

	// The reader endpoint for the DB cluster. The reader endpoint for a DB cluster
	// load-balances connections across the Aurora Replicas that are available in
	// a DB cluster. As clients request new connections to the reader endpoint,
	// Aurora distributes the connection requests among the Aurora Replicas in the
	// DB cluster. This functionality can help balance your read workload across
	// multiple Aurora Replicas in your DB cluster.
	//
	// If a failover occurs, and the Aurora Replica that you are connected to is
	// promoted to be the primary instance, your connection is dropped. To continue
	// sending your read workload to other Aurora Replicas in the cluster, you can
	// then reconnect to the reader endpoint.
	ReaderEndpoint *string `type:"string"`

	// Contains the identifier of the source DB cluster if this DB cluster is a
	// Read Replica.
	ReplicationSourceIdentifier *string `type:"string"`

	// Shows the scaling configuration for an Aurora DB cluster in serverless DB
	// engine mode.
	//
	// For more information, see Using Amazon Aurora Serverless (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
	// in the Amazon Aurora User Guide.
	ScalingConfigurationInfo *ScalingConfigurationInfo `type:"structure"`

	// Specifies the current state of this DB cluster.
	Status *string `type:"string"`

	// Specifies whether the DB cluster is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides a list of VPC security groups that the DB cluster belongs to.
	VpcSecurityGroups []VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBCluster) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the DescribeDBClusterBacktracks
// action.
type DBClusterBacktrack struct {
	_ struct{} `type:"structure"`

	// Contains the backtrack identifier.
	BacktrackIdentifier *string `type:"string"`

	// The timestamp of the time at which the backtrack was requested.
	BacktrackRequestCreationTime *time.Time `type:"timestamp"`

	// The timestamp of the time to which the DB cluster was backtracked.
	BacktrackTo *time.Time `type:"timestamp"`

	// The timestamp of the time from which the DB cluster was backtracked.
	BacktrackedFrom *time.Time `type:"timestamp"`

	// Contains a user-supplied DB cluster identifier. This identifier is the unique
	// key that identifies a DB cluster.
	DBClusterIdentifier *string `type:"string"`

	// The status of the backtrack. This property returns one of the following values:
	//
	//    * applying - The backtrack is currently being applied to or rolled back
	//    from the DB cluster.
	//
	//    * completed - The backtrack has successfully been applied to or rolled
	//    back from the DB cluster.
	//
	//    * failed - An error occurred while the backtrack was applied to or rolled
	//    back from the DB cluster.
	//
	//    * pending - The backtrack is currently pending application to or rollback
	//    from the DB cluster.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterBacktrack) String() string {
	return awsutil.Prettify(s)
}

// This data type represents the information you need to connect to an Amazon
// Aurora DB cluster. This data type is used as a response element in the following
// actions:
//
//    * CreateDBClusterEndpoint
//
//    * DescribeDBClusterEndpoints
//
//    * ModifyDBClusterEndpoint
//
//    * DeleteDBClusterEndpoint
//
// For the data structure that represents Amazon RDS DB instance endpoints,
// see Endpoint.
type DBClusterEndpoint struct {
	_ struct{} `type:"structure"`

	// The type associated with a custom endpoint. One of: READER, WRITER, ANY.
	CustomEndpointType *string `type:"string"`

	// The Amazon Resource Name (ARN) for the endpoint.
	DBClusterEndpointArn *string `type:"string"`

	// The identifier associated with the endpoint. This parameter is stored as
	// a lowercase string.
	DBClusterEndpointIdentifier *string `type:"string"`

	// A unique system-generated identifier for an endpoint. It remains the same
	// for the whole life of the endpoint.
	DBClusterEndpointResourceIdentifier *string `type:"string"`

	// The DB cluster identifier of the DB cluster associated with the endpoint.
	// This parameter is stored as a lowercase string.
	DBClusterIdentifier *string `type:"string"`

	// The DNS address of the endpoint.
	Endpoint *string `type:"string"`

	// The type of the endpoint. One of: READER, WRITER, CUSTOM.
	EndpointType *string `type:"string"`

	// List of DB instance identifiers that aren't part of the custom endpoint group.
	// All other eligible instances are reachable through the custom endpoint. Only
	// relevant if the list of static members is empty.
	ExcludedMembers []string `type:"list"`

	// List of DB instance identifiers that are part of the custom endpoint group.
	StaticMembers []string `type:"list"`

	// The current status of the endpoint. One of: creating, available, deleting,
	// modifying.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterEndpoint) String() string {
	return awsutil.Prettify(s)
}

// Contains information about an instance that is part of a DB cluster.
type DBClusterMember struct {
	_ struct{} `type:"structure"`

	// Specifies the status of the DB cluster parameter group for this member of
	// the DB cluster.
	DBClusterParameterGroupStatus *string `type:"string"`

	// Specifies the instance identifier for this member of the DB cluster.
	DBInstanceIdentifier *string `type:"string"`

	// Value that is true if the cluster member is the primary instance for the
	// DB cluster and false otherwise.
	IsClusterWriter *bool `type:"boolean"`

	// A value that specifies the order in which an Aurora Replica is promoted to
	// the primary instance after a failure of the existing primary instance. For
	// more information, see Fault Tolerance for an Aurora DB Cluster (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance)
	// in the Amazon Aurora User Guide.
	PromotionTier *int64 `type:"integer"`
}

// String returns the string representation
func (s DBClusterMember) String() string {
	return awsutil.Prettify(s)
}

// Contains status information for a DB cluster option group.
type DBClusterOptionGroupStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the DB cluster option group.
	DBClusterOptionGroupName *string `type:"string"`

	// Specifies the status of the DB cluster option group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterOptionGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of an Amazon RDS DB cluster parameter group.
//
// This data type is used as a response element in the DescribeDBClusterParameterGroups
// action.
type DBClusterParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB cluster parameter group.
	DBClusterParameterGroupArn *string `type:"string"`

	// Provides the name of the DB cluster parameter group.
	DBClusterParameterGroupName *string `type:"string"`

	// Provides the name of the DB parameter group family that this DB cluster parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the customer-specified description for this DB cluster parameter
	// group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBClusterParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// Describes an AWS Identity and Access Management (IAM) role that is associated
// with a DB cluster.
type DBClusterRole struct {
	_ struct{} `type:"structure"`

	// The name of the feature associated with the AWS Identity and Access Management
	// (IAM) role. For the list of supported feature names, see DBEngineVersion.
	FeatureName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the
	// DB cluster.
	RoleArn *string `type:"string"`

	// Describes the state of association between the IAM role and the DB cluster.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - the IAM role ARN is associated with the DB cluster and can
	//    be used to access other AWS services on your behalf.
	//
	//    * PENDING - the IAM role ARN is being associated with the DB cluster.
	//
	//    * INVALID - the IAM role ARN is associated with the DB cluster, but the
	//    DB cluster is unable to assume the IAM role in order to access other AWS
	//    services on your behalf.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBClusterRole) String() string {
	return awsutil.Prettify(s)
}

// Contains the details for an Amazon RDS DB cluster snapshot
//
// This data type is used as a response element in the DescribeDBClusterSnapshots
// action.
type DBClusterSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage *int64 `type:"integer"`

	// Provides the list of Availability Zones (AZs) where instances in the DB cluster
	// snapshot can be restored.
	AvailabilityZones []string `locationNameList:"AvailabilityZone" type:"list"`

	// Specifies the time when the DB cluster was created, in Universal Coordinated
	// Time (UTC).
	ClusterCreateTime *time.Time `type:"timestamp"`

	// Specifies the DB cluster identifier of the DB cluster that this DB cluster
	// snapshot was created from.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB cluster snapshot.
	DBClusterSnapshotArn *string `type:"string"`

	// Specifies the identifier for the DB cluster snapshot.
	DBClusterSnapshotIdentifier *string `type:"string"`

	// Specifies the name of the database engine.
	Engine *string `type:"string"`

	// Provides the version of the database engine for this DB cluster snapshot.
	EngineVersion *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB cluster snapshot.
	KmsKeyId *string `type:"string"`

	// Provides the license model information for this DB cluster snapshot.
	LicenseModel *string `type:"string"`

	// Provides the master username for the DB cluster snapshot.
	MasterUsername *string `type:"string"`

	// Specifies the percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// Specifies the port that the DB cluster was listening on at the time of the
	// snapshot.
	Port *int64 `type:"integer"`

	// Provides the time when the snapshot was taken, in Universal Coordinated Time
	// (UTC).
	SnapshotCreateTime *time.Time `type:"timestamp"`

	// Provides the type of the DB cluster snapshot.
	SnapshotType *string `type:"string"`

	// If the DB cluster snapshot was copied from a source DB cluster snapshot,
	// the Amazon Resource Name (ARN) for the source DB cluster snapshot, otherwise,
	// a null value.
	SourceDBClusterSnapshotArn *string `type:"string"`

	// Specifies the status of this DB cluster snapshot.
	Status *string `type:"string"`

	// Specifies whether the DB cluster snapshot is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Provides the VPC ID associated with the DB cluster snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshot) String() string {
	return awsutil.Prettify(s)
}

// Contains the name and values of a manual DB cluster snapshot attribute.
//
// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
// to restore a manual DB cluster snapshot. For more information, see the ModifyDBClusterSnapshotAttribute
// API action.
type DBClusterSnapshotAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the manual DB cluster snapshot attribute.
	//
	// The attribute named restore refers to the list of AWS accounts that have
	// permission to copy or restore the manual DB cluster snapshot. For more information,
	// see the ModifyDBClusterSnapshotAttribute API action.
	AttributeName *string `type:"string"`

	// The value(s) for the manual DB cluster snapshot attribute.
	//
	// If the AttributeName field is set to restore, then this element returns a
	// list of IDs of the AWS accounts that are authorized to copy or restore the
	// manual DB cluster snapshot. If a value of all is in the list, then the manual
	// DB cluster snapshot is public and available for any AWS account to copy or
	// restore.
	AttributeValues []string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s DBClusterSnapshotAttribute) String() string {
	return awsutil.Prettify(s)
}

// Contains the results of a successful call to the DescribeDBClusterSnapshotAttributes
// API action.
//
// Manual DB cluster snapshot attributes are used to authorize other AWS accounts
// to copy or restore a manual DB cluster snapshot. For more information, see
// the ModifyDBClusterSnapshotAttribute API action.
type DBClusterSnapshotAttributesResult struct {
	_ struct{} `type:"structure"`

	// The list of attributes and values for the manual DB cluster snapshot.
	DBClusterSnapshotAttributes []DBClusterSnapshotAttribute `locationNameList:"DBClusterSnapshotAttribute" type:"list"`

	// The identifier of the manual DB cluster snapshot that the attributes apply
	// to.
	DBClusterSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DBClusterSnapshotAttributesResult) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the action DescribeDBEngineVersions.
type DBEngineVersion struct {
	_ struct{} `type:"structure"`

	// The description of the database engine.
	DBEngineDescription *string `type:"string"`

	// The description of the database engine version.
	DBEngineVersionDescription *string `type:"string"`

	// The name of the DB parameter group family for the database engine.
	DBParameterGroupFamily *string `type:"string"`

	// The default character set for new instances of this engine version, if the
	// CharacterSetName parameter of the CreateDBInstance API isn't specified.
	DefaultCharacterSet *CharacterSet `type:"structure"`

	// The name of the database engine.
	Engine *string `type:"string"`

	// The version number of the database engine.
	EngineVersion *string `type:"string"`

	// The types of logs that the database engine has available for export to CloudWatch
	// Logs.
	ExportableLogTypes []string `type:"list"`

	// The status of the DB engine version, either available or deprecated.
	Status *string `type:"string"`

	// A list of the character sets supported by this engine for the CharacterSetName
	// parameter of the CreateDBInstance action.
	SupportedCharacterSets []CharacterSet `locationNameList:"CharacterSet" type:"list"`

	// A list of the supported DB engine modes.
	SupportedEngineModes []string `type:"list"`

	// A list of features supported by the DB engine. Supported feature names include
	// the following.
	//
	//    * s3Import
	SupportedFeatureNames []string `type:"list"`

	// A list of the time zones supported by this engine for the Timezone parameter
	// of the CreateDBInstance action.
	SupportedTimezones []Timezone `locationNameList:"Timezone" type:"list"`

	// A value that indicates whether the engine version supports exporting the
	// log types specified by ExportableLogTypes to CloudWatch Logs.
	SupportsLogExportsToCloudwatchLogs *bool `type:"boolean"`

	// Indicates whether the database engine version supports Read Replicas.
	SupportsReadReplica *bool `type:"boolean"`

	// A list of engine versions that this database engine version can be upgraded
	// to.
	ValidUpgradeTarget []UpgradeTarget `locationNameList:"UpgradeTarget" type:"list"`
}

// String returns the string representation
func (s DBEngineVersion) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of an Amazon RDS DB instance.
//
// This data type is used as a response element in the DescribeDBInstances action.
type DBInstance struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size specified in gibibytes.
	AllocatedStorage *int64 `type:"integer"`

	// The AWS Identity and Access Management (IAM) roles associated with the DB
	// instance.
	AssociatedRoles []DBInstanceRole `locationNameList:"DBInstanceRole" type:"list"`

	// Indicates that minor version patches are applied automatically.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// Specifies the name of the Availability Zone the DB instance is located in.
	AvailabilityZone *string `type:"string"`

	// Specifies the number of days for which automatic DB snapshots are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// The identifier of the CA certificate for this DB instance.
	CACertificateIdentifier *string `type:"string"`

	// If present, specifies the name of the character set that this instance is
	// associated with.
	CharacterSetName *string `type:"string"`

	// Specifies whether tags are copied from the DB instance to snapshots of the
	// DB instance.
	//
	// Amazon Aurora
	//
	// Not applicable. Copying tags to snapshots is managed by the DB cluster. Setting
	// this value for an Aurora DB instance has no effect on the DB cluster setting.
	// For more information, see DBCluster.
	CopyTagsToSnapshot *bool `type:"boolean"`

	// If the DB instance is a member of a DB cluster, contains the name of the
	// DB cluster that the DB instance is a member of.
	DBClusterIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB instance.
	DBInstanceArn *string `type:"string"`

	// Contains the name of the compute and memory capacity class of the DB instance.
	DBInstanceClass *string `type:"string"`

	// Contains a user-supplied database identifier. This identifier is the unique
	// key that identifies a DB instance.
	DBInstanceIdentifier *string `type:"string"`

	// Specifies the current state of this database.
	DBInstanceStatus *string `type:"string"`

	// The meaning of this parameter differs according to the database engine you
	// use.
	//
	// MySQL, MariaDB, SQL Server, PostgreSQL
	//
	// Contains the name of the initial database of this instance that was provided
	// at create time, if one was specified when the DB instance was created. This
	// same name is returned for the life of the DB instance.
	//
	// Type: String
	//
	// Oracle
	//
	// Contains the Oracle System ID (SID) of the created DB instance. Not shown
	// when the returned parameters do not apply to an Oracle DB instance.
	DBName *string `type:"string"`

	// Provides the list of DB parameter groups applied to this DB instance.
	DBParameterGroups []DBParameterGroupStatus `locationNameList:"DBParameterGroup" type:"list"`

	// A list of DB security group elements containing DBSecurityGroup.Name and
	// DBSecurityGroup.Status subelements.
	DBSecurityGroups []DBSecurityGroupMembership `locationNameList:"DBSecurityGroup" type:"list"`

	// Specifies information on the subnet group associated with the DB instance,
	// including the name, description, and subnets in the subnet group.
	DBSubnetGroup *DBSubnetGroup `type:"structure"`

	// Specifies the port that the DB instance listens on. If the DB instance is
	// part of a DB cluster, this can be a different port than the DB cluster port.
	DbInstancePort *int64 `type:"integer"`

	// The AWS Region-unique, immutable identifier for the DB instance. This identifier
	// is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB
	// instance is accessed.
	DbiResourceId *string `type:"string"`

	// Indicates if the DB instance has deletion protection enabled. The database
	// can't be deleted when deletion protection is enabled. For more information,
	// see Deleting a DB Instance (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html).
	DeletionProtection *bool `type:"boolean"`

	// The Active Directory Domain membership records associated with the DB instance.
	DomainMemberships []DomainMembership `locationNameList:"DomainMembership" type:"list"`

	// A list of log types that this DB instance is configured to export to CloudWatch
	// Logs.
	//
	// Log types vary by DB engine. For information about the log types for each
	// DB engine, see Amazon RDS Database Log Files (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html)
	// in the Amazon RDS User Guide.
	EnabledCloudwatchLogsExports []string `type:"list"`

	// Specifies the connection endpoint.
	Endpoint *Endpoint `type:"structure"`

	// Provides the name of the database engine to be used for this DB instance.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon CloudWatch Logs log stream that
	// receives the Enhanced Monitoring metrics data for the DB instance.
	EnhancedMonitoringResourceArn *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	//
	// IAM database authentication can be enabled for the following database engines
	//
	//    * For MySQL 5.6, minor version 5.6.34 or higher
	//
	//    * For MySQL 5.7, minor version 5.7.16 or higher
	//
	//    * Aurora 5.6 or higher. To enable IAM database authentication for Aurora,
	//    see DBCluster Type.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Provides the date and time the DB instance was created.
	InstanceCreateTime *time.Time `type:"timestamp"`

	// Specifies the Provisioned IOPS (I/O operations per second) value.
	Iops *int64 `type:"integer"`

	// If StorageEncrypted is true, the AWS KMS key identifier for the encrypted
	// DB instance.
	KmsKeyId *string `type:"string"`

	// Specifies the latest time to which a database can be restored with point-in-time
	// restore.
	LatestRestorableTime *time.Time `type:"timestamp"`

	// License model information for this DB instance.
	LicenseModel *string `type:"string"`

	// Specifies the listener connection endpoint for SQL Server Always On.
	ListenerEndpoint *Endpoint `type:"structure"`

	// Contains the master username for the DB instance.
	MasterUsername *string `type:"string"`

	// The upper limit to which Amazon RDS can automatically scale the storage of
	// the DB instance.
	MaxAllocatedStorage *int64 `type:"integer"`

	// The interval, in seconds, between points when Enhanced Monitoring metrics
	// are collected for the DB instance.
	MonitoringInterval *int64 `type:"integer"`

	// The ARN for the IAM role that permits RDS to send Enhanced Monitoring metrics
	// to Amazon CloudWatch Logs.
	MonitoringRoleArn *string `type:"string"`

	// Specifies if the DB instance is a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// Provides the list of option group memberships for this DB instance.
	OptionGroupMemberships []OptionGroupMembership `locationNameList:"OptionGroupMembership" type:"list"`

	// Specifies that changes to the DB instance are pending. This element is only
	// included when changes are pending. Specific changes are identified by subelements.
	PendingModifiedValues *PendingModifiedValues `type:"structure"`

	// True if Performance Insights is enabled for the DB instance, and otherwise
	// false.
	PerformanceInsightsEnabled *bool `type:"boolean"`

	// The AWS KMS key identifier for encryption of Performance Insights data. The
	// KMS key ID is the Amazon Resource Name (ARN), KMS key identifier, or the
	// KMS key alias for the KMS encryption key.
	PerformanceInsightsKMSKeyId *string `type:"string"`

	// The amount of time, in days, to retain Performance Insights data. Valid values
	// are 7 or 731 (2 years).
	PerformanceInsightsRetentionPeriod *int64 `type:"integer"`

	// Specifies the daily time range during which automated backups are created
	// if automated backups are enabled, as determined by the BackupRetentionPeriod.
	PreferredBackupWindow *string `type:"string"`

	// Specifies the weekly time range during which system maintenance can occur,
	// in Universal Coordinated Time (UTC).
	PreferredMaintenanceWindow *string `type:"string"`

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []ProcessorFeature `locationNameList:"ProcessorFeature" type:"list"`

	// A value that specifies the order in which an Aurora Replica is promoted to
	// the primary instance after a failure of the existing primary instance. For
	// more information, see Fault Tolerance for an Aurora DB Cluster (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/Aurora.Managing.Backups.html#Aurora.Managing.FaultTolerance)
	// in the Amazon Aurora User Guide.
	PromotionTier *int64 `type:"integer"`

	// Specifies the accessibility options for the DB instance. A value of true
	// specifies an Internet-facing instance with a publicly resolvable DNS name,
	// which resolves to a public IP address. A value of false specifies an internal
	// instance with a DNS name that resolves to a private IP address.
	PubliclyAccessible *bool `type:"boolean"`

	// Contains one or more identifiers of Aurora DB clusters to which the RDS DB
	// instance is replicated as a Read Replica. For example, when you create an
	// Aurora Read Replica of an RDS MySQL DB instance, the Aurora MySQL DB cluster
	// for the Aurora Read Replica is shown. This output does not contain information
	// about cross region Aurora Read Replicas.
	//
	// Currently, each RDS DB instance can have only one Aurora Read Replica.
	ReadReplicaDBClusterIdentifiers []string `locationNameList:"ReadReplicaDBClusterIdentifier" type:"list"`

	// Contains one or more identifiers of the Read Replicas associated with this
	// DB instance.
	ReadReplicaDBInstanceIdentifiers []string `locationNameList:"ReadReplicaDBInstanceIdentifier" type:"list"`

	// Contains the identifier of the source DB instance if this DB instance is
	// a Read Replica.
	ReadReplicaSourceDBInstanceIdentifier *string `type:"string"`

	// If present, specifies the name of the secondary Availability Zone for a DB
	// instance with multi-AZ support.
	SecondaryAvailabilityZone *string `type:"string"`

	// The status of a Read Replica. If the instance isn't a Read Replica, this
	// is blank.
	StatusInfos []DBInstanceStatusInfo `locationNameList:"DBInstanceStatusInfo" type:"list"`

	// Specifies whether the DB instance is encrypted.
	StorageEncrypted *bool `type:"boolean"`

	// Specifies the storage type associated with DB instance.
	StorageType *string `type:"string"`

	// The ARN from the key store with which the instance is associated for TDE
	// encryption.
	TdeCredentialArn *string `type:"string"`

	// The time zone of the DB instance. In most cases, the Timezone element is
	// empty. Timezone content appears only for Microsoft SQL Server DB instances
	// that were created with a time zone specified.
	Timezone *string `type:"string"`

	// Provides a list of VPC security group elements that the DB instance belongs
	// to.
	VpcSecurityGroups []VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s DBInstance) String() string {
	return awsutil.Prettify(s)
}

// An automated backup of a DB instance. It it consists of system backups, transaction
// logs, and the database instance properties that existed at the time you deleted
// the source instance.
type DBInstanceAutomatedBackup struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage *int64 `type:"integer"`

	// The Availability Zone that the automated backup was created in. For information
	// on AWS Regions and Availability Zones, see Regions and Availability Zones
	// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html).
	AvailabilityZone *string `type:"string"`

	// The Amazon Resource Name (ARN) for the automated backup.
	DBInstanceArn *string `type:"string"`

	// The customer id of the instance that is/was associated with the automated
	// backup.
	DBInstanceIdentifier *string `type:"string"`

	// The identifier for the source DB instance, which can't be changed and which
	// is unique to an AWS Region.
	DbiResourceId *string `type:"string"`

	// Specifies whether the automated backup is encrypted.
	Encrypted *bool `type:"boolean"`

	// The name of the database engine for this automated backup.
	Engine *string `type:"string"`

	// The version of the database engine for the automated backup.
	EngineVersion *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Provides the date and time that the DB instance was created.
	InstanceCreateTime *time.Time `type:"timestamp"`

	// The IOPS (I/O operations per second) value for the automated backup.
	Iops *int64 `type:"integer"`

	// The AWS KMS key ID for an automated backup. The KMS key ID is the Amazon
	// Resource Name (ARN), KMS key identifier, or the KMS key alias for the KMS
	// encryption key.
	KmsKeyId *string `type:"string"`

	// License model information for the automated backup.
	LicenseModel *string `type:"string"`

	// The license model of an automated backup.
	MasterUsername *string `type:"string"`

	// The option group the automated backup is associated with. If omitted, the
	// default option group for the engine specified is used.
	OptionGroupName *string `type:"string"`

	// The port number that the automated backup used for connections.
	//
	// Default: Inherits from the source DB instance
	//
	// Valid Values: 1150-65535
	Port *int64 `type:"integer"`

	// The AWS Region associated with the automated backup.
	Region *string `type:"string"`

	// Earliest and latest time an instance can be restored to.
	RestoreWindow *RestoreWindow `type:"structure"`

	// Provides a list of status information for an automated backup:
	//
	//    * active - automated backups for current instances
	//
	//    * retained - automated backups for deleted instances
	//
	//    * creating - automated backups that are waiting for the first automated
	//    snapshot to be available.
	Status *string `type:"string"`

	// Specifies the storage type associated with the automated backup.
	StorageType *string `type:"string"`

	// The ARN from the key store with which the automated backup is associated
	// for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The time zone of the automated backup. In most cases, the Timezone element
	// is empty. Timezone content appears only for Microsoft SQL Server DB instances
	// that were created with a time zone specified.
	Timezone *string `type:"string"`

	// Provides the VPC ID associated with the DB instance
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceAutomatedBackup) String() string {
	return awsutil.Prettify(s)
}

// Describes an AWS Identity and Access Management (IAM) role that is associated
// with a DB instance.
type DBInstanceRole struct {
	_ struct{} `type:"structure"`

	// The name of the feature associated with the AWS Identity and Access Management
	// (IAM) role. For the list of supported feature names, see DBEngineVersion.
	FeatureName *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that is associated with the
	// DB instance.
	RoleArn *string `type:"string"`

	// Describes the state of association between the IAM role and the DB instance.
	// The Status property returns one of the following values:
	//
	//    * ACTIVE - the IAM role ARN is associated with the DB instance and can
	//    be used to access other AWS services on your behalf.
	//
	//    * PENDING - the IAM role ARN is being associated with the DB instance.
	//
	//    * INVALID - the IAM role ARN is associated with the DB instance, but the
	//    DB instance is unable to assume the IAM role in order to access other
	//    AWS services on your behalf.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceRole) String() string {
	return awsutil.Prettify(s)
}

// Provides a list of status information for a DB instance.
type DBInstanceStatusInfo struct {
	_ struct{} `type:"structure"`

	// Details of the error if there is an error for the instance. If the instance
	// isn't in an error state, this value is blank.
	Message *string `type:"string"`

	// Boolean value that is true if the instance is operating normally, or false
	// if the instance is in an error state.
	Normal *bool `type:"boolean"`

	// Status of the DB instance. For a StatusType of Read Replica, the values can
	// be replicating, replication stop point set, replication stop point reached,
	// error, stopped, or terminated.
	Status *string `type:"string"`

	// This value is currently "read replication."
	StatusType *string `type:"string"`
}

// String returns the string representation
func (s DBInstanceStatusInfo) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of an Amazon RDS DB parameter group.
//
// This data type is used as a response element in the DescribeDBParameterGroups
// action.
type DBParameterGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB parameter group.
	DBParameterGroupArn *string `type:"string"`

	// Provides the name of the DB parameter group family that this DB parameter
	// group is compatible with.
	DBParameterGroupFamily *string `type:"string"`

	// Provides the name of the DB parameter group.
	DBParameterGroupName *string `type:"string"`

	// Provides the customer-specified description for this DB parameter group.
	Description *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// The status of the DB parameter group.
//
// This data type is used as a response element in the following actions:
//
//    * CreateDBInstance
//
//    * CreateDBInstanceReadReplica
//
//    * DeleteDBInstance
//
//    * ModifyDBInstance
//
//    * RebootDBInstance
//
//    * RestoreDBInstanceFromDBSnapshot
type DBParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// The name of the DB parameter group.
	DBParameterGroupName *string `type:"string"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`
}

// String returns the string representation
func (s DBParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// The data structure representing a proxy managed by the RDS Proxy.
//
// This data type is used as a response element in the DescribeDBProxies action.
type DBProxy struct {
	_ struct{} `type:"structure"`

	// One or more data structures specifying the authorization mechanism to connect
	// to the associated RDS DB instance or Aurora DB cluster.
	Auth []UserAuthConfigInfo `type:"list"`

	// The date and time when the proxy was first created.
	CreatedDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) for the proxy.
	DBProxyArn *string `type:"string"`

	// The identifier for the proxy. This name must be unique for all proxies owned
	// by your AWS account in the specified AWS Region.
	DBProxyName *string `type:"string"`

	// Whether the proxy includes detailed information about SQL statements in its
	// logs. This information helps you to debug issues involving SQL behavior or
	// the performance and scalability of the proxy connections. The debug information
	// includes the text of SQL statements that you submit through the proxy. Thus,
	// only enable this setting when needed for debugging, and only when you have
	// security measures in place to safeguard any sensitive information that appears
	// in the logs.
	DebugLogging *bool `type:"boolean"`

	// The endpoint that you can use to connect to the proxy. You include the endpoint
	// value in the connection string for a database client application.
	Endpoint *string `type:"string"`

	// Currently, this value is always MYSQL. The engine family applies to both
	// RDS MySQL and Aurora MySQL.
	EngineFamily *string `type:"string"`

	// The number of seconds a connection to the proxy can have no activity before
	// the proxy drops the client connection. The proxy keeps the underlying database
	// connection open and puts it back into the connection pool for reuse by later
	// connection requests.
	//
	// Default: 1800 (30 minutes)
	//
	// Constraints: 1 to 28,800
	IdleClientTimeout *int64 `type:"integer"`

	// Indicates whether Transport Layer Security (TLS) encryption is required for
	// connections to the proxy.
	RequireTLS *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for the IAM role that the proxy uses to access
	// Amazon Secrets Manager.
	RoleArn *string `type:"string"`

	// The current status of this proxy. A status of available means the proxy is
	// ready to handle requests. Other values indicate that you must wait for the
	// proxy to be ready, or take some action to resolve an issue.
	Status DBProxyStatus `type:"string" enum:"true"`

	// The date and time when the proxy was last updated.
	UpdatedDate *time.Time `type:"timestamp"`

	// Provides a list of VPC security groups that the proxy belongs to.
	VpcSecurityGroupIds []string `type:"list"`

	// The EC2 subnet IDs for the proxy.
	VpcSubnetIds []string `type:"list"`
}

// String returns the string representation
func (s DBProxy) String() string {
	return awsutil.Prettify(s)
}

//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Contains the details for an RDS Proxy target. It represents an RDS DB instance
// or Aurora DB cluster that the proxy can connect to. One or more targets are
// associated with an RDS Proxy target group.
//
// This data type is used as a response element in the DescribeDBProxyTargets
// action.
type DBProxyTarget struct {
	_ struct{} `type:"structure"`

	// The writer endpoint for the RDS DB instance or Aurora DB cluster.
	Endpoint *string `type:"string"`

	// The port that the RDS Proxy uses to connect to the target RDS DB instance
	// or Aurora DB cluster.
	Port *int64 `type:"integer"`

	// The identifier representing the target. It can be the instance identifier
	// for an RDS DB instance, or the cluster identifier for an Aurora DB cluster.
	RdsResourceId *string `type:"string"`

	// The Amazon Resource Name (ARN) for the RDS DB instance or Aurora DB cluster.
	TargetArn *string `type:"string"`

	// The DB cluster identifier when the target represents an Aurora DB cluster.
	// This field is blank when the target represents an
	TrackedClusterId *string `type:"string"`

	// Specifies the kind of database, such as an RDS DB instance or an Aurora DB
	// cluster, that the target represents.
	Type TargetType `type:"string" enum:"true"`
}

// String returns the string representation
func (s DBProxyTarget) String() string {
	return awsutil.Prettify(s)
}

//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Represents a set of RDS DB instances, Aurora DB clusters, or both that a
// proxy can connect to. Currently, each target group is associated with exactly
// one RDS DB instance or Aurora DB cluster.
//
// This data type is used as a response element in the DescribeDBProxyTargetGroups
// action.
type DBProxyTargetGroup struct {
	_ struct{} `type:"structure"`

	// The settings that determine the size and behavior of the connection pool
	// for the target group.
	ConnectionPoolConfig *ConnectionPoolConfigurationInfo `type:"structure"`

	// The date and time when the target group was first created.
	CreatedDate *time.Time `type:"timestamp"`

	// The identifier for the RDS proxy associated with this target group.
	DBProxyName *string `type:"string"`

	// Whether this target group is the first one used for connection requests by
	// the associated proxy. Because each proxy is currently associated with a single
	// target group, currently this setting is always true.
	IsDefault *bool `type:"boolean"`

	// The current status of this target group. A status of available means the
	// target group is correctly associated with a database. Other values indicate
	// that you must wait for the target group to be ready, or take some action
	// to resolve an issue.
	Status *string `type:"string"`

	// The Amazon Resource Name (ARN) representing the target group.
	TargetGroupArn *string `type:"string"`

	// The identifier for the target group. This name must be unique for all target
	// groups owned by your AWS account in the specified AWS Region.
	TargetGroupName *string `type:"string"`

	// The date and time when the target group was last updated.
	UpdatedDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DBProxyTargetGroup) String() string {
	return awsutil.Prettify(s)
}

// Contains the details for an Amazon RDS DB security group.
//
// This data type is used as a response element in the DescribeDBSecurityGroups
// action.
type DBSecurityGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB security group.
	DBSecurityGroupArn *string `type:"string"`

	// Provides the description of the DB security group.
	DBSecurityGroupDescription *string `type:"string"`

	// Specifies the name of the DB security group.
	DBSecurityGroupName *string `type:"string"`

	// Contains a list of EC2SecurityGroup elements.
	EC2SecurityGroups []EC2SecurityGroup `locationNameList:"EC2SecurityGroup" type:"list"`

	// Contains a list of IPRange elements.
	IPRanges []IPRange `locationNameList:"IPRange" type:"list"`

	// Provides the AWS ID of the owner of a specific DB security group.
	OwnerId *string `type:"string"`

	// Provides the VpcId of the DB security group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the following actions:
//
//    * ModifyDBInstance
//
//    * RebootDBInstance
//
//    * RestoreDBInstanceFromDBSnapshot
//
//    * RestoreDBInstanceToPointInTime
type DBSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group.
	DBSecurityGroupName *string `type:"string"`

	// The status of the DB security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s DBSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of an Amazon RDS DB snapshot.
//
// This data type is used as a response element in the DescribeDBSnapshots action.
type DBSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies the allocated storage size in gibibytes (GiB).
	AllocatedStorage *int64 `type:"integer"`

	// Specifies the name of the Availability Zone the DB instance was located in
	// at the time of the DB snapshot.
	AvailabilityZone *string `type:"string"`

	// Specifies the DB instance identifier of the DB instance this DB snapshot
	// was created from.
	DBInstanceIdentifier *string `type:"string"`

	// The Amazon Resource Name (ARN) for the DB snapshot.
	DBSnapshotArn *string `type:"string"`

	// Specifies the identifier for the DB snapshot.
	DBSnapshotIdentifier *string `type:"string"`

	// The identifier for the source DB instance, which can't be changed and which
	// is unique to an AWS Region.
	DbiResourceId *string `type:"string"`

	// Specifies whether the DB snapshot is encrypted.
	Encrypted *bool `type:"boolean"`

	// Specifies the name of the database engine.
	Engine *string `type:"string"`

	// Specifies the version of the database engine.
	EngineVersion *string `type:"string"`

	// True if mapping of AWS Identity and Access Management (IAM) accounts to database
	// accounts is enabled, and otherwise false.
	IAMDatabaseAuthenticationEnabled *bool `type:"boolean"`

	// Specifies the time when the snapshot was taken, in Universal Coordinated
	// Time (UTC).
	InstanceCreateTime *time.Time `type:"timestamp"`

	// Specifies the Provisioned IOPS (I/O operations per second) value of the DB
	// instance at the time of the snapshot.
	Iops *int64 `type:"integer"`

	// If Encrypted is true, the AWS KMS key identifier for the encrypted DB snapshot.
	KmsKeyId *string `type:"string"`

	// License model information for the restored DB instance.
	LicenseModel *string `type:"string"`

	// Provides the master username for the DB snapshot.
	MasterUsername *string `type:"string"`

	// Provides the option group name for the DB snapshot.
	OptionGroupName *string `type:"string"`

	// The percentage of the estimated data that has been transferred.
	PercentProgress *int64 `type:"integer"`

	// Specifies the port that the database engine was listening on at the time
	// of the snapshot.
	Port *int64 `type:"integer"`

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance when the DB snapshot was created.
	ProcessorFeatures []ProcessorFeature `locationNameList:"ProcessorFeature" type:"list"`

	// Provides the time when the snapshot was taken, in Universal Coordinated Time
	// (UTC).
	SnapshotCreateTime *time.Time `type:"timestamp"`

	// Provides the type of the DB snapshot.
	SnapshotType *string `type:"string"`

	// The DB snapshot Amazon Resource Name (ARN) that the DB snapshot was copied
	// from. It only has value in case of cross-customer or cross-region copy.
	SourceDBSnapshotIdentifier *string `type:"string"`

	// The AWS Region that the DB snapshot was created in or copied from.
	SourceRegion *string `type:"string"`

	// Specifies the status of this DB snapshot.
	Status *string `type:"string"`

	// Specifies the storage type associated with DB snapshot.
	StorageType *string `type:"string"`

	// The ARN from the key store with which to associate the instance for TDE encryption.
	TdeCredentialArn *string `type:"string"`

	// The time zone of the DB snapshot. In most cases, the Timezone element is
	// empty. Timezone content appears only for snapshots taken from Microsoft SQL
	// Server DB instances that were created with a time zone specified.
	Timezone *string `type:"string"`

	// Provides the VPC ID associated with the DB snapshot.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSnapshot) String() string {
	return awsutil.Prettify(s)
}

// Contains the name and values of a manual DB snapshot attribute
//
// Manual DB snapshot attributes are used to authorize other AWS accounts to
// restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
// API.
type DBSnapshotAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the manual DB snapshot attribute.
	//
	// The attribute named restore refers to the list of AWS accounts that have
	// permission to copy or restore the manual DB cluster snapshot. For more information,
	// see the ModifyDBSnapshotAttribute API action.
	AttributeName *string `type:"string"`

	// The value or values for the manual DB snapshot attribute.
	//
	// If the AttributeName field is set to restore, then this element returns a
	// list of IDs of the AWS accounts that are authorized to copy or restore the
	// manual DB snapshot. If a value of all is in the list, then the manual DB
	// snapshot is public and available for any AWS account to copy or restore.
	AttributeValues []string `locationNameList:"AttributeValue" type:"list"`
}

// String returns the string representation
func (s DBSnapshotAttribute) String() string {
	return awsutil.Prettify(s)
}

// Contains the results of a successful call to the DescribeDBSnapshotAttributes
// API action.
//
// Manual DB snapshot attributes are used to authorize other AWS accounts to
// copy or restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
// API action.
type DBSnapshotAttributesResult struct {
	_ struct{} `type:"structure"`

	// The list of attributes and values for the manual DB snapshot.
	DBSnapshotAttributes []DBSnapshotAttribute `locationNameList:"DBSnapshotAttribute" type:"list"`

	// The identifier of the manual DB snapshot that the attributes apply to.
	DBSnapshotIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DBSnapshotAttributesResult) String() string {
	return awsutil.Prettify(s)
}

// Contains the details of an Amazon RDS DB subnet group.
//
// This data type is used as a response element in the DescribeDBSubnetGroups
// action.
type DBSubnetGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DB subnet group.
	DBSubnetGroupArn *string `type:"string"`

	// Provides the description of the DB subnet group.
	DBSubnetGroupDescription *string `type:"string"`

	// The name of the DB subnet group.
	DBSubnetGroupName *string `type:"string"`

	// Provides the status of the DB subnet group.
	SubnetGroupStatus *string `type:"string"`

	// Contains a list of Subnet elements.
	Subnets []Subnet `locationNameList:"Subnet" type:"list"`

	// Provides the VpcId of the DB subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s DBSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element to DescribeDBLogFiles.
type DescribeDBLogFilesDetails struct {
	_ struct{} `type:"structure"`

	// A POSIX timestamp when the last log entry was written.
	LastWritten *int64 `type:"long"`

	// The name of the log file for the specified DB instance.
	LogFileName *string `type:"string"`

	// The size, in bytes, of the log file for the specified DB instance.
	Size *int64 `type:"long"`
}

// String returns the string representation
func (s DescribeDBLogFilesDetails) String() string {
	return awsutil.Prettify(s)
}

// An Active Directory Domain membership record associated with the DB instance.
type DomainMembership struct {
	_ struct{} `type:"structure"`

	// The identifier of the Active Directory Domain.
	Domain *string `type:"string"`

	// The fully qualified domain name of the Active Directory Domain.
	FQDN *string `type:"string"`

	// The name of the IAM role to be used when making API calls to the Directory
	// Service.
	IAMRoleName *string `type:"string"`

	// The status of the DB instance's Active Directory Domain membership, such
	// as joined, pending-join, failed etc).
	Status *string `type:"string"`
}

// String returns the string representation
func (s DomainMembership) String() string {
	return awsutil.Prettify(s)
}

// A range of double values.
type DoubleRange struct {
	_ struct{} `type:"structure"`

	// The minimum value in the range.
	From *float64 `type:"double"`

	// The maximum value in the range.
	To *float64 `type:"double"`
}

// String returns the string representation
func (s DoubleRange) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the following actions:
//
//    * AuthorizeDBSecurityGroupIngress
//
//    * DescribeDBSecurityGroups
//
//    * RevokeDBSecurityGroupIngress
type EC2SecurityGroup struct {
	_ struct{} `type:"structure"`

	// Specifies the id of the EC2 security group.
	EC2SecurityGroupId *string `type:"string"`

	// Specifies the name of the EC2 security group.
	EC2SecurityGroupName *string `type:"string"`

	// Specifies the AWS ID of the owner of the EC2 security group specified in
	// the EC2SecurityGroupName field.
	EC2SecurityGroupOwnerId *string `type:"string"`

	// Provides the status of the EC2 security group. Status can be "authorizing",
	// "authorized", "revoking", and "revoked".
	Status *string `type:"string"`
}

// String returns the string representation
func (s EC2SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// This data type represents the information you need to connect to an Amazon
// RDS DB instance. This data type is used as a response element in the following
// actions:
//
//    * CreateDBInstance
//
//    * DescribeDBInstances
//
//    * DeleteDBInstance
//
// For the data structure that represents Amazon Aurora DB cluster endpoints,
// see DBClusterEndpoint.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// Specifies the DNS address of the DB instance.
	Address *string `type:"string"`

	// Specifies the ID that Amazon Route 53 assigns when you create a hosted zone.
	HostedZoneId *string `type:"string"`

	// Specifies the port that the database engine is listening on.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// Contains the result of a successful invocation of the DescribeEngineDefaultParameters
// action.
type EngineDefaults struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the DB parameter group family that the engine default
	// parameters apply to.
	DBParameterGroupFamily *string `type:"string"`

	// An optional pagination token provided by a previous EngineDefaults request.
	// If this parameter is specified, the response includes only records beyond
	// the marker, up to the value specified by MaxRecords .
	Marker *string `type:"string"`

	// Contains a list of engine default parameters.
	Parameters []Parameter `locationNameList:"Parameter" type:"list"`
}

// String returns the string representation
func (s EngineDefaults) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the DescribeEvents action.
type Event struct {
	_ struct{} `type:"structure"`

	// Specifies the date and time of the event.
	Date *time.Time `type:"timestamp"`

	// Specifies the category for the event.
	EventCategories []string `locationNameList:"EventCategory" type:"list"`

	// Provides the text of this event.
	Message *string `type:"string"`

	// The Amazon Resource Name (ARN) for the event.
	SourceArn *string `type:"string"`

	// Provides the identifier for the source of the event.
	SourceIdentifier *string `type:"string"`

	// Specifies the source type for this event.
	SourceType SourceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// Contains the results of a successful invocation of the DescribeEventCategories
// action.
type EventCategoriesMap struct {
	_ struct{} `type:"structure"`

	// The event categories for the specified source type
	EventCategories []string `locationNameList:"EventCategory" type:"list"`

	// The source type that the returned categories belong to
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoriesMap) String() string {
	return awsutil.Prettify(s)
}

// Contains the results of a successful invocation of the DescribeEventSubscriptions
// action.
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The RDS event notification subscription Id.
	CustSubscriptionId *string `type:"string"`

	// The AWS customer account associated with the RDS event notification subscription.
	CustomerAwsId *string `type:"string"`

	// A Boolean value indicating if the subscription is enabled. True indicates
	// the subscription is enabled.
	Enabled *bool `type:"boolean"`

	// A list of event categories for the RDS event notification subscription.
	EventCategoriesList []string `locationNameList:"EventCategory" type:"list"`

	// The Amazon Resource Name (ARN) for the event subscription.
	EventSubscriptionArn *string `type:"string"`

	// The topic ARN of the RDS event notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of source IDs for the RDS event notification subscription.
	SourceIdsList []string `locationNameList:"SourceId" type:"list"`

	// The source type for the RDS event notification subscription.
	SourceType *string `type:"string"`

	// The status of the RDS event notification subscription.
	//
	// Constraints:
	//
	// Can be one of the following: creating | modifying | deleting | active | no-permission
	// | topic-not-exist
	//
	// The status "no-permission" indicates that RDS no longer has permission to
	// post to the SNS topic. The status "topic-not-exist" indicates that the topic
	// was deleted after the subscription was created.
	Status *string `type:"string"`

	// The time the RDS event notification subscription was created.
	SubscriptionCreationTime *string `type:"string"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// A filter name and value pair that is used to return a more specific list
// of results from a describe operation. Filters can be used to match a set
// of resources by specific criteria, such as IDs. The filters supported by
// a describe operation are documented with the describe operation.
//
// Currently, wildcards are not supported in filters.
//
// The following actions can be filtered:
//
//    * DescribeDBClusterBacktracks
//
//    * DescribeDBClusterEndpoints
//
//    * DescribeDBClusters
//
//    * DescribeDBInstances
//
//    * DescribePendingMaintenanceActions
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. Filter names are case-sensitive.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// One or more filter values. Filter values are case-sensitive.
	//
	// Values is a required field
	Values []string `locationNameList:"Value" type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.Values == nil {
		invalidParams.Add(aws.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A data type representing an Aurora global database.
type GlobalCluster struct {
	_ struct{} `type:"structure"`

	// The default database name within the new global database cluster.
	DatabaseName *string `type:"string"`

	// The deletion protection setting for the new global database cluster.
	DeletionProtection *bool `type:"boolean"`

	// The Aurora database engine used by the global database cluster.
	Engine *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) for the global database cluster.
	GlobalClusterArn *string `type:"string"`

	// Contains a user-supplied global database cluster identifier. This identifier
	// is the unique key that identifies a global database cluster.
	GlobalClusterIdentifier *string `type:"string"`

	// The list of cluster IDs for secondary clusters within the global database
	// cluster. Currently limited to 1 item.
	GlobalClusterMembers []GlobalClusterMember `locationNameList:"GlobalClusterMember" type:"list"`

	// The AWS Region-unique, immutable identifier for the global database cluster.
	// This identifier is found in AWS CloudTrail log entries whenever the AWS KMS
	// key for the DB cluster is accessed.
	GlobalClusterResourceId *string `type:"string"`

	// Specifies the current state of this global database cluster.
	Status *string `type:"string"`

	// The storage encryption setting for the global database cluster.
	StorageEncrypted *bool `type:"boolean"`
}

// String returns the string representation
func (s GlobalCluster) String() string {
	return awsutil.Prettify(s)
}

// A data structure with information about any primary and secondary clusters
// associated with an Aurora global database.
type GlobalClusterMember struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for each Aurora cluster.
	DBClusterArn *string `type:"string"`

	// Specifies whether the Aurora cluster is the primary cluster (that is, has
	// read-write capability) for the Aurora global database with which it is associated.
	IsWriter *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for each read-only secondary cluster associated
	// with the Aurora global database.
	Readers []string `type:"list"`
}

// String returns the string representation
func (s GlobalClusterMember) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the DescribeDBSecurityGroups
// action.
type IPRange struct {
	_ struct{} `type:"structure"`

	// Specifies the IP range.
	CIDRIP *string `type:"string"`

	// Specifies the status of the IP range. Status can be "authorizing", "authorized",
	// "revoking", and "revoked".
	Status *string `type:"string"`
}

// String returns the string representation
func (s IPRange) String() string {
	return awsutil.Prettify(s)
}

// Contains the installation media for a DB engine that requires an on-premises
// customer provided license, such as Microsoft SQL Server.
type InstallationMedia struct {
	_ struct{} `type:"structure"`

	// The custom Availability Zone (AZ) that contains the installation media.
	CustomAvailabilityZoneId *string `type:"string"`

	// The DB engine.
	Engine *string `type:"string"`

	// The path to the installation medium for the DB engine.
	EngineInstallationMediaPath *string `type:"string"`

	// The engine version of the DB engine.
	EngineVersion *string `type:"string"`

	// If an installation media failure occurred, the cause of the failure.
	FailureCause *InstallationMediaFailureCause `type:"structure"`

	// The installation medium ID.
	InstallationMediaId *string `type:"string"`

	// The path to the installation medium for the operating system associated with
	// the DB engine.
	OSInstallationMediaPath *string `type:"string"`

	// The status of the installation medium.
	Status *string `type:"string"`
}

// String returns the string representation
func (s InstallationMedia) String() string {
	return awsutil.Prettify(s)
}

// Contains the cause of an installation media failure. Installation media is
// used for a DB engine that requires an on-premises customer provided license,
// such as Microsoft SQL Server.
type InstallationMediaFailureCause struct {
	_ struct{} `type:"structure"`

	// The reason that an installation media import failed.
	Message *string `type:"string"`
}

// String returns the string representation
func (s InstallationMediaFailureCause) String() string {
	return awsutil.Prettify(s)
}

// The minimum DB engine version required for each corresponding allowed value
// for an option setting.
type MinimumEngineVersionPerAllowedValue struct {
	_ struct{} `type:"structure"`

	// The allowed value for an option setting.
	AllowedValue *string `type:"string"`

	// The minimum DB engine version required for the allowed value.
	MinimumEngineVersion *string `type:"string"`
}

// String returns the string representation
func (s MinimumEngineVersionPerAllowedValue) String() string {
	return awsutil.Prettify(s)
}

// Option details.
type Option struct {
	_ struct{} `type:"structure"`

	// If the option requires access to a port, then this DB security group allows
	// access to the port.
	DBSecurityGroupMemberships []DBSecurityGroupMembership `locationNameList:"DBSecurityGroup" type:"list"`

	// The description of the option.
	OptionDescription *string `type:"string"`

	// The name of the option.
	OptionName *string `type:"string"`

	// The option settings for this option.
	OptionSettings []OptionSetting `locationNameList:"OptionSetting" type:"list"`

	// The version of the option.
	OptionVersion *string `type:"string"`

	// Indicate if this option is permanent.
	Permanent *bool `type:"boolean"`

	// Indicate if this option is persistent.
	Persistent *bool `type:"boolean"`

	// If required, the port configured for this option to use.
	Port *int64 `type:"integer"`

	// If the option requires access to a port, then this VPC security group allows
	// access to the port.
	VpcSecurityGroupMemberships []VpcSecurityGroupMembership `locationNameList:"VpcSecurityGroupMembership" type:"list"`
}

// String returns the string representation
func (s Option) String() string {
	return awsutil.Prettify(s)
}

// A list of all available options
type OptionConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of DBSecurityGroupMembership name strings used for this option.
	DBSecurityGroupMemberships []string `locationNameList:"DBSecurityGroupName" type:"list"`

	// The configuration of options to include in a group.
	//
	// OptionName is a required field
	OptionName *string `type:"string" required:"true"`

	// The option settings to include in an option group.
	OptionSettings []OptionSetting `locationNameList:"OptionSetting" type:"list"`

	// The version for the option.
	OptionVersion *string `type:"string"`

	// The optional port for the option.
	Port *int64 `type:"integer"`

	// A list of VpcSecurityGroupMembership name strings used for this option.
	VpcSecurityGroupMemberships []string `locationNameList:"VpcSecurityGroupId" type:"list"`
}

// String returns the string representation
func (s OptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OptionConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OptionConfiguration"}

	if s.OptionName == nil {
		invalidParams.Add(aws.NewErrParamRequired("OptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type OptionGroup struct {
	_ struct{} `type:"structure"`

	// Indicates whether this option group can be applied to both VPC and non-VPC
	// instances. The value true indicates the option group can be applied to both
	// VPC and non-VPC instances.
	AllowsVpcAndNonVpcInstanceMemberships *bool `type:"boolean"`

	// Indicates the name of the engine that this option group can be applied to.
	EngineName *string `type:"string"`

	// Indicates the major engine version associated with this option group.
	MajorEngineVersion *string `type:"string"`

	// The Amazon Resource Name (ARN) for the option group.
	OptionGroupArn *string `type:"string"`

	// Provides a description of the option group.
	OptionGroupDescription *string `type:"string"`

	// Specifies the name of the option group.
	OptionGroupName *string `type:"string"`

	// Indicates what options are available in the option group.
	Options []Option `locationNameList:"Option" type:"list"`

	// If AllowsVpcAndNonVpcInstanceMemberships is false, this field is blank. If
	// AllowsVpcAndNonVpcInstanceMemberships is true and this field is blank, then
	// this option group can be applied to both VPC and non-VPC instances. If this
	// field contains a value, then this option group can only be applied to instances
	// that are in the VPC indicated by this field.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s OptionGroup) String() string {
	return awsutil.Prettify(s)
}

// Provides information on the option groups the DB instance is a member of.
type OptionGroupMembership struct {
	_ struct{} `type:"structure"`

	// The name of the option group that the instance belongs to.
	OptionGroupName *string `type:"string"`

	// The status of the DB instance's option group membership. Valid values are:
	// in-sync, pending-apply, pending-removal, pending-maintenance-apply, pending-maintenance-removal,
	// applying, removing, and failed.
	Status *string `type:"string"`
}

// String returns the string representation
func (s OptionGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// Available option.
type OptionGroupOption struct {
	_ struct{} `type:"structure"`

	// If the option requires a port, specifies the default port for the option.
	DefaultPort *int64 `type:"integer"`

	// The description of the option.
	Description *string `type:"string"`

	// The name of the engine that this option can be applied to.
	EngineName *string `type:"string"`

	// Indicates the major engine version that the option is available for.
	MajorEngineVersion *string `type:"string"`

	// The minimum required engine version for the option to be applied.
	MinimumRequiredMinorEngineVersion *string `type:"string"`

	// The name of the option.
	Name *string `type:"string"`

	// The option settings that are available (and the default value) for each option
	// in an option group.
	OptionGroupOptionSettings []OptionGroupOptionSetting `locationNameList:"OptionGroupOptionSetting" type:"list"`

	// The versions that are available for the option.
	OptionGroupOptionVersions []OptionVersion `locationNameList:"OptionVersion" type:"list"`

	// The options that conflict with this option.
	OptionsConflictsWith []string `locationNameList:"OptionConflictName" type:"list"`

	// The options that are prerequisites for this option.
	OptionsDependedOn []string `locationNameList:"OptionName" type:"list"`

	// Permanent options can never be removed from an option group. An option group
	// containing a permanent option can't be removed from a DB instance.
	Permanent *bool `type:"boolean"`

	// Persistent options can't be removed from an option group while DB instances
	// are associated with the option group. If you disassociate all DB instances
	// from the option group, your can remove the persistent option from the option
	// group.
	Persistent *bool `type:"boolean"`

	// Specifies whether the option requires a port.
	PortRequired *bool `type:"boolean"`

	// If true, you must enable the Auto Minor Version Upgrade setting for your
	// DB instance before you can use this option. You can enable Auto Minor Version
	// Upgrade when you first create your DB instance, or by modifying your DB instance
	// later.
	RequiresAutoMinorEngineVersionUpgrade *bool `type:"boolean"`

	// If true, you can change the option to an earlier version of the option. This
	// only applies to options that have different versions available.
	SupportsOptionVersionDowngrade *bool `type:"boolean"`

	// If true, you can only use this option with a DB instance that is in a VPC.
	VpcOnly *bool `type:"boolean"`
}

// String returns the string representation
func (s OptionGroupOption) String() string {
	return awsutil.Prettify(s)
}

// Option group option settings are used to display settings available for each
// option with their default values and other information. These values are
// used with the DescribeOptionGroupOptions action.
type OptionGroupOptionSetting struct {
	_ struct{} `type:"structure"`

	// Indicates the acceptable values for the option group option.
	AllowedValues *string `type:"string"`

	// The DB engine specific parameter type for the option group option.
	ApplyType *string `type:"string"`

	// The default value for the option group option.
	DefaultValue *string `type:"string"`

	// Boolean value where true indicates that this option group option can be changed
	// from the default value.
	IsModifiable *bool `type:"boolean"`

	// Boolean value where true indicates that a value must be specified for this
	// option setting of the option group option.
	IsRequired *bool `type:"boolean"`

	// The minimum DB engine version required for the corresponding allowed value
	// for this option setting.
	MinimumEngineVersionPerAllowedValue []MinimumEngineVersionPerAllowedValue `locationNameList:"MinimumEngineVersionPerAllowedValue" type:"list"`

	// The description of the option group option.
	SettingDescription *string `type:"string"`

	// The name of the option group option.
	SettingName *string `type:"string"`
}

// String returns the string representation
func (s OptionGroupOptionSetting) String() string {
	return awsutil.Prettify(s)
}

// Option settings are the actual settings being applied or configured for that
// option. It is used when you modify an option group or describe option groups.
// For example, the NATIVE_NETWORK_ENCRYPTION option has a setting called SQLNET.ENCRYPTION_SERVER
// that can have several different values.
type OptionSetting struct {
	_ struct{} `type:"structure"`

	// The allowed values of the option setting.
	AllowedValues *string `type:"string"`

	// The DB engine specific parameter type.
	ApplyType *string `type:"string"`

	// The data type of the option setting.
	DataType *string `type:"string"`

	// The default value of the option setting.
	DefaultValue *string `type:"string"`

	// The description of the option setting.
	Description *string `type:"string"`

	// Indicates if the option setting is part of a collection.
	IsCollection *bool `type:"boolean"`

	// A Boolean value that, when true, indicates the option setting can be modified
	// from the default.
	IsModifiable *bool `type:"boolean"`

	// The name of the option that has settings that you can set.
	Name *string `type:"string"`

	// The current value of the option setting.
	Value *string `type:"string"`
}

// String returns the string representation
func (s OptionSetting) String() string {
	return awsutil.Prettify(s)
}

// The version for an option. Option group option versions are returned by the
// DescribeOptionGroupOptions action.
type OptionVersion struct {
	_ struct{} `type:"structure"`

	// True if the version is the default version of the option, and otherwise false.
	IsDefault *bool `type:"boolean"`

	// The version of the option.
	Version *string `type:"string"`
}

// String returns the string representation
func (s OptionVersion) String() string {
	return awsutil.Prettify(s)
}

// Contains a list of available options for a DB instance.
//
// This data type is used as a response element in the DescribeOrderableDBInstanceOptions
// action.
type OrderableDBInstanceOption struct {
	_ struct{} `type:"structure"`

	// A list of Availability Zones for a DB instance.
	AvailabilityZones []AvailabilityZone `locationNameList:"AvailabilityZone" type:"list"`

	// A list of the available processor features for the DB instance class of a
	// DB instance.
	AvailableProcessorFeatures []AvailableProcessorFeature `locationNameList:"AvailableProcessorFeature" type:"list"`

	// The DB instance class for a DB instance.
	DBInstanceClass *string `type:"string"`

	// The engine type of a DB instance.
	Engine *string `type:"string"`

	// The engine version of a DB instance.
	EngineVersion *string `type:"string"`

	// The license model for a DB instance.
	LicenseModel *string `type:"string"`

	// Maximum total provisioned IOPS for a DB instance.
	MaxIopsPerDbInstance *int64 `type:"integer"`

	// Maximum provisioned IOPS per GiB for a DB instance.
	MaxIopsPerGib *float64 `type:"double"`

	// Maximum storage size for a DB instance.
	MaxStorageSize *int64 `type:"integer"`

	// Minimum total provisioned IOPS for a DB instance.
	MinIopsPerDbInstance *int64 `type:"integer"`

	// Minimum provisioned IOPS per GiB for a DB instance.
	MinIopsPerGib *float64 `type:"double"`

	// Minimum storage size for a DB instance.
	MinStorageSize *int64 `type:"integer"`

	// Indicates whether a DB instance is Multi-AZ capable.
	MultiAZCapable *bool `type:"boolean"`

	// Indicates whether a DB instance can have a Read Replica.
	ReadReplicaCapable *bool `type:"boolean"`

	// Indicates the storage type for a DB instance.
	StorageType *string `type:"string"`

	// A list of the supported DB engine modes.
	SupportedEngineModes []string `type:"list"`

	// Indicates whether a DB instance supports Enhanced Monitoring at intervals
	// from 1 to 60 seconds.
	SupportsEnhancedMonitoring *bool `type:"boolean"`

	// Indicates whether a DB instance supports IAM database authentication.
	SupportsIAMDatabaseAuthentication *bool `type:"boolean"`

	// Indicates whether a DB instance supports provisioned IOPS.
	SupportsIops *bool `type:"boolean"`

	// Whether a DB instance supports Kerberos Authentication.
	SupportsKerberosAuthentication *bool `type:"boolean"`

	// True if a DB instance supports Performance Insights, otherwise false.
	SupportsPerformanceInsights *bool `type:"boolean"`

	// Whether or not Amazon RDS can automatically scale storage for DB instances
	// that use the specified instance class.
	SupportsStorageAutoscaling *bool `type:"boolean"`

	// Indicates whether a DB instance supports encrypted storage.
	SupportsStorageEncryption *bool `type:"boolean"`

	// Indicates whether a DB instance is in a VPC.
	Vpc *bool `type:"boolean"`
}

// String returns the string representation
func (s OrderableDBInstanceOption) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a request parameter in the ModifyDBParameterGroup
// and ResetDBParameterGroup actions.
//
// This data type is used as a response element in the DescribeEngineDefaultParameters
// and DescribeDBParameters actions.
type Parameter struct {
	_ struct{} `type:"structure"`

	// Specifies the valid range of values for the parameter.
	AllowedValues *string `type:"string"`

	// Indicates when to apply parameter updates.
	ApplyMethod ApplyMethod `type:"string" enum:"true"`

	// Specifies the engine specific parameters type.
	ApplyType *string `type:"string"`

	// Specifies the valid data type for the parameter.
	DataType *string `type:"string"`

	// Provides a description of the parameter.
	Description *string `type:"string"`

	// Indicates whether (true) or not (false) the parameter can be modified. Some
	// parameters have security or operational implications that prevent them from
	// being changed.
	IsModifiable *bool `type:"boolean"`

	// The earliest engine version to which the parameter can apply.
	MinimumEngineVersion *string `type:"string"`

	// Specifies the name of the parameter.
	ParameterName *string `type:"string"`

	// Specifies the value of the parameter.
	ParameterValue *string `type:"string"`

	// Indicates the source of the parameter value.
	Source *string `type:"string"`

	// The valid DB engine modes.
	SupportedEngineModes []string `type:"list"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// A list of the log types whose configuration is still pending. In other words,
// these log types are in the process of being activated or deactivated.
type PendingCloudwatchLogsExports struct {
	_ struct{} `type:"structure"`

	// Log types that are in the process of being enabled. After they are enabled,
	// these log types are exported to CloudWatch Logs.
	LogTypesToDisable []string `type:"list"`

	// Log types that are in the process of being deactivated. After they are deactivated,
	// these log types aren't exported to CloudWatch Logs.
	LogTypesToEnable []string `type:"list"`
}

// String returns the string representation
func (s PendingCloudwatchLogsExports) String() string {
	return awsutil.Prettify(s)
}

// Provides information about a pending maintenance action for a resource.
type PendingMaintenanceAction struct {
	_ struct{} `type:"structure"`

	// The type of pending maintenance action that is available for the resource.
	// Valid actions are system-update, db-upgrade, hardware-maintenance, and ca-certificate-rotation.
	Action *string `type:"string"`

	// The date of the maintenance window when the action is applied. The maintenance
	// action is applied to the resource during its first maintenance window after
	// this date.
	AutoAppliedAfterDate *time.Time `type:"timestamp"`

	// The effective date when the pending maintenance action is applied to the
	// resource. This date takes into account opt-in requests received from the
	// ApplyPendingMaintenanceAction API, the AutoAppliedAfterDate, and the ForcedApplyDate.
	// This value is blank if an opt-in request has not been received and nothing
	// has been specified as AutoAppliedAfterDate or ForcedApplyDate.
	CurrentApplyDate *time.Time `type:"timestamp"`

	// A description providing more detail about the maintenance action.
	Description *string `type:"string"`

	// The date when the maintenance action is automatically applied. The maintenance
	// action is applied to the resource on this date regardless of the maintenance
	// window for the resource.
	ForcedApplyDate *time.Time `type:"timestamp"`

	// Indicates the type of opt-in request that has been received for the resource.
	OptInStatus *string `type:"string"`
}

// String returns the string representation
func (s PendingMaintenanceAction) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the ModifyDBInstance action.
type PendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// Contains the new AllocatedStorage size for the DB instance that will be applied
	// or is currently being applied.
	AllocatedStorage *int64 `type:"integer"`

	// Specifies the pending number of days for which automated backups are retained.
	BackupRetentionPeriod *int64 `type:"integer"`

	// Specifies the identifier of the CA certificate for the DB instance.
	CACertificateIdentifier *string `type:"string"`

	// Contains the new DBInstanceClass for the DB instance that will be applied
	// or is currently being applied.
	DBInstanceClass *string `type:"string"`

	// Contains the new DBInstanceIdentifier for the DB instance that will be applied
	// or is currently being applied.
	DBInstanceIdentifier *string `type:"string"`

	// The new DB subnet group for the DB instance.
	DBSubnetGroupName *string `type:"string"`

	// Indicates the database engine version.
	EngineVersion *string `type:"string"`

	// Specifies the new Provisioned IOPS value for the DB instance that will be
	// applied or is currently being applied.
	Iops *int64 `type:"integer"`

	// The license model for the DB instance.
	//
	// Valid values: license-included | bring-your-own-license | general-public-license
	LicenseModel *string `type:"string"`

	// Contains the pending or currently-in-progress change of the master credentials
	// for the DB instance.
	MasterUserPassword *string `type:"string"`

	// Indicates that the Single-AZ DB instance is to change to a Multi-AZ deployment.
	MultiAZ *bool `type:"boolean"`

	// A list of the log types whose configuration is still pending. In other words,
	// these log types are in the process of being activated or deactivated.
	PendingCloudwatchLogsExports *PendingCloudwatchLogsExports `type:"structure"`

	// Specifies the pending port for the DB instance.
	Port *int64 `type:"integer"`

	// The number of CPU cores and the number of threads per core for the DB instance
	// class of the DB instance.
	ProcessorFeatures []ProcessorFeature `locationNameList:"ProcessorFeature" type:"list"`

	// Specifies the storage type to be associated with the DB instance.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s PendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// Contains the processor features of a DB instance class.
//
// To specify the number of CPU cores, use the coreCount feature name for the
// Name parameter. To specify the number of threads per core, use the threadsPerCore
// feature name for the Name parameter.
//
// You can set the processor features of the DB instance class for a DB instance
// when you call one of the following actions:
//
//    * CreateDBInstance
//
//    * ModifyDBInstance
//
//    * RestoreDBInstanceFromDBSnapshot
//
//    * RestoreDBInstanceFromS3
//
//    * RestoreDBInstanceToPointInTime
//
// You can view the valid processor values for a particular instance class by
// calling the DescribeOrderableDBInstanceOptions action and specifying the
// instance class for the DBInstanceClass parameter.
//
// In addition, you can use the following actions for DB instance class processor
// information:
//
//    * DescribeDBInstances
//
//    * DescribeDBSnapshots
//
//    * DescribeValidDBInstanceModifications
//
// For more information, see Configuring the Processor of the DB Instance Class
// (https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html#USER_ConfigureProcessor)
// in the Amazon RDS User Guide.
type ProcessorFeature struct {
	_ struct{} `type:"structure"`

	// The name of the processor feature. Valid names are coreCount and threadsPerCore.
	Name *string `type:"string"`

	// The value of a processor feature name.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ProcessorFeature) String() string {
	return awsutil.Prettify(s)
}

// A range of integer values.
type Range struct {
	_ struct{} `type:"structure"`

	// The minimum value in the range.
	From *int64 `type:"integer"`

	// The step value for the range. For example, if you have a range of 5,000 to
	// 10,000, with a step value of 1,000, the valid values start at 5,000 and step
	// up by 1,000. Even though 7,500 is within the range, it isn't a valid value
	// for the range. The valid values are 5,000, 6,000, 7,000, 8,000...
	Step *int64 `type:"integer"`

	// The maximum value in the range.
	To *int64 `type:"integer"`
}

// String returns the string representation
func (s Range) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the DescribeReservedDBInstances
// and DescribeReservedDBInstancesOfferings actions.
type RecurringCharge struct {
	_ struct{} `type:"structure"`

	// The amount of the recurring charge.
	RecurringChargeAmount *float64 `type:"double"`

	// The frequency of the recurring charge.
	RecurringChargeFrequency *string `type:"string"`
}

// String returns the string representation
func (s RecurringCharge) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the DescribeReservedDBInstances
// and PurchaseReservedDBInstancesOffering actions.
type ReservedDBInstance struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved DB instance.
	CurrencyCode *string `type:"string"`

	// The DB instance class for the reserved DB instance.
	DBInstanceClass *string `type:"string"`

	// The number of reserved DB instances.
	DBInstanceCount *int64 `type:"integer"`

	// The duration of the reservation in seconds.
	Duration *int64 `type:"integer"`

	// The fixed price charged for this reserved DB instance.
	FixedPrice *float64 `type:"double"`

	// The unique identifier for the lease associated with the reserved DB instance.
	//
	// AWS Support might request the lease ID for an issue related to a reserved
	// DB instance.
	LeaseId *string `type:"string"`

	// Indicates if the reservation applies to Multi-AZ deployments.
	MultiAZ *bool `type:"boolean"`

	// The offering type of this reserved DB instance.
	OfferingType *string `type:"string"`

	// The description of the reserved DB instance.
	ProductDescription *string `type:"string"`

	// The recurring price charged to run this reserved DB instance.
	RecurringCharges []RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The Amazon Resource Name (ARN) for the reserved DB instance.
	ReservedDBInstanceArn *string `type:"string"`

	// The unique identifier for the reservation.
	ReservedDBInstanceId *string `type:"string"`

	// The offering identifier.
	ReservedDBInstancesOfferingId *string `type:"string"`

	// The time the reservation started.
	StartTime *time.Time `type:"timestamp"`

	// The state of the reserved DB instance.
	State *string `type:"string"`

	// The hourly price charged for this reserved DB instance.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedDBInstance) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the DescribeReservedDBInstancesOfferings
// action.
type ReservedDBInstancesOffering struct {
	_ struct{} `type:"structure"`

	// The currency code for the reserved DB instance offering.
	CurrencyCode *string `type:"string"`

	// The DB instance class for the reserved DB instance.
	DBInstanceClass *string `type:"string"`

	// The duration of the offering in seconds.
	Duration *int64 `type:"integer"`

	// The fixed price charged for this offering.
	FixedPrice *float64 `type:"double"`

	// Indicates if the offering applies to Multi-AZ deployments.
	MultiAZ *bool `type:"boolean"`

	// The offering type.
	OfferingType *string `type:"string"`

	// The database engine used by the offering.
	ProductDescription *string `type:"string"`

	// The recurring price charged to run this reserved DB instance.
	RecurringCharges []RecurringCharge `locationNameList:"RecurringCharge" type:"list"`

	// The offering identifier.
	ReservedDBInstancesOfferingId *string `type:"string"`

	// The hourly price charged for this offering.
	UsagePrice *float64 `type:"double"`
}

// String returns the string representation
func (s ReservedDBInstancesOffering) String() string {
	return awsutil.Prettify(s)
}

// Describes the pending maintenance actions for a resource.
type ResourcePendingMaintenanceActions struct {
	_ struct{} `type:"structure"`

	// A list that provides details about the pending maintenance actions for the
	// resource.
	PendingMaintenanceActionDetails []PendingMaintenanceAction `locationNameList:"PendingMaintenanceAction" type:"list"`

	// The ARN of the resource that has pending maintenance actions.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s ResourcePendingMaintenanceActions) String() string {
	return awsutil.Prettify(s)
}

// Earliest and latest time an instance can be restored to:
type RestoreWindow struct {
	_ struct{} `type:"structure"`

	// The earliest time you can restore an instance to.
	EarliestTime *time.Time `type:"timestamp"`

	// The latest time you can restore an instance to.
	LatestTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s RestoreWindow) String() string {
	return awsutil.Prettify(s)
}

// Contains the scaling configuration of an Aurora Serverless DB cluster.
//
// For more information, see Using Amazon Aurora Serverless (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
// in the Amazon Aurora User Guide.
type ScalingConfiguration struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether to allow or disallow automatic pause for an
	// Aurora DB cluster in serverless DB engine mode. A DB cluster can be paused
	// only when it's idle (it has no connections).
	//
	// If a DB cluster is paused for more than seven days, the DB cluster might
	// be backed up with a snapshot. In this case, the DB cluster is restored when
	// there is a request to connect to it.
	AutoPause *bool `type:"boolean"`

	// The maximum capacity for an Aurora DB cluster in serverless DB engine mode.
	//
	// For Aurora MySQL, valid capacity values are 1, 2, 4, 8, 16, 32, 64, 128,
	// and 256.
	//
	// For Aurora PostgreSQL, valid capacity values are 2, 4, 8, 16, 32, 64, 192,
	// and 384.
	//
	// The maximum capacity must be greater than or equal to the minimum capacity.
	MaxCapacity *int64 `type:"integer"`

	// The minimum capacity for an Aurora DB cluster in serverless DB engine mode.
	//
	// For Aurora MySQL, valid capacity values are 1, 2, 4, 8, 16, 32, 64, 128,
	// and 256.
	//
	// For Aurora PostgreSQL, valid capacity values are 2, 4, 8, 16, 32, 64, 192,
	// and 384.
	//
	// The minimum capacity must be less than or equal to the maximum capacity.
	MinCapacity *int64 `type:"integer"`

	// The time, in seconds, before an Aurora DB cluster in serverless mode is paused.
	SecondsUntilAutoPause *int64 `type:"integer"`

	// The action to take when the timeout is reached, either ForceApplyCapacityChange
	// or RollbackCapacityChange.
	//
	// ForceApplyCapacityChange sets the capacity to the specified value as soon
	// as possible.
	//
	// RollbackCapacityChange, the default, ignores the capacity change if a scaling
	// point isn't found in the timeout period.
	//
	// If you specify ForceApplyCapacityChange, connections that prevent Aurora
	// Serverless from finding a scaling point might be dropped.
	//
	// For more information, see Autoscaling for Aurora Serverless (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.how-it-works.auto-scaling)
	// in the Amazon Aurora User Guide.
	TimeoutAction *string `type:"string"`
}

// String returns the string representation
func (s ScalingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Shows the scaling configuration for an Aurora DB cluster in serverless DB
// engine mode.
//
// For more information, see Using Amazon Aurora Serverless (https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.html)
// in the Amazon Aurora User Guide.
type ScalingConfigurationInfo struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether automatic pause is allowed for the Aurora
	// DB cluster in serverless DB engine mode.
	//
	// When the value is set to false for an Aurora Serverless DB cluster, the DB
	// cluster automatically resumes.
	AutoPause *bool `type:"boolean"`

	// The maximum capacity for an Aurora DB cluster in serverless DB engine mode.
	MaxCapacity *int64 `type:"integer"`

	// The maximum capacity for the Aurora DB cluster in serverless DB engine mode.
	MinCapacity *int64 `type:"integer"`

	// The remaining amount of time, in seconds, before the Aurora DB cluster in
	// serverless mode is paused. A DB cluster can be paused only when it's idle
	// (it has no connections).
	SecondsUntilAutoPause *int64 `type:"integer"`

	// The timeout action of a call to ModifyCurrentDBClusterCapacity, either ForceApplyCapacityChange
	// or RollbackCapacityChange.
	TimeoutAction *string `type:"string"`
}

// String returns the string representation
func (s ScalingConfigurationInfo) String() string {
	return awsutil.Prettify(s)
}

// Contains an AWS Region name as the result of a successful call to the DescribeSourceRegions
// action.
type SourceRegion struct {
	_ struct{} `type:"structure"`

	// The endpoint for the source AWS Region endpoint.
	Endpoint *string `type:"string"`

	// The name of the source AWS Region.
	RegionName *string `type:"string"`

	// The status of the source AWS Region.
	Status *string `type:"string"`
}

// String returns the string representation
func (s SourceRegion) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element in the DescribeDBSubnetGroups
// action.
type Subnet struct {
	_ struct{} `type:"structure"`

	// Contains Availability Zone information.
	//
	// This data type is used as an element in the OrderableDBInstanceOption data
	// type.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// Specifies the identifier of the subnet.
	SubnetIdentifier *string `type:"string"`

	// Specifies the status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// Metadata assigned to an Amazon RDS resource consisting of a key-value pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// A key is the required name of the tag. The string value can be from 1 to
	// 128 Unicode characters in length and can't be prefixed with "aws:" or "rds:".
	// The string can only contain only the set of Unicode letters, digits, white-space,
	// '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Key *string `type:"string"`

	// A value is the optional value of the tag. The string value can be from 1
	// to 256 Unicode characters in length and can't be prefixed with "aws:" or
	// "rds:". The string can only contain only the set of Unicode letters, digits,
	// white-space, '_', '.', '/', '=', '+', '-' (Java regex: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// A time zone associated with a DBInstance or a DBSnapshot. This data type
// is an element in the response to the DescribeDBInstances, the DescribeDBSnapshots,
// and the DescribeDBEngineVersions actions.
type Timezone struct {
	_ struct{} `type:"structure"`

	// The name of the time zone.
	TimezoneName *string `type:"string"`
}

// String returns the string representation
func (s Timezone) String() string {
	return awsutil.Prettify(s)
}

// The version of the database engine that a DB instance can be upgraded to.
type UpgradeTarget struct {
	_ struct{} `type:"structure"`

	// A value that indicates whether the target version is applied to any source
	// DB instances that have AutoMinorVersionUpgrade set to true.
	AutoUpgrade *bool `type:"boolean"`

	// The version of the database engine that a DB instance can be upgraded to.
	Description *string `type:"string"`

	// The name of the upgrade target database engine.
	Engine *string `type:"string"`

	// The version number of the upgrade target database engine.
	EngineVersion *string `type:"string"`

	// A value that indicates whether a database engine is upgraded to a major version.
	IsMajorVersionUpgrade *bool `type:"boolean"`
}

// String returns the string representation
func (s UpgradeTarget) String() string {
	return awsutil.Prettify(s)
}

//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Specifies the details of authentication used by a proxy to log in as a specific
// database user.
type UserAuthConfig struct {
	_ struct{} `type:"structure"`

	// The type of authentication that the proxy uses for connections from the proxy
	// to the underlying database.
	AuthScheme AuthScheme `type:"string" enum:"true"`

	// A user-specified description about the authentication used by a proxy to
	// log in as a specific database user.
	Description *string `type:"string"`

	// Whether to require or disallow AWS Identity and Access Management (IAM) authentication
	// for connections to the proxy.
	IAMAuth IAMAuthMode `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) representing the secret that the proxy uses
	// to authenticate to the RDS DB instance or Aurora DB cluster. These secrets
	// are stored within Amazon Secrets Manager.
	SecretArn *string `type:"string"`

	// The name of the database user to which the proxy connects.
	UserName *string `type:"string"`
}

// String returns the string representation
func (s UserAuthConfig) String() string {
	return awsutil.Prettify(s)
}

//
// This is prerelease documentation for the RDS Database Proxy feature in preview
// release. It is subject to change.
//
// Returns the details of authentication used by a proxy to log in as a specific
// database user.
type UserAuthConfigInfo struct {
	_ struct{} `type:"structure"`

	// The type of authentication that the proxy uses for connections from the proxy
	// to the underlying database.
	AuthScheme AuthScheme `type:"string" enum:"true"`

	// A user-specified description about the authentication used by a proxy to
	// log in as a specific database user.
	Description *string `type:"string"`

	// Whether to require or disallow AWS Identity and Access Management (IAM) authentication
	// for connections to the proxy.
	IAMAuth IAMAuthMode `type:"string" enum:"true"`

	// The Amazon Resource Name (ARN) representing the secret that the proxy uses
	// to authenticate to the RDS DB instance or Aurora DB cluster. These secrets
	// are stored within Amazon Secrets Manager.
	SecretArn *string `type:"string"`

	// The name of the database user to which the proxy connects.
	UserName *string `type:"string"`
}

// String returns the string representation
func (s UserAuthConfigInfo) String() string {
	return awsutil.Prettify(s)
}

// Information about valid modifications that you can make to your DB instance.
// Contains the result of a successful call to the DescribeValidDBInstanceModifications
// action. You can use this information when you call ModifyDBInstance.
type ValidDBInstanceModificationsMessage struct {
	_ struct{} `type:"structure"`

	// Valid storage options for your DB instance.
	Storage []ValidStorageOptions `locationNameList:"ValidStorageOptions" type:"list"`

	// Valid processor features for your DB instance.
	ValidProcessorFeatures []AvailableProcessorFeature `locationNameList:"AvailableProcessorFeature" type:"list"`
}

// String returns the string representation
func (s ValidDBInstanceModificationsMessage) String() string {
	return awsutil.Prettify(s)
}

// Information about valid modifications that you can make to your DB instance.
// Contains the result of a successful call to the DescribeValidDBInstanceModifications
// action.
type ValidStorageOptions struct {
	_ struct{} `type:"structure"`

	// The valid range of Provisioned IOPS to gibibytes of storage multiplier. For
	// example, 3-10, which means that provisioned IOPS can be between 3 and 10
	// times storage.
	IopsToStorageRatio []DoubleRange `locationNameList:"DoubleRange" type:"list"`

	// The valid range of provisioned IOPS. For example, 1000-20000.
	ProvisionedIops []Range `locationNameList:"Range" type:"list"`

	// The valid range of storage in gibibytes. For example, 100 to 16384.
	StorageSize []Range `locationNameList:"Range" type:"list"`

	// The valid storage types for your DB instance. For example, gp2, io1.
	StorageType *string `type:"string"`

	// Whether or not Amazon RDS can automatically scale storage for DB instances
	// that use the new instance class.
	SupportsStorageAutoscaling *bool `type:"boolean"`
}

// String returns the string representation
func (s ValidStorageOptions) String() string {
	return awsutil.Prettify(s)
}

// This data type is used as a response element for queries on VPC security
// group membership.
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The name of the VPC security group.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// Information about the virtual private network (VPN) between the VMware vSphere
// cluster and the AWS website.
//
// For more information about RDS on VMware, see the RDS on VMware User Guide.
// (https://docs.aws.amazon.com/AmazonRDS/latest/RDSonVMwareUserGuide/rds-on-vmware.html)
type VpnDetails struct {
	_ struct{} `type:"structure"`

	// The IP address of network traffic from AWS to your on-premises data center.
	VpnGatewayIp *string `type:"string"`

	// The ID of the VPN.
	VpnId *string `type:"string"`

	// The name of the VPN.
	VpnName *string `type:"string"`

	// The preshared key (PSK) for the VPN.
	VpnPSK *string `type:"string" sensitive:"true"`

	// The state of the VPN.
	VpnState *string `type:"string"`

	// The IP address of network traffic from your on-premises data center. A custom
	// AZ receives the network traffic.
	VpnTunnelOriginatorIP *string `type:"string"`
}

// String returns the string representation
func (s VpnDetails) String() string {
	return awsutil.Prettify(s)
}
