// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package managedblockchainiface provides an interface to enable mocking the Amazon Managed Blockchain service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package managedblockchainiface

import (
	"github.com/aws/aws-sdk-go-v2/service/managedblockchain"
)

// ClientAPI provides an interface to enable mocking the
// managedblockchain.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // ManagedBlockchain.
//    func myFunc(svc managedblockchainiface.ClientAPI) bool {
//        // Make svc.CreateMember request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := managedblockchain.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        managedblockchainiface.ClientPI
//    }
//    func (m *mockClientClient) CreateMember(input *managedblockchain.CreateMemberInput) (*managedblockchain.CreateMemberOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	CreateMemberRequest(*managedblockchain.CreateMemberInput) managedblockchain.CreateMemberRequest

	CreateNetworkRequest(*managedblockchain.CreateNetworkInput) managedblockchain.CreateNetworkRequest

	CreateNodeRequest(*managedblockchain.CreateNodeInput) managedblockchain.CreateNodeRequest

	CreateProposalRequest(*managedblockchain.CreateProposalInput) managedblockchain.CreateProposalRequest

	DeleteMemberRequest(*managedblockchain.DeleteMemberInput) managedblockchain.DeleteMemberRequest

	DeleteNodeRequest(*managedblockchain.DeleteNodeInput) managedblockchain.DeleteNodeRequest

	GetMemberRequest(*managedblockchain.GetMemberInput) managedblockchain.GetMemberRequest

	GetNetworkRequest(*managedblockchain.GetNetworkInput) managedblockchain.GetNetworkRequest

	GetNodeRequest(*managedblockchain.GetNodeInput) managedblockchain.GetNodeRequest

	GetProposalRequest(*managedblockchain.GetProposalInput) managedblockchain.GetProposalRequest

	ListInvitationsRequest(*managedblockchain.ListInvitationsInput) managedblockchain.ListInvitationsRequest

	ListMembersRequest(*managedblockchain.ListMembersInput) managedblockchain.ListMembersRequest

	ListNetworksRequest(*managedblockchain.ListNetworksInput) managedblockchain.ListNetworksRequest

	ListNodesRequest(*managedblockchain.ListNodesInput) managedblockchain.ListNodesRequest

	ListProposalVotesRequest(*managedblockchain.ListProposalVotesInput) managedblockchain.ListProposalVotesRequest

	ListProposalsRequest(*managedblockchain.ListProposalsInput) managedblockchain.ListProposalsRequest

	RejectInvitationRequest(*managedblockchain.RejectInvitationInput) managedblockchain.RejectInvitationRequest

	VoteOnProposalRequest(*managedblockchain.VoteOnProposalInput) managedblockchain.VoteOnProposalRequest
}

var _ ClientAPI = (*managedblockchain.Client)(nil)
