// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package machinelearning

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetMLModelInput struct {
	_ struct{} `type:"structure"`

	// The ID assigned to the MLModel at creation.
	//
	// MLModelId is a required field
	MLModelId *string `min:"1" type:"string" required:"true"`

	// Specifies whether the GetMLModel operation should return Recipe.
	//
	// If true, Recipe is returned.
	//
	// If false, Recipe is not returned.
	Verbose *bool `type:"boolean"`
}

// String returns the string representation
func (s GetMLModelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMLModelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetMLModelInput"}

	if s.MLModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MLModelId"))
	}
	if s.MLModelId != nil && len(*s.MLModelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MLModelId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of a GetMLModel operation, and provides detailed information
// about a MLModel.
type GetMLModelOutput struct {
	_ struct{} `type:"structure"`

	// The approximate CPU time in milliseconds that Amazon Machine Learning spent
	// processing the MLModel, normalized and scaled on computation resources. ComputeTime
	// is only available if the MLModel is in the COMPLETED state.
	ComputeTime *int64 `type:"long"`

	// The time that the MLModel was created. The time is expressed in epoch time.
	CreatedAt *time.Time `type:"timestamp"`

	// The AWS user account from which the MLModel was created. The account type
	// can be either an AWS root account or an AWS Identity and Access Management
	// (IAM) user account.
	CreatedByIamUser *string `type:"string"`

	// The current endpoint of the MLModel
	EndpointInfo *RealtimeEndpointInfo `type:"structure"`

	// The epoch time when Amazon Machine Learning marked the MLModel as COMPLETED
	// or FAILED. FinishedAt is only available when the MLModel is in the COMPLETED
	// or FAILED state.
	FinishedAt *time.Time `type:"timestamp"`

	// The location of the data file or directory in Amazon Simple Storage Service
	// (Amazon S3).
	InputDataLocationS3 *string `type:"string"`

	// The time of the most recent edit to the MLModel. The time is expressed in
	// epoch time.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// A link to the file that contains logs of the CreateMLModel operation.
	LogUri *string `type:"string"`

	// The MLModel ID, which is same as the MLModelId in the request.
	MLModelId *string `min:"1" type:"string"`

	// Identifies the MLModel category. The following are the available types:
	//
	//    * REGRESSION -- Produces a numeric result. For example, "What price should
	//    a house be listed at?"
	//
	//    * BINARY -- Produces one of two possible results. For example, "Is this
	//    an e-commerce website?"
	//
	//    * MULTICLASS -- Produces one of several possible results. For example,
	//    "Is this a HIGH, LOW or MEDIUM risk trade?"
	MLModelType MLModelType `type:"string" enum:"true"`

	// A description of the most recent details about accessing the MLModel.
	Message *string `type:"string"`

	// A user-supplied name or description of the MLModel.
	Name *string `type:"string"`

	// The recipe to use when training the MLModel. The Recipe provides detailed
	// information about the observation data to use during training, and manipulations
	// to perform on the observation data during training.
	//  Note
	// This parameter is provided as part of the verbose format.
	Recipe *string `type:"string"`

	// The schema used by all of the data files referenced by the DataSource.
	//  Note
	// This parameter is provided as part of the verbose format.
	Schema *string `type:"string"`

	// The scoring threshold is used in binary classification MLModel models. It
	// marks the boundary between a positive prediction and a negative prediction.
	//
	// Output values greater than or equal to the threshold receive a positive result
	// from the MLModel, such as true. Output values less than the threshold receive
	// a negative response from the MLModel, such as false.
	ScoreThreshold *float64 `type:"float"`

	// The time of the most recent edit to the ScoreThreshold. The time is expressed
	// in epoch time.
	ScoreThresholdLastUpdatedAt *time.Time `type:"timestamp"`

	// Long integer type that is a 64-bit signed number.
	SizeInBytes *int64 `type:"long"`

	// The epoch time when Amazon Machine Learning marked the MLModel as INPROGRESS.
	// StartedAt isn't available if the MLModel is in the PENDING state.
	StartedAt *time.Time `type:"timestamp"`

	// The current status of the MLModel. This element can have one of the following
	// values:
	//
	//    * PENDING - Amazon Machine Learning (Amazon ML) submitted a request to
	//    describe a MLModel.
	//
	//    * INPROGRESS - The request is processing.
	//
	//    * FAILED - The request did not run to completion. The ML model isn't usable.
	//
	//    * COMPLETED - The request completed successfully.
	//
	//    * DELETED - The MLModel is marked as deleted. It isn't usable.
	Status EntityStatus `type:"string" enum:"true"`

	// The ID of the training DataSource.
	TrainingDataSourceId *string `min:"1" type:"string"`

	// A list of the training parameters in the MLModel. The list is implemented
	// as a map of key-value pairs.
	//
	// The following is the current set of training parameters:
	//
	//    * sgd.maxMLModelSizeInBytes - The maximum allowed size of the model. Depending
	//    on the input data, the size of the model might affect its performance.
	//    The value is an integer that ranges from 100000 to 2147483648. The default
	//    value is 33554432.
	//
	//    * sgd.maxPasses - The number of times that the training process traverses
	//    the observations to build the MLModel. The value is an integer that ranges
	//    from 1 to 10000. The default value is 10.
	//
	//    * sgd.shuffleType - Whether Amazon ML shuffles the training data. Shuffling
	//    data improves a model's ability to find the optimal solution for a variety
	//    of data types. The valid values are auto and none. The default value is
	//    none. We strongly recommend that you shuffle your data.
	//
	//    * sgd.l1RegularizationAmount - The coefficient regularization L1 norm.
	//    It controls overfitting the data by penalizing large coefficients. This
	//    tends to drive coefficients to zero, resulting in a sparse feature set.
	//    If you use this parameter, start by specifying a small value, such as
	//    1.0E-08. The value is a double that ranges from 0 to MAX_DOUBLE. The default
	//    is to not use L1 normalization. This parameter can't be used when L2 is
	//    specified. Use this parameter sparingly.
	//
	//    * sgd.l2RegularizationAmount - The coefficient regularization L2 norm.
	//    It controls overfitting the data by penalizing large coefficients. This
	//    tends to drive coefficients to small, nonzero values. If you use this
	//    parameter, start by specifying a small value, such as 1.0E-08. The value
	//    is a double that ranges from 0 to MAX_DOUBLE. The default is to not use
	//    L2 normalization. This parameter can't be used when L1 is specified. Use
	//    this parameter sparingly.
	TrainingParameters map[string]string `type:"map"`
}

// String returns the string representation
func (s GetMLModelOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetMLModel = "GetMLModel"

// GetMLModelRequest returns a request value for making API operation for
// Amazon Machine Learning.
//
// Returns an MLModel that includes detailed metadata, data source information,
// and the current status of the MLModel.
//
// GetMLModel provides results in normal or verbose format.
//
//    // Example sending a request using GetMLModelRequest.
//    req := client.GetMLModelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetMLModelRequest(input *GetMLModelInput) GetMLModelRequest {
	op := &aws.Operation{
		Name:       opGetMLModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMLModelInput{}
	}

	req := c.newRequest(op, input, &GetMLModelOutput{})
	return GetMLModelRequest{Request: req, Input: input, Copy: c.GetMLModelRequest}
}

// GetMLModelRequest is the request type for the
// GetMLModel API operation.
type GetMLModelRequest struct {
	*aws.Request
	Input *GetMLModelInput
	Copy  func(*GetMLModelInput) GetMLModelRequest
}

// Send marshals and sends the GetMLModel API request.
func (r GetMLModelRequest) Send(ctx context.Context) (*GetMLModelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetMLModelResponse{
		GetMLModelOutput: r.Request.Data.(*GetMLModelOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetMLModelResponse is the response type for the
// GetMLModel API operation.
type GetMLModelResponse struct {
	*GetMLModelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetMLModel request.
func (r *GetMLModelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
