// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// Specifies the alias name. This value must begin with alias/ followed by a
	// name, such as alias/ExampleAlias. The alias name cannot begin with alias/aws/.
	// The alias/aws/ prefix is reserved for AWS managed CMKs.
	//
	// AliasName is a required field
	AliasName *string `min:"1" type:"string" required:"true"`

	// Identifies the CMK to which the alias refers. Specify the key ID or the Amazon
	// Resource Name (ARN) of the CMK. You cannot specify another alias. For help
	// finding the key ID and ARN, see Finding the Key ID and ARN (https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn)
	// in the AWS Key Management Service Developer Guide.
	//
	// TargetKeyId is a required field
	TargetKeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateAliasInput"}

	if s.AliasName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AliasName", 1))
	}

	if s.TargetKeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetKeyId"))
	}
	if s.TargetKeyId != nil && len(*s.TargetKeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Creates a display name for a customer managed customer master key (CMK).
// You can use an alias to identify a CMK in cryptographic operations, such
// as Encrypt and GenerateDataKey. You can change the CMK associated with the
// alias at any time.
//
// Aliases are easier to remember than key IDs. They can also help to simplify
// your applications. For example, if you use an alias in your code, you can
// change the CMK your code uses by associating a given alias with a different
// CMK.
//
// To run the same code in multiple AWS regions, use an alias in your code,
// such as alias/ApplicationKey. Then, in each AWS Region, create an alias/ApplicationKey
// alias that is associated with a CMK in that Region. When you run your code,
// it uses the alias/ApplicationKey CMK for that AWS Region without any Region-specific
// code.
//
// This operation does not return a response. To get the alias that you created,
// use the ListAliases operation.
//
// To use aliases successfully, be aware of the following information.
//
//    * Each alias points to only one CMK at a time, although a single CMK can
//    have multiple aliases. The alias and its associated CMK must be in the
//    same AWS account and Region.
//
//    * You can associate an alias with any customer managed CMK in the same
//    AWS account and Region. However, you do not have permission to associate
//    an alias with an AWS managed CMK (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk)
//    or an AWS owned CMK (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-owned-cmk).
//
//    * To change the CMK associated with an alias, use the UpdateAlias operation.
//    The current CMK and the new CMK must be the same type (both symmetric
//    or both asymmetric) and they must have the same key usage (ENCRYPT_DECRYPT
//    or SIGN_VERIFY). This restriction prevents cryptographic errors in code
//    that uses aliases.
//
//    * The alias name must begin with alias/ followed by a name, such as alias/ExampleAlias.
//    It can contain only alphanumeric characters, forward slashes (/), underscores
//    (_), and dashes (-). The alias name cannot begin with alias/aws/. The
//    alias/aws/ prefix is reserved for AWS managed CMKs (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
//
//    * The alias name must be unique within an AWS Region. However, you can
//    use the same alias name in multiple Regions of the same AWS account. Each
//    instance of the alias is associated with a CMK in its Region.
//
//    * After you create an alias, you cannot change its alias name. However,
//    you can use the DeleteAlias operation to delete the alias and then create
//    a new alias with the desired name.
//
//    * You can use an alias name or alias ARN to identify a CMK in AWS KMS
//    cryptographic operations and in the DescribeKey operation. However, you
//    cannot use alias names or alias ARNs in API operations that manage CMKs,
//    such as DisableKey or GetKeyPolicy. For information about the valid CMK
//    identifiers for each AWS KMS API operation, see the descriptions of the
//    KeyId parameter in the API operation documentation.
//
// Because an alias is not a property of a CMK, you can delete and change the
// aliases of a CMK without affecting the CMK. Also, aliases do not appear in
// the response from the DescribeKey operation. To get the aliases and alias
// ARNs of CMKs in each AWS account and Region, use the ListAliases operation.
//
// The CMK that you use for this operation must be in a compatible key state.
// For details, see How Key State Affects Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
//    // Example sending a request using CreateAliasRequest.
//    req := client.CreateAliasRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateAlias
func (c *Client) CreateAliasRequest(input *CreateAliasInput) CreateAliasRequest {
	op := &aws.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	req := c.newRequest(op, input, &CreateAliasOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return CreateAliasRequest{Request: req, Input: input, Copy: c.CreateAliasRequest}
}

// CreateAliasRequest is the request type for the
// CreateAlias API operation.
type CreateAliasRequest struct {
	*aws.Request
	Input *CreateAliasInput
	Copy  func(*CreateAliasInput) CreateAliasRequest
}

// Send marshals and sends the CreateAlias API request.
func (r CreateAliasRequest) Send(ctx context.Context) (*CreateAliasResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateAliasResponse{
		CreateAliasOutput: r.Request.Data.(*CreateAliasOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateAliasResponse is the response type for the
// CreateAlias API operation.
type CreateAliasResponse struct {
	*CreateAliasOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateAlias request.
func (r *CreateAliasResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
