// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalyticsv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the running application to stop.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopApplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopApplicationInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type StopApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopApplication = "StopApplication"

// StopApplicationRequest returns a request value for making API operation for
// Amazon Kinesis Analytics.
//
// Stops the application from processing data. You can stop an application only
// if it is in the running state. You can use the DescribeApplication operation
// to find the application state.
//
//    // Example sending a request using StopApplicationRequest.
//    req := client.StopApplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/StopApplication
func (c *Client) StopApplicationRequest(input *StopApplicationInput) StopApplicationRequest {
	op := &aws.Operation{
		Name:       opStopApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopApplicationInput{}
	}

	req := c.newRequest(op, input, &StopApplicationOutput{})
	return StopApplicationRequest{Request: req, Input: input, Copy: c.StopApplicationRequest}
}

// StopApplicationRequest is the request type for the
// StopApplication API operation.
type StopApplicationRequest struct {
	*aws.Request
	Input *StopApplicationInput
	Copy  func(*StopApplicationInput) StopApplicationRequest
}

// Send marshals and sends the StopApplication API request.
func (r StopApplicationRequest) Send(ctx context.Context) (*StopApplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopApplicationResponse{
		StopApplicationOutput: r.Request.Data.(*StopApplicationOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopApplicationResponse is the response type for the
// StopApplication API operation.
type StopApplicationResponse struct {
	*StopApplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopApplication request.
func (r *StopApplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
