// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendra

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

type UpdateDataSourceInput struct {
	_ struct{} `type:"structure"`

	// Configuration information for a Amazon Kendra data source.
	Configuration *DataSourceConfiguration `type:"structure"`

	// The new description for the data source.
	Description *string `min:"1" type:"string"`

	// The unique identifier of the data source to update.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The identifier of the index that contains the data source to update.
	//
	// IndexId is a required field
	IndexId *string `min:"36" type:"string" required:"true"`

	// The name of the data source to update. The name of the data source can't
	// be updated. To rename a data source you must delete the data source and re-create
	// it.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the new role to use when the data source
	// is accessing resources on your behalf.
	RoleArn *string `min:"1" type:"string"`

	// The new update schedule for the data source.
	Schedule *string `type:"string"`
}

// String returns the string representation
func (s UpdateDataSourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataSourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDataSourceInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if s.IndexId == nil {
		invalidParams.Add(aws.NewErrParamRequired("IndexId"))
	}
	if s.IndexId != nil && len(*s.IndexId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("IndexId", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateDataSourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateDataSourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDataSource = "UpdateDataSource"

// UpdateDataSourceRequest returns a request value for making API operation for
// AWSKendraFrontendService.
//
// Updates an existing Amazon Kendra data source.
//
//    // Example sending a request using UpdateDataSourceRequest.
//    req := client.UpdateDataSourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kendra-2019-02-03/UpdateDataSource
func (c *Client) UpdateDataSourceRequest(input *UpdateDataSourceInput) UpdateDataSourceRequest {
	op := &aws.Operation{
		Name:       opUpdateDataSource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDataSourceInput{}
	}

	req := c.newRequest(op, input, &UpdateDataSourceOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UpdateDataSourceRequest{Request: req, Input: input, Copy: c.UpdateDataSourceRequest}
}

// UpdateDataSourceRequest is the request type for the
// UpdateDataSource API operation.
type UpdateDataSourceRequest struct {
	*aws.Request
	Input *UpdateDataSourceInput
	Copy  func(*UpdateDataSourceInput) UpdateDataSourceRequest
}

// Send marshals and sends the UpdateDataSource API request.
func (r UpdateDataSourceRequest) Send(ctx context.Context) (*UpdateDataSourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDataSourceResponse{
		UpdateDataSourceOutput: r.Request.Data.(*UpdateDataSourceOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDataSourceResponse is the response type for the
// UpdateDataSource API operation.
type UpdateDataSourceResponse struct {
	*UpdateDataSourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDataSource request.
func (r *UpdateDataSourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
