// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ioteventsdata

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Contains information about the errors encountered.
type BatchPutMessageErrorEntry struct {
	_ struct{} `type:"structure"`

	// The code associated with the error.
	ErrorCode ErrorCode `locationName:"errorCode" type:"string" enum:"true"`

	// More information about the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The ID of the message that caused the error. (See the value corresponding
	// to the "messageId" key in the "message" object.)
	MessageId *string `locationName:"messageId" min:"1" type:"string"`
}

// String returns the string representation
func (s BatchPutMessageErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchPutMessageErrorEntry) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ErrorCode) > 0 {
		v := s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "messageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the error that occured when attempting to update a detector.
type BatchUpdateDetectorErrorEntry struct {
	_ struct{} `type:"structure"`

	// The code of the error.
	ErrorCode ErrorCode `locationName:"errorCode" type:"string" enum:"true"`

	// A message describing the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The "messageId" of the update request that caused the error. (The value of
	// the "messageId" in the update request "Detector" object.)
	MessageId *string `locationName:"messageId" min:"1" type:"string"`
}

// String returns the string representation
func (s BatchUpdateDetectorErrorEntry) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BatchUpdateDetectorErrorEntry) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ErrorCode) > 0 {
		v := s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorCode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "errorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "messageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the detector (instance).
type Detector struct {
	_ struct{} `type:"structure"`

	// The time the detector (instance) was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The name of the detector model that created this detector (instance).
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string"`

	// The version of the detector model that created this detector (instance).
	DetectorModelVersion *string `locationName:"detectorModelVersion" min:"1" type:"string"`

	// The value of the key (identifying the device or system) that caused the creation
	// of this detector (instance).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The time the detector (instance) was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The current state of the detector (instance).
	State *DetectorState `locationName:"state" type:"structure"`
}

// String returns the string representation
func (s Detector) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Detector) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DetectorModelName != nil {
		v := *s.DetectorModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorModelVersion != nil {
		v := *s.DetectorModelVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyValue != nil {
		v := *s.KeyValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.State != nil {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "state", v, metadata)
	}
	return nil
}

// Information about the current state of the detector instance.
type DetectorState struct {
	_ struct{} `type:"structure"`

	// The name of the state.
	//
	// StateName is a required field
	StateName *string `locationName:"stateName" min:"1" type:"string" required:"true"`

	// The current state of the detector's timers.
	//
	// Timers is a required field
	Timers []Timer `locationName:"timers" type:"list" required:"true"`

	// The current values of the detector's variables.
	//
	// Variables is a required field
	Variables []Variable `locationName:"variables" type:"list" required:"true"`
}

// String returns the string representation
func (s DetectorState) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetectorState) MarshalFields(e protocol.FieldEncoder) error {
	if s.StateName != nil {
		v := *s.StateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timers != nil {
		v := s.Timers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "timers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Variables != nil {
		v := s.Variables

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "variables", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The new state, variable values, and timer settings of the detector (instance).
type DetectorStateDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the new state of the detector (instance).
	//
	// StateName is a required field
	StateName *string `locationName:"stateName" min:"1" type:"string" required:"true"`

	// The new values of the detector's timers. Any timer whose value isn't specified
	// is cleared, and its timeout event won't occur.
	//
	// Timers is a required field
	Timers []TimerDefinition `locationName:"timers" type:"list" required:"true"`

	// The new values of the detector's variables. Any variable whose value isn't
	// specified is cleared.
	//
	// Variables is a required field
	Variables []VariableDefinition `locationName:"variables" type:"list" required:"true"`
}

// String returns the string representation
func (s DetectorStateDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectorStateDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DetectorStateDefinition"}

	if s.StateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StateName"))
	}
	if s.StateName != nil && len(*s.StateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StateName", 1))
	}

	if s.Timers == nil {
		invalidParams.Add(aws.NewErrParamRequired("Timers"))
	}

	if s.Variables == nil {
		invalidParams.Add(aws.NewErrParamRequired("Variables"))
	}
	if s.Timers != nil {
		for i, v := range s.Timers {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Timers", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Variables != nil {
		for i, v := range s.Variables {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Variables", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetectorStateDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.StateName != nil {
		v := *s.StateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timers != nil {
		v := s.Timers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "timers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Variables != nil {
		v := s.Variables

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "variables", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Information about the detector state.
type DetectorStateSummary struct {
	_ struct{} `type:"structure"`

	// The name of the state.
	StateName *string `locationName:"stateName" min:"1" type:"string"`
}

// String returns the string representation
func (s DetectorStateSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetectorStateSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.StateName != nil {
		v := *s.StateName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "stateName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the detector (instance).
type DetectorSummary struct {
	_ struct{} `type:"structure"`

	// The time the detector (instance) was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp"`

	// The name of the detector model that created this detector (instance).
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string"`

	// The version of the detector model that created this detector (instance).
	DetectorModelVersion *string `locationName:"detectorModelVersion" min:"1" type:"string"`

	// The value of the key (identifying the device or system) that caused the creation
	// of this detector (instance).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The time the detector (instance) was last updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp"`

	// The current state of the detector (instance).
	State *DetectorStateSummary `locationName:"state" type:"structure"`
}

// String returns the string representation
func (s DetectorSummary) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DetectorSummary) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.DetectorModelName != nil {
		v := *s.DetectorModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorModelVersion != nil {
		v := *s.DetectorModelVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyValue != nil {
		v := *s.KeyValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdateTime != nil {
		v := *s.LastUpdateTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lastUpdateTime",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.State != nil {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "state", v, metadata)
	}
	return nil
}

// Information about a message.
type Message struct {
	_ struct{} `type:"structure"`

	// The name of the input into which the message payload is transformed.
	//
	// InputName is a required field
	InputName *string `locationName:"inputName" min:"1" type:"string" required:"true"`

	// The ID to assign to the message. Within each batch sent, each "messageId"
	// must be unique.
	//
	// MessageId is a required field
	MessageId *string `locationName:"messageId" min:"1" type:"string" required:"true"`

	// The payload of the message. This can be a JSON string or a Base-64-encoded
	// string representing binary data (in which case you must decode it).
	//
	// Payload is automatically base64 encoded/decoded by the SDK.
	//
	// Payload is a required field
	Payload []byte `locationName:"payload" type:"blob" required:"true"`
}

// String returns the string representation
func (s Message) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Message) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Message"}

	if s.InputName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputName"))
	}
	if s.InputName != nil && len(*s.InputName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputName", 1))
	}

	if s.MessageId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MessageId", 1))
	}

	if s.Payload == nil {
		invalidParams.Add(aws.NewErrParamRequired("Payload"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Message) MarshalFields(e protocol.FieldEncoder) error {
	if s.InputName != nil {
		v := *s.InputName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "inputName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "messageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Payload != nil {
		v := s.Payload

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "payload", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	return nil
}

// The current state of a timer.
type Timer struct {
	_ struct{} `type:"structure"`

	// The name of the timer.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The number of seconds which have elapsed on the timer.
	//
	// Timestamp is a required field
	Timestamp *time.Time `locationName:"timestamp" type:"timestamp" required:"true"`
}

// String returns the string representation
func (s Timer) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Timer) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Timestamp != nil {
		v := *s.Timestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "timestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	return nil
}

// The new setting of a timer.
type TimerDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the timer.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The new setting of the timer (the number of seconds before the timer elapses).
	//
	// Seconds is a required field
	Seconds *int64 `locationName:"seconds" type:"integer" required:"true"`
}

// String returns the string representation
func (s TimerDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimerDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TimerDefinition"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Seconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("Seconds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s TimerDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Seconds != nil {
		v := *s.Seconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "seconds", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Information used to update the detector (instance).
type UpdateDetectorRequest struct {
	_ struct{} `type:"structure"`

	// The name of the detector model that created the detectors (instances).
	//
	// DetectorModelName is a required field
	DetectorModelName *string `locationName:"detectorModelName" min:"1" type:"string" required:"true"`

	// The value of the input key attribute (identifying the device or system) that
	// caused the creation of this detector (instance).
	KeyValue *string `locationName:"keyValue" min:"1" type:"string"`

	// The ID to assign to the detector update "message". Each "messageId" must
	// be unique within each batch sent.
	//
	// MessageId is a required field
	MessageId *string `locationName:"messageId" min:"1" type:"string" required:"true"`

	// The new state, variable values, and timer settings of the detector (instance).
	//
	// State is a required field
	State *DetectorStateDefinition `locationName:"state" type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateDetectorRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDetectorRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDetectorRequest"}

	if s.DetectorModelName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorModelName"))
	}
	if s.DetectorModelName != nil && len(*s.DetectorModelName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DetectorModelName", 1))
	}
	if s.KeyValue != nil && len(*s.KeyValue) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyValue", 1))
	}

	if s.MessageId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MessageId"))
	}
	if s.MessageId != nil && len(*s.MessageId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MessageId", 1))
	}

	if s.State == nil {
		invalidParams.Add(aws.NewErrParamRequired("State"))
	}
	if s.State != nil {
		if err := s.State.Validate(); err != nil {
			invalidParams.AddNested("State", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateDetectorRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.DetectorModelName != nil {
		v := *s.DetectorModelName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorModelName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.KeyValue != nil {
		v := *s.KeyValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "keyValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MessageId != nil {
		v := *s.MessageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "messageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.State != nil {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "state", v, metadata)
	}
	return nil
}

// The current state of the variable.
type Variable struct {
	_ struct{} `type:"structure"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The current value of the variable.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Variable) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Variable) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The new value of the variable.
type VariableDefinition struct {
	_ struct{} `type:"structure"`

	// The name of the variable.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The new value of the variable.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s VariableDefinition) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VariableDefinition) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VariableDefinition"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VariableDefinition) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
